/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.string;

import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.elements.LayoutElement;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.content.FHContextMenu;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.WebStringCustomizationItem;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class LayoutWebString
extends LayoutElement {
    protected AdvancedButton alignmentLeftBtn;
    protected AdvancedButton alignmentRightBtn;
    protected AdvancedButton alignmentCenteredBtn;

    public LayoutWebString(WebStringCustomizationItem parent, LayoutEditorScreen handler) {
        super(parent, true, handler);
        this.setScale(this.getStringScale());
    }

    @Override
    public void init() {
        super.init();
        AdvancedButton scaleB = new AdvancedButton(0, 0, 0, 16, Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setscale", (String[])new String[0]), true, press -> PopupHandler.displayPopup((Popup)new FHTextInputPopup(new Color(0, 0, 0, 0), "\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setscale", (String[])new String[0]) + ":", CharacterFilter.getDoubleCharacterFiler(), 240, this::setScaleCallback)));
        this.rightclickMenu.addContent(scaleB);
        String sLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setshadow", (String[])new String[0]);
        if (this.getObject().shadow) {
            sLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setnoshadow", (String[])new String[0]);
        }
        AdvancedButton shadowB = new AdvancedButton(0, 0, 0, 16, sLabel, true, press -> {
            if (this.getObject().shadow) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setshadow", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().shadow = false;
            } else {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.setnoshadow", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().shadow = true;
            }
        });
        this.rightclickMenu.addContent(shadowB);
        AdvancedButton textColorButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.color", (String[])new String[0]), press -> {
            FHTextInputPopup pop = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.color", (String[])new String[0]), null, 240, call -> {
                if (call != null) {
                    if (!call.equals(this.getObject().textColorHex)) {
                        this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                    }
                    this.getObject().textColorHex = call;
                    this.getObject().textColor = RenderUtils.getColorFromHexString((String)call);
                }
            });
            if (this.getObject().textColorHex != null) {
                pop.setText(this.getObject().textColorHex);
            }
            PopupHandler.displayPopup((Popup)pop);
        });
        textColorButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.editor.elements.text.color.btn.desc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(textColorButton);
        FHContextMenu alignmentMenu = new FHContextMenu();
        alignmentMenu.setAutoclose(true);
        this.rightclickMenu.addChild(alignmentMenu);
        Object al = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.left", (String[])new String[0]);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.LEFT) {
            al = "\u00a7a" + (String)al;
        }
        this.alignmentLeftBtn = new AdvancedButton(0, 0, 0, 0, (String)al, true, press -> {
            this.getObject().alignment = CustomizationItemBase.Alignment.LEFT;
            ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.left", (String[])new String[0]));
            this.alignmentRightBtn.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.right", (String[])new String[0]));
            this.alignmentCenteredBtn.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.centered", (String[])new String[0]));
        });
        alignmentMenu.addContent(this.alignmentLeftBtn);
        Object ar = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.right", (String[])new String[0]);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.RIGHT) {
            ar = "\u00a7a" + (String)ar;
        }
        this.alignmentRightBtn = new AdvancedButton(0, 0, 0, 0, (String)ar, true, press -> {
            this.getObject().alignment = CustomizationItemBase.Alignment.RIGHT;
            ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.right", (String[])new String[0]));
            this.alignmentLeftBtn.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.left", (String[])new String[0]));
            this.alignmentCenteredBtn.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.centered", (String[])new String[0]));
        });
        alignmentMenu.addContent(this.alignmentRightBtn);
        Object ac = Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.centered", (String[])new String[0]);
        if (this.getObject().alignment == CustomizationItemBase.Alignment.CENTERED) {
            ac = "\u00a7a" + (String)ac;
        }
        this.alignmentCenteredBtn = new AdvancedButton(0, 0, 0, 0, (String)ac, true, press -> {
            this.getObject().alignment = CustomizationItemBase.Alignment.CENTERED;
            ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.centered", (String[])new String[0]));
            this.alignmentRightBtn.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.right", (String[])new String[0]));
            this.alignmentLeftBtn.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.left", (String[])new String[0]));
        });
        alignmentMenu.addContent(this.alignmentCenteredBtn);
        AdvancedButton alignmentBtn = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment", (String[])new String[0]), true, press -> {
            alignmentMenu.setParentButton((AdvancedButton)press);
            alignmentMenu.openMenuAt(0, press.field_22761);
        });
        alignmentBtn.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.alignment.desc", (String[])new String[0]), (String)"%n%"));
        this.rightclickMenu.addContent(alignmentBtn);
        String mLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.webstring.multiline", (String[])new String[0]);
        if (this.getObject().multiline) {
            mLabel = Locals.localize((String)"drippyloadingscreen.helper.creator.webstring.nomultiline", (String[])new String[0]);
        }
        AdvancedButton multilineB = new AdvancedButton(0, 0, 0, 16, mLabel, true, press -> {
            if (this.getObject().multiline) {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.webstring.multiline", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().multiline = false;
                this.getObject().updateContent(this.getObject().value);
            } else {
                ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.webstring.nomultiline", (String[])new String[0]));
                this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
                this.getObject().multiline = true;
                this.getObject().updateContent(this.getObject().value);
            }
        });
        this.rightclickMenu.addContent(multilineB);
    }

    private float getStringScale() {
        return ((WebStringCustomizationItem)this.object).scale;
    }

    private WebStringCustomizationItem getObject() {
        return (WebStringCustomizationItem)this.object;
    }

    @Override
    public boolean isGrabberPressed() {
        return false;
    }

    @Override
    public int getActiveResizeGrabber() {
        return -1;
    }

    public void setScale(float scale) {
        if (this.getObject().scale != scale) {
            this.handler.history.saveSnapshot(this.handler.history.createSnapshot());
        }
        ((WebStringCustomizationItem)this.object).scale = scale;
    }

    public void updateContent(String url) {
        this.getObject().updateContent(url);
    }

    private void setScaleCallback(String scale) {
        if (scale == null) {
            return;
        }
        if (MathUtils.isFloat((String)scale)) {
            this.setScale(Float.valueOf(scale).floatValue());
        } else {
            LayoutEditorScreen.displayNotification("\u00a7c\u00a7l" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.scale.invalidvalue.title", (String[])new String[0]), "", Locals.localize((String)"drippyloadingscreen.helper.creator.items.string.scale.invalidvalue.desc", (String[])new String[0]), "", "", "", "", "");
        }
    }

    @Override
    public List<PropertiesSection> getProperties() {
        ArrayList<PropertiesSection> l = new ArrayList<PropertiesSection>();
        PropertiesSection p1 = new PropertiesSection("customization");
        p1.addEntry("action", "addwebtext");
        p1.addEntry("actionid", this.object.getActionId());
        if (this.object.delayAppearance) {
            p1.addEntry("delayappearance", "true");
            p1.addEntry("delayappearanceeverytime", "" + this.object.delayAppearanceEverytime);
            p1.addEntry("delayappearanceseconds", "" + this.object.delayAppearanceSec);
            if (this.object.fadeIn) {
                p1.addEntry("fadein", "true");
                p1.addEntry("fadeinspeed", "" + this.object.fadeInSpeed);
            }
        }
        p1.addEntry("url", ((WebStringCustomizationItem)this.object).rawURL);
        p1.addEntry("x", "" + this.object.posX);
        p1.addEntry("y", "" + this.object.posY);
        p1.addEntry("orientation", this.object.orientation);
        if (this.object.orientation.equals("loading-progress") && this.object.orientationElementIdentifier != null) {
            p1.addEntry("orientation_element", this.object.orientationElementIdentifier);
        }
        p1.addEntry("scale", "" + this.getObject().scale);
        p1.addEntry("shadow", "" + this.getObject().shadow);
        p1.addEntry("multiline", "" + this.getObject().multiline);
        p1.addEntry("alignment", this.getObject().alignment.key);
        p1.addEntry("textcolor", this.getObject().textColorHex);
        l.add(p1);
        return l;
    }
}

