/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.konkrete.annotations.OptifineFix;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.awt.Color;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    private static final Logger LOGGER = LogManager.getLogger((String)"drippyloadingscreen/WebTextureCustomizationItem");
    public volatile WebTextureResourceLocation texture;
    public String rawURL = "";
    public volatile boolean ready = false;

    @OptifineFix
    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = PlaceholderTextValueHelper.convertFromRaw(this.value);
                if (this.width <= 0 && this.height <= 0) {
                    this.width = 100;
                }
                new Thread(() -> {
                    try {
                        if (WebTextureCustomizationItem.isValidUrl(this.value)) {
                            long currentTime;
                            this.texture = TextureHandler.getWebResource((String)this.value, (boolean)false);
                            CustomizationHandler.runTaskInMainThread(() -> {
                                try {
                                    this.texture.loadTexture();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            });
                            long startTime = System.currentTimeMillis();
                            while (!(startTime + 15000L < (currentTime = System.currentTimeMillis()) || this.texture.isReady() && this.texture.getResourceLocation() != null)) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception exception) {}
                            }
                            if (this.texture != null && this.texture.getResourceLocation() == null) {
                                this.texture = null;
                                LOGGER.error("Web texture loaded but resource location was still null! Unable to use web texture!");
                            }
                            if (this.texture == null || !this.texture.isReady()) {
                                if (this.width <= 0) {
                                    this.width = 100;
                                }
                                if (this.height <= 0) {
                                    this.width = 100;
                                }
                                this.ready = true;
                                return;
                            }
                            int w = this.texture.getWidth();
                            int h = this.texture.getHeight();
                            double ratio = (double)w / (double)h;
                            if (this.width < 0 && this.height >= 0) {
                                this.width = (int)((double)this.height * ratio);
                            }
                            if (this.height < 0 && this.width >= 0) {
                                this.height = (int)((double)this.width / ratio);
                            }
                        }
                        this.ready = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
    }

    @Override
    public void render(class_4587 matrix) {
        if (this.shouldRender()) {
            int x = this.getPosX();
            int y = this.getPosY();
            if (this.isTextureReady()) {
                RenderUtils.bindTexture((class_2960)this.texture.getResourceLocation());
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                WebTextureCustomizationItem.method_25290((class_4587)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
                RenderSystem.disableBlend();
            } else if (WebTextureCustomizationItem.isEditorActive()) {
                WebTextureCustomizationItem.method_25294((class_4587)matrix, (int)this.getPosX(), (int)this.getPosY(), (int)(this.getPosX() + this.width), (int)(this.getPosY() + this.height), (int)Color.MAGENTA.getRGB());
                if (this.ready) {
                    class_327 class_3272 = class_310.method_1551().field_1772;
                    int n = this.getPosX() + this.width / 2;
                    int n2 = this.getPosY() + this.height / 2;
                    Objects.requireNonNull(class_310.method_1551().field_1772);
                    WebTextureCustomizationItem.method_25300((class_4587)matrix, (class_327)class_3272, (String)"\u00a7lMISSING", (int)n, (int)(n2 - 9 / 2), (int)-1);
                }
            }
            if (!this.ready && WebTextureCustomizationItem.isEditorActive()) {
                class_327 class_3273 = class_310.method_1551().field_1772;
                int n = this.getPosX() + this.width / 2;
                int n3 = this.getPosY() + this.height / 2;
                Objects.requireNonNull(class_310.method_1551().field_1772);
                WebTextureCustomizationItem.method_25300((class_4587)matrix, (class_327)class_3273, (String)"\u00a7lLOADING TEXTURE..", (int)n, (int)(n3 - 9 / 2), (int)-1);
            }
        }
    }

    public boolean isTextureReady() {
        return this.texture != null && this.texture.isReady() && this.texture.getResourceLocation() != null && this.ready;
    }

    @Override
    public boolean shouldRender() {
        if (this.width < 0 || this.height < 0) {
            return false;
        }
        return super.shouldRender();
    }

    public static boolean isValidUrl(String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection)u.openConnection();
                c.addRequestProperty("User-Agent", "Mozilla/4.0");
                c.setRequestMethod("HEAD");
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e1) {
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.addRequestProperty("User-Agent", "Mozilla/4.0");
                    int r = c.getResponseCode();
                    if (r == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }
}

