/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio;

import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.audio.AudioHandler;
import de.keksuccino.auudio.audio.VanillaSoundUtils;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.CustomizationHelperScreen;
import de.keksuccino.drippyloadingscreen.customization.helper.editor.LayoutEditorScreen;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.AudioCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.rendering.splash.SplashCustomizationLayer;
import de.keksuccino.drippyloadingscreen.events.CustomizationSystemReloadedEvent;
import de.keksuccino.konkrete.Konkrete;
import de.keksuccino.konkrete.events.SubscribeEvent;
import de.keksuccino.konkrete.events.client.ClientTickEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_4071;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ACIHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"drippyloadingscreen/ACIHandler");
    public static volatile boolean allowSoundEngineReload = false;
    public static volatile boolean earlySoungEngineReload = true;
    public static List<String> lastPlayingAudioSources = new ArrayList<String>();
    public static Map<String, AudioCustomizationItem> currentNonLoopItems = new HashMap<String, AudioCustomizationItem>();
    public static Map<String, AudioCustomizationItem> startedOncePerSessionItems = new HashMap<String, AudioCustomizationItem>();
    protected static class_4071 lastOverlay = null;
    protected static class_437 lastScreen = null;
    protected static class_1144 lastSoundManager = null;
    protected static List<Runnable> mainThreadTaskQueue = new ArrayList<Runnable>();

    public static void init() {
        Konkrete.getEventHandler().registerEventsFrom((Object)new ACIHandler());
    }

    public static void onRenderOverlay(SplashCustomizationLayer handler) {
        if (DrippyLoadingScreen.config != null) {
            class_4071 curOverlay = class_310.method_1551().method_18506();
            class_1144 curSoundManager = class_310.method_1551().method_1483();
            class_1140 engine = VanillaSoundUtils.getSoundEngine();
            if (engine != null) {
                List<AudioClip> clips;
                if (curSoundManager != null && lastSoundManager == null && curOverlay != null && (clips = ACIHandler.getAuudioClips()) != null) {
                    de.keksuccino.drippyloadingscreen.audio.AudioHandler.stopAll();
                    if (((Boolean)DrippyLoadingScreen.config.getOrDefault("custom_sound_engine_reloading", (Object)false)).booleanValue()) {
                        allowSoundEngineReload = true;
                        engine.method_4837();
                        allowSoundEngineReload = false;
                        for (AudioClip c : clips) {
                            c.prepare();
                        }
                        ACIHandler.reloadItems();
                        LOGGER.info("Sounds reloaded early, because MC sound manager already loaded!");
                    }
                }
                lastSoundManager = curSoundManager;
            }
        }
    }

    public static void reloadItems() {
        lastPlayingAudioSources.clear();
        currentNonLoopItems.clear();
        SplashCustomizationLayer handler = SplashCustomizationLayer.getInstance();
        if (handler != null) {
            List<CustomizationItemBase> background;
            List<CustomizationItemBase> foreground = handler.foregroundElements;
            if (foreground != null) {
                for (CustomizationItemBase i : foreground) {
                    if (!(i instanceof AudioCustomizationItem)) continue;
                    ((AudioCustomizationItem)i).reload();
                }
            }
            if ((background = handler.backgroundElements) != null) {
                for (CustomizationItemBase i : background) {
                    if (!(i instanceof AudioCustomizationItem)) continue;
                    ((AudioCustomizationItem)i).reload();
                }
            }
        }
    }

    @SubscribeEvent
    public void onSystemReload(CustomizationSystemReloadedEvent e) {
        lastPlayingAudioSources.clear();
        currentNonLoopItems.clear();
        de.keksuccino.drippyloadingscreen.audio.AudioHandler.stopAll();
    }

    @SubscribeEvent
    public void onTick(ClientTickEvent.Pre e) {
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.addAll(mainThreadTaskQueue);
        for (Runnable r : tasks) {
            r.run();
            mainThreadTaskQueue.remove(r);
        }
        class_4071 curOverlay = class_310.method_1551().method_18506();
        if (curOverlay == null && lastOverlay != null) {
            lastPlayingAudioSources.clear();
            currentNonLoopItems.clear();
            allowSoundEngineReload = true;
            ACIHandler.fadeOutSounds(true);
        }
        if (curOverlay != null && lastOverlay == null) {
            allowSoundEngineReload = false;
        }
        lastOverlay = curOverlay;
        class_437 curScreen = class_310.method_1551().field_1755;
        if (lastScreen instanceof CustomizationHelperScreen && !(curScreen instanceof CustomizationHelperScreen)) {
            lastPlayingAudioSources.clear();
            currentNonLoopItems.clear();
            ACIHandler.fadeOutSounds(false);
        }
        lastScreen = curScreen;
    }

    protected static List<AudioClip> getAuudioClips() {
        try {
            Field f = AudioHandler.class.getDeclaredField("clips");
            f.setAccessible(true);
            return (List)f.get(AudioHandler.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void fadeOutSounds(boolean reloadEngine) {
        new Thread(() -> {
            HashMap<AudioClip, Integer> volumes = new HashMap<AudioClip, Integer>();
            for (AudioClip audioClip : de.keksuccino.drippyloadingscreen.audio.AudioHandler.getCachedAudios()) {
                volumes.put(audioClip, audioClip.getVolume());
            }
            int vol = 100;
            while (true) {
                for (AudioClip c : de.keksuccino.drippyloadingscreen.audio.AudioHandler.getCachedAudios()) {
                    if (c.getVolume() < vol) continue;
                    c.setVolume(vol);
                }
                if ((vol -= 2) <= 0) {
                    if (reloadEngine && DrippyLoadingScreen.config != null && ((Boolean)DrippyLoadingScreen.config.getOrDefault("custom_sound_engine_reloading", (Object)false)).booleanValue()) {
                        allowSoundEngineReload = true;
                        class_1140 class_11402 = VanillaSoundUtils.getSoundEngine();
                        if (class_11402 != null) {
                            mainThreadTaskQueue.add(() -> engine.method_4837());
                        }
                    }
                    if (DrippyLoadingScreen.config != null) break;
                    LOGGER.error("Error! Drippy config was null!");
                    break;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            de.keksuccino.drippyloadingscreen.audio.AudioHandler.stopAll();
            for (AudioClip c : de.keksuccino.drippyloadingscreen.audio.AudioHandler.getCachedAudios()) {
                c.setVolume(((Integer)volumes.get(c)).intValue());
            }
        }).start();
    }

    public static boolean canPlaySounds() {
        if (class_310.method_1551().method_18506() == null && !(class_310.method_1551().field_1755 instanceof CustomizationHelperScreen)) {
            return false;
        }
        return !(class_310.method_1551().field_1755 instanceof LayoutEditorScreen);
    }
}

