/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor;

import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.auudio.util.UrlUtils;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.ChooseFilePopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHNotificationPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHTextInputPopup;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.screens.ScrollableScreen;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.AudioCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor.AudioLayoutEditorElement;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class EditAudioScreen
extends ScrollableScreen {
    protected AudioCustomizationItem.MenuAudio audio;
    protected AudioLayoutEditorElement parentElement;
    protected Consumer<AudioCustomizationItem.MenuAudio> callback;
    protected boolean isNewAudio = false;
    protected AdvancedButton doneButton;
    protected AdvancedButton cancelButton;

    public EditAudioScreen(class_437 parent, AudioLayoutEditorElement parentElement, @Nullable AudioCustomizationItem.MenuAudio audioToEdit, Consumer<AudioCustomizationItem.MenuAudio> callback) {
        super(parent, Locals.localize((String)"drippyloadingscreen.audio.add_or_edit", (String[])new String[0]));
        this.parentElement = parentElement;
        this.audio = audioToEdit;
        if (this.audio == null) {
            this.isNewAudio = true;
            this.audio = new AudioCustomizationItem.MenuAudio(null, AudioClip.SoundType.EXTERNAL_LOCAL, (AudioCustomizationItem)this.parentElement.object);
        }
        this.callback = callback;
    }

    @Override
    public boolean isOverlayButtonHovered() {
        if (this.doneButton != null && this.doneButton.method_25367()) {
            return true;
        }
        return this.cancelButton != null && this.cancelButton.method_25367();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        ArrayList oldEntries = new ArrayList();
        oldEntries.addAll(this.scrollArea.getEntries());
        for (ScrollAreaEntry e : oldEntries) {
            this.scrollArea.removeEntry(e);
        }
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.EmptySpaceEntry(this.scrollArea, 10));
        AdvancedButton chooseSourceButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"drippyloadingscreen.audio.choosesource", (String[])new String[0]), true, press -> {
            if (this.audio.soundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
                ChooseFilePopup p = new ChooseFilePopup(call -> {
                    if (call != null) {
                        File f = new File((String)call);
                        if (f.isFile() && f.getPath().toLowerCase().endsWith(".ogg")) {
                            this.audio.path = call;
                        } else {
                            FHNotificationPopup p2 = new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choosesource.file.invalid", (String[])new String[0]), (String)"%n%"));
                            PopupHandler.displayPopup((Popup)p2);
                        }
                    }
                }, "ogg");
                if (this.audio.path != null) {
                    p.setText(this.audio.path);
                }
                PopupHandler.displayPopup((Popup)p);
            } else if (this.audio.soundType == AudioClip.SoundType.EXTERNAL_WEB) {
                FHTextInputPopup p = new FHTextInputPopup(new Color(0, 0, 0, 0), Locals.localize((String)"drippyloadingscreen.audio.choosesource.url", (String[])new String[0]), null, 240, call -> {
                    if (call != null) {
                        if (UrlUtils.isValidUrl((String)call)) {
                            this.audio.path = call;
                        } else {
                            FHNotificationPopup p2 = new FHNotificationPopup(300, new Color(0, 0, 0, 0), 240, null, StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choosesource.url.invalid", (String[])new String[0]), (String)"%n%"));
                            PopupHandler.displayPopup((Popup)p2);
                        }
                    }
                });
                if (this.audio.path != null) {
                    p.setText(this.audio.path);
                }
                PopupHandler.displayPopup((Popup)p);
            }
        });
        this.scrollArea.addEntry((ScrollAreaEntry)new ScrollableScreen.ButtonEntry(this.scrollArea, chooseSourceButton));
        ScrollableScreen.TextEntry indexLabelEntry = new ScrollableScreen.TextEntry(this.scrollArea, Locals.localize((String)"drippyloadingscreen.audio.index", (String[])new String[0]), true);
        indexLabelEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.index.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)indexLabelEntry);
        AdvancedTextField indexTextField = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler()){

            public void method_25394(class_4587 p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                super.method_25394(p_93657_, p_93658_, p_93659_, p_93660_);
                if (MathUtils.isInteger((String)this.method_1882().replace(" ", ""))) {
                    EditAudioScreen.this.audio.index = Integer.parseInt(this.method_1882().replace(" ", ""));
                }
            }
        };
        indexTextField.method_1880(10000);
        indexTextField.method_1852("" + this.audio.index);
        ScrollableScreen.TextFieldEntry indexFieldEntry = new ScrollableScreen.TextFieldEntry(this.scrollArea, indexTextField);
        indexFieldEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.index.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)indexFieldEntry);
        ScrollableScreen.TextEntry volumeLabelEntry = new ScrollableScreen.TextEntry(this.scrollArea, Locals.localize((String)"drippyloadingscreen.audio.volume", (String[])new String[0]), true);
        volumeLabelEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.volume.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)volumeLabelEntry);
        AdvancedTextField volumeTextField = new AdvancedTextField(class_310.method_1551().field_1772, 0, 0, 200, 20, true, CharacterFilter.getIntegerCharacterFiler()){

            public void method_25394(class_4587 p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                super.method_25394(p_93657_, p_93658_, p_93659_, p_93660_);
                if (MathUtils.isInteger((String)this.method_1882().replace(" ", ""))) {
                    EditAudioScreen.this.audio.volume = Integer.parseInt(this.method_1882().replace(" ", ""));
                }
            }
        };
        volumeTextField.method_1880(10000);
        volumeTextField.method_1852("" + this.audio.volume);
        ScrollableScreen.TextFieldEntry volumeFieldEntry = new ScrollableScreen.TextFieldEntry(this.scrollArea, volumeTextField);
        volumeFieldEntry.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.volume.desc", (String[])new String[0]), (String)"%n%"));
        this.scrollArea.addEntry((ScrollAreaEntry)volumeFieldEntry);
        this.doneButton = new AdvancedButton(0, 0, 95, 20, Locals.localize((String)"drippyloadingscreen.done", (String[])new String[0]), true, press -> {
            this.onDone();
            class_310.method_1551().method_1507(this.parent);
        });
        UIBase.colorizeButton(this.doneButton);
        this.cancelButton = new AdvancedButton(0, 0, 95, 20, Locals.localize((String)"drippyloadingscreen.cancel", (String[])new String[0]), true, press -> {
            this.onCancel();
            class_310.method_1551().method_1507(this.parent);
        });
        UIBase.colorizeButton(this.cancelButton);
    }

    protected AudioCustomizationItem getItem() {
        return (AudioCustomizationItem)this.parentElement.object;
    }

    @Override
    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
        int xCenter = this.field_22789 / 2;
        super.method_25394(matrix, mouseX, mouseY, partialTicks);
        if (!this.isNewAudio) {
            this.doneButton.setX(xCenter - this.doneButton.method_25368() / 2);
        } else {
            this.doneButton.setX(xCenter + 5);
        }
        this.doneButton.setY(this.field_22790 - 35);
        this.doneButton.method_25394(matrix, mouseX, mouseY, partialTicks);
        if (this.isNewAudio) {
            this.cancelButton.setX(xCenter - this.cancelButton.method_25368() - 5);
            this.cancelButton.setY(this.field_22790 - 35);
            this.cancelButton.method_25394(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void method_25419() {
        if (!PopupHandler.isPopupActive()) {
            if (this.isNewAudio) {
                this.onCancel();
            } else {
                this.onDone();
            }
            super.method_25419();
        }
    }

    protected void onDone() {
        if (this.callback != null) {
            this.callback.accept(this.audio);
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public AudioCustomizationItem.MenuAudio getAudio() {
        return this.audio;
    }
}

