/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.AudioCustomizationItem;
import de.keksuccino.drippyloadingscreen.customization.items.v2.audio.editor.AudioLayoutEditorElement;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class SelectAudioScreen
extends class_437 {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected AudioLayoutEditorElement element;
    protected ScrollArea audiosScrollList;
    protected class_437 parent;
    protected AdvancedButton backButton;
    protected Consumer<AudioCustomizationItem.MenuAudio> callback;

    public SelectAudioScreen(class_437 parent, AudioLayoutEditorElement element, Consumer<AudioCustomizationItem.MenuAudio> callback) {
        super((class_2561)new class_2585(""));
        this.parent = parent;
        this.callback = callback;
        this.element = element;
        this.audiosScrollList = new ScrollArea(0, 50, 300, 0);
        this.audiosScrollList.backgroundColor = ENTRY_BACKGROUND_COLOR;
        this.backButton = new AdvancedButton(0, 0, 200, 20, Locals.localize((String)"drippyloadingscreen.back", (String[])new String[0]), true, press -> {
            this.onCancel();
            class_310.method_1551().method_1507(this.parent);
        });
        UIBase.colorizeButton(this.backButton);
    }

    protected AudioCustomizationItem getItem() {
        return (AudioCustomizationItem)this.element.object;
    }

    protected void method_25426() {
        this.updateEntries();
        this.audiosScrollList.x = this.field_22789 / 2 - 150;
        this.audiosScrollList.height = this.field_22790 - 100;
    }

    protected void updateEntries() {
        if (this.audiosScrollList != null) {
            ArrayList l = new ArrayList();
            l.addAll(this.audiosScrollList.getEntries());
            for (ScrollAreaEntry e : l) {
                this.audiosScrollList.removeEntry(e);
            }
            for (AudioCustomizationItem.MenuAudio c : this.getItem().audios) {
                this.audiosScrollList.addEntry((ScrollAreaEntry)new AudioScrollAreaEntry(this.audiosScrollList, c, this));
            }
        }
    }

    protected void onCancel() {
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public void method_25419() {
        this.onCancel();
        class_310.method_1551().method_1507(this.parent);
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25394(class_4587 matrix, int mouseX, int mouseY, float partialTicks) {
        int xCenter = this.field_22789 / 2;
        RenderSystem.enableBlend();
        SelectAudioScreen.method_25294((class_4587)matrix, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        this.audiosScrollList.render(matrix);
        SelectAudioScreen.method_25294((class_4587)matrix, (int)0, (int)0, (int)this.field_22789, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        SelectAudioScreen.method_25300((class_4587)matrix, (class_327)this.field_22793, (String)Locals.localize((String)"drippyloadingscreen.audio.choose", (String[])new String[0]), (int)(this.field_22789 / 2), (int)20, (int)-1);
        SelectAudioScreen.method_25294((class_4587)matrix, (int)0, (int)(this.field_22790 - 50), (int)this.field_22789, (int)this.field_22790, (int)HEADER_FOOTER_COLOR.getRGB());
        this.backButton.setX(xCenter - this.backButton.method_25368() / 2);
        this.backButton.setY(this.field_22790 - 35);
        this.backButton.method_25394(matrix, mouseX, mouseY, partialTicks);
        super.method_25394(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.audiosScrollList.getEntries()) {
            if (!(e instanceof AudioScrollAreaEntry) || !e.isHovered()) continue;
            String sourceTypeString = Locals.localize((String)"drippyloadingscreen.audio.sourcetype.external_local", (String[])new String[0]);
            if (((AudioScrollAreaEntry)e).audio.soundType == AudioClip.SoundType.EXTERNAL_WEB) {
                sourceTypeString = Locals.localize((String)"drippyloadingscreen.audio.sourcetype.external_web", (String[])new String[0]);
            }
            String indexString = "" + ((AudioScrollAreaEntry)e).audio.index;
            String volumeString = "" + ((AudioScrollAreaEntry)e).audio.volume;
            String[] desc = StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.audio.choose.info", (String[])new String[]{sourceTypeString, indexString, volumeString}), (String)"%n%");
            SelectAudioScreen.renderDescription(matrix, Arrays.asList(desc), mouseX, mouseY);
        }
    }

    protected static void renderDescription(class_4587 matrix, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = class_310.method_1551().field_1772.method_1727(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (class_310.method_1551().field_1755.field_22789 < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (class_310.method_1551().field_1755.field_22790 < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((class_4587)matrix, (int)600);
            SelectAudioScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : desc) {
                SelectAudioScreen.method_25303((class_4587)matrix, (class_327)class_310.method_1551().field_1772, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((class_4587)matrix);
            RenderSystem.disableBlend();
        }
    }

    protected static void renderDescriptionBackground(class_4587 matrix, int x, int y, int width, int height) {
        class_329.method_25294((class_4587)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    protected static void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(new Color(100, 100, 100), new Color(130, 130, 130), new Color(180, 180, 180), new Color(199, 199, 199), 1);
    }

    public static class AudioScrollAreaEntry
    extends ScrollAreaEntry {
        protected AudioCustomizationItem.MenuAudio audio;
        protected class_327 font;
        protected SelectAudioScreen parentScreen;
        protected boolean isMouseDown;

        public AudioScrollAreaEntry(ScrollArea parent, AudioCustomizationItem.MenuAudio audio, SelectAudioScreen parentScreen) {
            super(parent);
            this.font = class_310.method_1551().field_1772;
            this.isMouseDown = false;
            this.audio = audio;
            this.parentScreen = parentScreen;
        }

        public void renderEntry(class_4587 matrix) {
            int center = this.x + this.getWidth() / 2;
            if (!this.isHovered()) {
                AudioScrollAreaEntry.method_25294((class_4587)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            } else {
                AudioScrollAreaEntry.method_25294((class_4587)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.brighter().brighter().getRGB());
            }
            Object sourceString = this.audio.path;
            if (this.font.method_1727((String)sourceString) > this.getWidth() - 30) {
                sourceString = new StringBuilder((String)sourceString).reverse().toString();
                sourceString = this.font.method_27523((String)sourceString, this.getWidth() - 30);
                sourceString = new StringBuilder((String)sourceString).reverse().toString();
                sourceString = ".." + (String)sourceString;
            }
            AudioScrollAreaEntry.method_25300((class_4587)matrix, (class_327)this.font, (String)sourceString, (int)center, (int)(this.y + 10), (int)-1);
            this.handleSelection();
        }

        protected void handleSelection() {
            if (!PopupHandler.isPopupActive() && !this.parentScreen.backButton.method_25367()) {
                if (MouseInput.isLeftMouseDown() && !this.isMouseDown) {
                    if (this.isHovered() && this.parentScreen.callback != null) {
                        this.parentScreen.callback.accept(this.audio);
                    }
                    this.isMouseDown = true;
                }
                if (!MouseInput.isLeftMouseDown()) {
                    this.isMouseDown = false;
                }
            } else if (MouseInput.isLeftMouseDown()) {
                this.isMouseDown = true;
            }
        }

        public int getHeight() {
            return 26;
        }
    }
}

