/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.blocks.entities;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1606;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3619;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5251;
import net.minecraft.class_5712;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.config.LootrModConfig;
import net.zestyblaze.lootr.registry.LootrBlockEntityInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrShulkerBlockEntity
extends class_2621
implements ILootBlockEntity {
    public Set<UUID> openers = new HashSet<UUID>();
    protected class_2960 savedLootTable = null;
    protected long seed = -1L;
    protected UUID tileId;
    protected boolean opened;
    private class_2371<class_1799> itemStacks = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private int openCount;
    private class_2627.class_2628 animationStatus = class_2627.class_2628.field_12065;
    private float progress;
    private float progressOld;
    @Nullable
    private final class_1767 color = class_1767.field_7947;

    public LootrShulkerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public LootrShulkerBlockEntity(class_2338 pos, class_2680 state) {
        this(LootrBlockEntityInit.SPECIAL_LOOT_SHULKER, pos, state);
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, LootrShulkerBlockEntity entity) {
        entity.updateAnimation(level, pos, state);
    }

    private void updateAnimation(class_1937 level, class_2338 pos, class_2680 state) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case field_12065: {
                this.progress = 0.0f;
                break;
            }
            case field_12066: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = class_2627.class_2628.field_12063;
                    this.progress = 1.0f;
                    LootrShulkerBlockEntity.doNeighborUpdates(level, pos, state);
                }
                this.moveCollidedEntities(level, pos, state);
                break;
            }
            case field_12064: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = class_2627.class_2628.field_12065;
                this.progress = 0.0f;
                LootrShulkerBlockEntity.doNeighborUpdates(level, pos, state);
                break;
            }
            case field_12063: {
                this.progress = 1.0f;
            }
        }
    }

    public class_2627.class_2628 getAnimationStatus() {
        return this.animationStatus;
    }

    public class_238 getBoundingBox(class_2680 pState) {
        return class_1606.method_33346((class_2350)((class_2350)pState.method_11654((class_2769)class_2480.field_11496)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(class_1937 pLevel, class_2338 pPos, class_2680 pState) {
        class_2350 direction;
        class_238 aabb;
        List list;
        if (pState.method_26204() instanceof class_2480 && !(list = pLevel.method_8335(null, aabb = class_1606.method_33347((class_2350)(direction = (class_2350)pState.method_11654((class_2769)class_2480.field_11496)), (float)this.progressOld, (float)this.progress).method_996(pPos))).isEmpty()) {
            for (class_1297 entity : list) {
                if (entity.method_5657() == class_3619.field_15975) continue;
                entity.method_5784(class_1313.field_6306, new class_243((aabb.method_17939() + 0.01) * (double)direction.method_10148(), (aabb.method_17940() + 0.01) * (double)direction.method_10164(), (aabb.method_17941() + 0.01) * (double)direction.method_10165()));
            }
        }
    }

    public int method_5439() {
        return this.itemStacks.size();
    }

    public boolean method_11004(int pId, int pType) {
        if (pId == 1) {
            this.openCount = pType;
            if (pType == 0) {
                this.animationStatus = class_2627.class_2628.field_12064;
                LootrShulkerBlockEntity.doNeighborUpdates(this.method_10997(), this.field_11867, this.method_11010());
            }
            if (pType == 1) {
                this.animationStatus = class_2627.class_2628.field_12066;
                LootrShulkerBlockEntity.doNeighborUpdates(this.method_10997(), this.field_11867, this.method_11010());
            }
            return true;
        }
        return super.method_11004(pId, pType);
    }

    private static void doNeighborUpdates(class_1937 pLevel, class_2338 pPos, class_2680 pState) {
        pState.method_30101((class_1936)pLevel, pPos, 3);
    }

    public void method_5435(class_1657 pPlayer) {
        if (!pPlayer.method_7325()) {
            if (this.openCount < 0) {
                this.openCount = 0;
            }
            ++this.openCount;
            assert (this.field_11863 != null);
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.openCount);
            if (this.openCount == 1) {
                this.field_11863.method_32888((class_1297)pPlayer, class_5712.field_28176, this.field_11867);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14825, class_3419.field_15245, 0.5f, this.field_11863.field_9229.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void method_5432(class_1657 pPlayer) {
        if (!pPlayer.method_7325()) {
            --this.openCount;
            assert (this.field_11863 != null);
            this.field_11863.method_8427(this.field_11867, this.method_11010().method_26204(), 1, this.openCount);
            if (this.openCount <= 0) {
                this.field_11863.method_32888((class_1297)pPlayer, class_5712.field_28177, this.field_11867);
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14751, class_3419.field_15245, 0.5f, this.field_11863.field_9229.nextFloat() * 0.1f + 0.9f);
            }
            this.openers.add(pPlayer.method_5667());
            this.method_5431();
            this.updatePacketViaState();
        }
    }

    protected class_2561 method_17823() {
        return new class_2588("container.shulkerBox");
    }

    protected class_1703 method_5465(int pContainerId, class_1661 pInventory) {
        return null;
    }

    public void method_11014(class_2487 compound) {
        if (compound.method_10573("specialLootChest_table", 8)) {
            this.savedLootTable = new class_2960(compound.method_10558("specialLootChest_table"));
        }
        if (compound.method_10573("specialLootChest_seed", 4)) {
            this.seed = compound.method_10537("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.method_10573("LootTable", 8)) {
            this.savedLootTable = new class_2960(compound.method_10558("LootTable"));
            if (this.seed == 0L && compound.method_10573("LootTableSeed", 4)) {
                this.seed = compound.method_10537("LootTableSeed");
            }
        }
        if (compound.method_25928("tileId")) {
            this.tileId = compound.method_25926("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.method_10545("LootrOpeners")) {
            class_2499 openers = compound.method_10554("LootrOpeners", 11);
            this.openers.clear();
            for (class_2520 item : openers) {
                this.openers.add(class_2512.method_25930((class_2520)item));
            }
        }
        super.method_11014(compound);
    }

    protected void method_11007(class_2487 compound) {
        super.method_11007(compound);
        if (this.savedLootTable != null) {
            compound.method_10582("specialLootChest_table", this.savedLootTable.toString());
            compound.method_10582("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.method_10544("specialLootChest_seed", this.seed);
            compound.method_10544("LootTableSeed", this.seed);
        }
        compound.method_25927("tileId", this.getTileId());
        class_2499 list = new class_2499();
        for (UUID opener : this.openers) {
            list.add((Object)class_2512.method_25929((UUID)opener));
        }
        compound.method_10566("LootrOpeners", (class_2520)list);
    }

    protected class_2371<class_1799> method_11282() {
        return this.itemStacks;
    }

    protected void method_11281(class_2371<class_1799> pItems) {
        this.itemStacks = pItems;
    }

    public float getProgress(float pPartialTicks) {
        return class_3532.method_16439((float)pPartialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == class_2627.class_2628.field_12065;
    }

    @Override
    public class_2960 getTable() {
        return this.savedLootTable;
    }

    @Override
    public class_2338 getPosition() {
        return this.method_11016();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    @Override
    public void updatePacketViaState() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            class_2680 state = this.field_11863.method_8320(this.method_11016());
            this.field_11863.method_8413(this.method_11016(), state, state, 8);
        }
    }

    @Override
    public void setOpened(boolean opened) {
        this.opened = true;
    }

    @NotNull
    public class_2487 method_16887() {
        class_2487 result = super.method_16887();
        this.method_11007(result);
        return result;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    public void method_11289(@Nullable class_1657 player) {
    }

    @Override
    public void unpackLootTable(class_1657 player, class_1263 inventory, class_2960 overrideTable, long seed) {
        if (this.field_11863 != null && this.savedLootTable != null && this.field_11863.method_8503() != null) {
            class_52 loottable = this.field_11863.method_8503().method_3857().method_367(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == class_52.field_948) {
                LootrAPI.LOG.error("Unable to fill loot shulker in " + this.field_11863.method_27983() + " at " + this.field_11867 + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (LootrModConfig.get().debug.report_unresolved_tables) {
                    player.method_9203((class_2561)new class_2588("lootr.message.invalid_table", new Object[]{(overrideTable != null ? overrideTable : this.savedLootTable).toString()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1079)).method_10982(Boolean.valueOf(true))), class_156.field_25140);
                }
            }
            if (player instanceof class_3222) {
                class_174.field_24479.method_27993((class_3222)player, overrideTable != null ? overrideTable : this.field_12037);
            }
            class_47.class_48 builder = new class_47.class_48((class_3218)this.field_11863).method_312(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_304(LootrModConfig.get().seed.randomize_seed ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.method_303(player.method_7292()).method_312(class_181.field_1226, (Object)player);
            }
            loottable.method_329(inventory, builder.method_309(class_173.field_1179));
        }
    }

    public void method_11285(class_2960 lootTableIn, long seedIn) {
        super.method_11285(lootTableIn, seedIn);
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
    }
}

