/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.registry;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import net.zestyblaze.lootr.api.LootrAPI;
import net.zestyblaze.lootr.api.blockentity.ILootBlockEntity;
import net.zestyblaze.lootr.blocks.entities.TileTicker;
import net.zestyblaze.lootr.chunk.HandleChunk;
import net.zestyblaze.lootr.config.LootrModConfig;
import net.zestyblaze.lootr.entity.EntityTicker;
import net.zestyblaze.lootr.registry.LootrBlockInit;

public class LootrEventsInit {
    public static MinecraftServer serverInstance;

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            HandleChunk.onServerStarted();
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            serverInstance = null;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            EntityTicker.serverTick();
            TileTicker.serverTick();
        });
        ServerChunkEvents.CHUNK_LOAD.register(HandleChunk::onChunkLoad);
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (!LootrBlockInit.specialLootChests.contains(state.method_26204())) return true;
            if (LootrModConfig.get().breaking.disable_break) {
                if (player.method_31549().field_7477) {
                    if (player.method_5715()) return true;
                    player.method_9203((class_2561)new class_2588("lootr.message.cannot_break_sneak").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1075))), class_156.field_25140);
                    return false;
                }
                player.method_9203((class_2561)new class_2588("lootr.message.cannot_break").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1075))), class_156.field_25140);
                return false;
            }
            if (player.method_5715()) return true;
            player.method_9203((class_2561)new class_2588("lootr.message.should_sneak").method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1075))), class_156.field_25140);
            player.method_9203((class_2561)new class_2588("lootr.message.should_sneak2", new Object[]{new class_2588("lootr.message.should_sneak3").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1075))), class_156.field_25140);
            return false;
        });
        PlayerBlockBreakEvents.CANCELED.register((world, player, pos, state, blockEntity) -> {
            if (LootrBlockInit.specialLootChests.contains(state.method_26204())) {
                blockEntity.method_5431();
                if (blockEntity instanceof ILootBlockEntity) {
                    ILootBlockEntity lbe = (ILootBlockEntity)blockEntity;
                    lbe.updatePacketViaState();
                }
            }
        });
        if (LootrModConfig.get().debug.debugMode) {
            LootrAPI.LOG.info("Lootr: Common Registry - Events Registered");
        }
    }
}

