/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight999.t_and_t.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import de.cristelknight999.t_and_t.TT;
import de.cristelknight999.t_and_t.config.configs.FrequencyConfig;
import de.cristelknight999.t_and_t.config.configs.TTConfig;
import de.cristelknight999.t_and_t.config.r.ConfigUtil;
import de.cristelknight999.t_and_t.utils.RepositorySourceMaker;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;

public class Util {
    public static final Path STRUCTURE_PATH = TTConfig.CONFIG_PACK_PATH.resolve("data/towns_and_towers/worldgen/structure_set/");
    private static JsonObject town;
    private static JsonObject tower;
    private static JsonObject other;

    public static RepositorySourceMaker findPacks() {
        Path path = ConfigUtil.RES_T_AND_T.resolve("t_and_t_waystones_patch_1.18.2.zip");
        if (Util.isWaystonesLoaded()) {
            Util.copyFileFromJar("/resources/t_and_t_waystones_patch_1.18.2.zip", path.toString());
        } else {
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<String> packsLocations = new ArrayList<String>();
        packsLocations.add(ConfigUtil.RES_T_AND_T.toString());
        HashSet<Path> paths = new HashSet<Path>();
        packsLocations.stream().map(x$0 -> Path.of(x$0, new String[0])).forEach(paths::add);
        return new RepositorySourceMaker(nameComp -> nameComp, paths);
    }

    public static void copyFilesAndLoadConfig() {
        try {
            Files.createDirectories(STRUCTURE_PATH, new FileAttribute[0]);
            TTConfig config = TTConfig.getConfig();
            FrequencyConfig frequencyConfig = FrequencyConfig.getConfig();
            if (config.equals(TTConfig.DEFAULT) && frequencyConfig.equals(FrequencyConfig.DEFAULT)) {
                FileUtils.cleanDirectory((File)ConfigUtil.RES_T_AND_T.toFile());
                return;
            }
            Util.copyFileFromJar("/resources/pack.mcmeta", TTConfig.CONFIG_PACK_PATH.resolve("pack.mcmeta").toString());
            Util.copyFileFromJar("/assets/t_and_t/icon.png", TTConfig.CONFIG_PACK_PATH.resolve("pack.png").toString());
            String from = "/data/towns_and_towers/worldgen/structure_set/";
            FileUtils.cleanDirectory((File)STRUCTURE_PATH.toFile());
            boolean bl1 = config.villages().equals(TTConfig.DEFAULT.villages()) && frequencyConfig.villages().equals(FrequencyConfig.DEFAULT.villages());
            boolean bl2 = config.pillagerOutposts().equals(TTConfig.DEFAULT.pillagerOutposts()) && frequencyConfig.pillagerOutposts().equals(FrequencyConfig.DEFAULT.pillagerOutposts());
            boolean bl3 = config.others().equals(TTConfig.DEFAULT.others()) && frequencyConfig.others().equals(FrequencyConfig.DEFAULT.others());
            Map<String, Boolean> villages = null;
            Map<String, Boolean> outposts = null;
            Map<String, Boolean> others = null;
            try {
                if (!bl1) {
                    villages = TTConfig.villageValues();
                }
                if (!bl2) {
                    outposts = TTConfig.pillagerOutpostValues();
                }
                if (!bl3) {
                    others = TTConfig.otherValues();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (!bl1) {
                Util.copyFileFromJar(from + "towns.json", Util.getStructurePath(StructureType.TOWN));
            }
            if (!bl2) {
                Util.copyFileFromJar(from + "towers.json", Util.getStructurePath(StructureType.TOWER));
            }
            if (!bl3) {
                Util.copyFileFromJar(from + "other.json", Util.getStructurePath(StructureType.OTHER));
            }
            Map<String, Integer> mapVillages = !bl1 ? Util.readStructures(villages, StructureType.TOWN) : null;
            Map<String, Integer> mapOutposts = !bl2 ? Util.readStructures(outposts, StructureType.TOWER) : null;
            Map<String, Integer> mapOther = !bl3 ? Util.readStructures(others, StructureType.OTHER) : null;
            FileUtils.cleanDirectory((File)STRUCTURE_PATH.toFile());
            if (!bl1) {
                Util.printJsonFile(mapVillages, StructureType.TOWN);
            }
            if (!bl2) {
                Util.printJsonFile(mapOutposts, StructureType.TOWER);
            }
            if (!bl3) {
                Util.printJsonFile(mapOther, StructureType.OTHER);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printJsonFile(Map<String, Integer> map, StructureType type) throws IOException {
        JsonArray jsonList = new JsonArray();
        for (String structure : map.keySet()) {
            JsonObject e = new JsonObject();
            e.addProperty("structure", "towns_and_towers:" + structure);
            e.addProperty("weight", (Number)map.get(structure));
            jsonList.add((JsonElement)e);
        }
        try (FileWriter fileWriter = new FileWriter(Util.getStructurePath(type));
             JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
            FrequencyConfig config = FrequencyConfig.getConfig();
            if (type.equals((Object)StructureType.TOWN)) {
                object = town.deepCopy();
                object.add("structures", (JsonElement)jsonList);
                JsonObject o = object.get("placement").getAsJsonObject();
                o.addProperty("salt", (Number)config.villages().salt());
                int spacing = config.villages().spacing();
                int separation = config.villages().separation();
                if (separation >= spacing) {
                    separation = spacing - 1;
                }
                o.addProperty("spacing", (Number)spacing);
                o.addProperty("separation", (Number)separation);
                jsonWriter.jsonValue(object.toString());
            } else if (type.equals((Object)StructureType.TOWER)) {
                object = tower.deepCopy();
                object.add("structures", (JsonElement)jsonList);
                JsonObject o = object.get("placement").getAsJsonObject();
                o.addProperty("salt", (Number)config.pillagerOutposts().salt());
                int spacing = config.pillagerOutposts().spacing();
                int separation = config.pillagerOutposts().separation();
                if (separation >= spacing) {
                    separation = spacing - 1;
                }
                o.addProperty("spacing", (Number)spacing);
                o.addProperty("separation", (Number)separation);
                jsonWriter.jsonValue(object.toString());
            } else if (type.equals((Object)StructureType.OTHER)) {
                object = other.deepCopy();
                object.add("structures", (JsonElement)jsonList);
                JsonObject o = object.get("placement").getAsJsonObject();
                o.addProperty("salt", (Number)config.others().salt());
                int spacing = config.others().spacing();
                int separation = config.others().separation();
                if (separation >= spacing) {
                    separation = spacing - 1;
                }
                o.addProperty("spacing", (Number)spacing);
                o.addProperty("separation", (Number)separation);
                jsonWriter.jsonValue(object.toString());
            }
        }
    }

    public static boolean isWaystonesLoaded() {
        return FabricLoader.getInstance().isModLoaded("waystones");
    }

    public static Map<String, Integer> readStructures(Map<String, Boolean> config, StructureType type) {
        try {
            FileReader reader = new FileReader(Util.getStructurePath(type));
            JsonElement el = JsonParser.parseReader((Reader)reader);
            if (el.isJsonObject()) {
                JsonObject object = (JsonObject)el;
                if (type.equals((Object)StructureType.TOWN)) {
                    town = object;
                } else if (type.equals((Object)StructureType.TOWER)) {
                    tower = object;
                } else if (type.equals((Object)StructureType.OTHER)) {
                    other = object;
                }
                JsonArray array = object.getAsJsonArray("structures");
                Set<String> strings = config.keySet();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (JsonElement e : array) {
                    String configStructure;
                    if (!e.isJsonObject()) continue;
                    JsonObject o = (JsonObject)e;
                    String structure = o.get("structure").getAsString().split(":")[1];
                    String string = configStructure = structure.contains("/") ? structure.split("/")[1] : structure;
                    if (strings.contains(configStructure) && !config.get(configStructure).booleanValue()) continue;
                    map.put(structure, o.get("weight").getAsInt());
                }
                reader.close();
                return map;
            }
        }
        catch (JsonSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("[" + ConfigUtil.MODID_UP + "] Couldn't read config because it was no JsonObject, crashing instead");
    }

    public static String getStructurePath(StructureType type) {
        if (type.equals((Object)StructureType.TOWN)) {
            return STRUCTURE_PATH + "/towns.json";
        }
        if (type.equals((Object)StructureType.TOWER)) {
            return STRUCTURE_PATH + "/towers.json";
        }
        if (type.equals((Object)StructureType.OTHER)) {
            return STRUCTURE_PATH + "/other.json";
        }
        throw new RuntimeException("[" + ConfigUtil.MODID_UP + "] Unknown StructureType " + type + ", crashing instead");
    }

    public static void copyFileFromJar(String from, String to) {
        if (!new File(to).exists()) {
            URL inputUrl = TT.class.getResource(from);
            if (inputUrl == null) {
                throw new RuntimeException("[" + ConfigUtil.MODID_UP + "] Couldn't read resource path" + from + ", crashing instead");
            }
            File dest = new File(to);
            try {
                FileUtils.copyURLToFile((URL)inputUrl, (File)dest);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum StructureType {
        TOWN,
        TOWER,
        OTHER;

    }
}

