/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.client.AllyScreen;
import dev.ftb.mods.ftbteams.client.CreatePartyButton;
import dev.ftb.mods.ftbteams.client.InviteScreen;
import dev.ftb.mods.ftbteams.client.MemberButton;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.net.SendMessageMessage;
import dev.ftb.mods.ftbteams.net.UpdateSettingsMessage;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class MyTeamScreen
extends BaseScreen
implements NordColors {
    private final TeamProperties properties;
    private final UUID teamID;
    public Button settingsButton;
    public Button infoButton;
    public Button missingDataButton;
    public Button colorButton;
    public Button inviteButton;
    public Button allyButton;
    public Panel memberPanel;
    public Panel chatPanel;
    public TextBox chatBox;
    private static final List<TeamRank> PARTY_RANKS = List.of(TeamRank.OWNER, TeamRank.OFFICER, TeamRank.MEMBER, TeamRank.ALLY);
    private static final int MIN_MEMBER_PANEL_WIDTH = 80;

    public MyTeamScreen(TeamProperties props) {
        this.properties = props;
        this.teamID = this.getManager().selfTeam.getId();
    }

    public static void refreshIfOpen() {
        ScreenWrapper w;
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ScreenWrapper && (class_4372 = (w = (ScreenWrapper)class_4372).getGui()) instanceof MyTeamScreen) {
            MyTeamScreen mts = (MyTeamScreen)class_4372;
            if (mts.getManager().selfTeam.getId().equals(mts.teamID)) {
                mts.refreshWidgets();
            } else {
                mts.closeGui(false);
            }
        }
    }

    private ClientTeamManager getManager() {
        return ClientTeamManager.INSTANCE;
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().method_4486() * 4 / 5);
        this.setHeight(this.getScreen().method_4502() * 4 / 5);
        return true;
    }

    public void addWidgets() {
        this.settingsButton = new SettingsButton();
        this.add((Widget)this.settingsButton);
        this.infoButton = new SimpleButton((Panel)this, class_2585.field_24366, Icons.INFO, (w, mb) -> {}){

            public void addMouseOverText(TooltipList list) {
                MyTeamScreen.this.addTeamInfo(list);
            }

            public void playClickSound() {
            }
        };
        this.add((Widget)this.infoButton);
        if (ClientTeamManager.INSTANCE.selfKnownPlayer == null) {
            this.missingDataButton = new SimpleButton((Panel)this, class_2585.field_24366, Icons.CLOSE, (w, mb) -> {}){

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)new class_2588("ftbteams.missing_data").method_27692(class_124.field_1061));
                }

                public void playClickSound() {
                }
            };
            this.add((Widget)this.missingDataButton);
        }
        this.colorButton = new SimpleButton((Panel)this, (class_2561)new class_2588("gui.color"), this.properties.get(Team.COLOR).withBorder(POLAR_NIGHT_0, false), (simpleButton, mouseButton) -> {
            Color4I c = FTBTUtils.randomColor();
            this.properties.set(Team.COLOR, c);
            simpleButton.setIcon(c.withBorder(POLAR_NIGHT_0, false));
            TeamProperties properties = new TeamProperties();
            properties.set(Team.COLOR, c);
            new UpdateSettingsMessage(properties).sendToServer();
        }){

            public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
                this.icon.draw(matrixStack, x, y, w, h);
            }
        };
        this.add((Widget)this.colorButton);
        this.inviteButton = new InviteButton((Panel)this);
        this.add((Widget)this.inviteButton);
        this.allyButton = new AllyButton((Panel)this);
        this.add((Widget)this.allyButton);
        this.memberPanel = new MemberPanel();
        this.add((Widget)this.memberPanel);
        this.chatPanel = new ChatPanel();
        this.add((Widget)this.chatPanel);
        this.chatBox = new ChatBox();
        this.add((Widget)this.chatBox);
    }

    public void alignWidgets() {
        super.alignWidgets();
        this.colorButton.setPosAndSize(5, 5, 12, 12);
        this.infoButton.setPosAndSize(20, 3, 16, 16);
        if (this.missingDataButton != null) {
            this.missingDataButton.setPosAndSize(40, 3, 16, 16);
        }
        this.settingsButton.setPosAndSize(this.width - 19, 3, 16, 16);
        this.inviteButton.setPosAndSize(this.width - 37, 3, 16, 16);
        this.allyButton.setPosAndSize(this.width - 55, 3, 16, 16);
        this.memberPanel.setPosAndSize(1, 22, Math.max(this.memberPanel.width, 80), this.height - 23);
    }

    private void addTeamInfo(TooltipList list) {
        ClientTeamManager manager = this.getManager();
        if (manager != null) {
            ClientTeam team = this.getManager().selfTeam;
            list.add((class_2561)new class_2588("ftbteams.team_type." + team.getType().method_15434()).method_27692(class_124.field_1075));
            list.add((class_2561)new class_2588("ftbteams.info.id", new Object[]{new class_2585(team.getId().toString()).method_27692(class_124.field_1054)}));
            list.add((class_2561)new class_2588("ftbteams.info.short_id", new Object[]{new class_2585(team.getStringID()).method_27692(class_124.field_1054)}));
            if (!team.getOwnerID().equals(class_156.field_25140)) {
                list.add((class_2561)new class_2588("ftbteams.info.owner", new Object[]{this.getManager().getName(team.getOwnerID())}));
            }
        }
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((class_4587)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)POLAR_NIGHT_0, (boolean)true);
        POLAR_NIGHT_1.draw(matrixStack, x + 1, y + 1, w - 2, h - 2);
        POLAR_NIGHT_0.draw(matrixStack, x + 1, y + 21, w - 2, 1);
        POLAR_NIGHT_0.draw(matrixStack, x + this.memberPanel.width + 1, y + this.memberPanel.posY, 1, this.memberPanel.height);
    }

    public void drawForeground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        super.drawForeground(matrixStack, theme, x, y, w, h);
        theme.drawString(matrixStack, (Object)this.properties.get(Team.DISPLAY_NAME), (float)x + (float)w / 2.0f, (float)(y + 7), SNOW_STORM_1, 4);
    }

    public boolean keyPressed(Key key) {
        if (key.is(258)) {
            this.chatBox.setFocused(true);
            return true;
        }
        return super.keyPressed(key);
    }

    private class SettingsButton
    extends SimpleButton {
        public SettingsButton() {
            super((Panel)MyTeamScreen.this, (class_2561)new class_2588("gui.settings"), Icons.SETTINGS.withTint(NordColors.SNOW_STORM_2), (simpleButton, mouseButton) -> {
                ConfigGroup config = new ConfigGroup("ftbteamsconfig");
                HashMap subGroups = new HashMap();
                dev$ftb$mods$ftbteams$client$MyTeamScreen$this.properties.map.forEach((key, value) -> {
                    String groupName = key.id.method_12836();
                    ConfigGroup cfg = subGroups.computeIfAbsent(groupName, k -> config.getGroup(groupName));
                    key.config(cfg, value);
                });
                config.savedCallback = b -> {
                    if (b) {
                        new UpdateSettingsMessage(dev$ftb$mods$ftbteams$client$MyTeamScreen$this.properties).sendToServer();
                    }
                    MyTeamScreen.this.openGui();
                };
                new EditConfigScreen(config).openGui();
            });
        }

        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            this.drawIcon(matrixStack, theme, x, y, w, h);
        }
    }

    private static class InviteButton
    extends SimpleButton {
        public InviteButton(Panel panel) {
            super(panel, (class_2561)new class_2588("ftbteams.gui.invite"), Icons.ADD, (w, mb) -> new InviteScreen().openGui());
        }

        public boolean isEnabled() {
            if (ClientTeamManager.INSTANCE.selfTeam.getType() != TeamType.PARTY) {
                return false;
            }
            KnownClientPlayer knownPlayer = ClientTeamManager.INSTANCE.selfKnownPlayer;
            return knownPlayer != null && ClientTeamManager.INSTANCE.selfTeam.isOfficer(knownPlayer.uuid);
        }

        public boolean shouldDraw() {
            return this.isEnabled();
        }
    }

    private static class AllyButton
    extends SimpleButton {
        public AllyButton(Panel panel) {
            super(panel, (class_2561)new class_2588("ftbteams.gui.manage_allies"), Icons.FRIENDS, (w, mb) -> new AllyScreen().openGui());
        }

        public boolean isEnabled() {
            if (ClientTeamManager.INSTANCE.selfTeam.getType() != TeamType.PARTY) {
                return false;
            }
            KnownClientPlayer knownPlayer = ClientTeamManager.INSTANCE.selfKnownPlayer;
            return knownPlayer != null && ClientTeamManager.INSTANCE.selfTeam.isOfficer(knownPlayer.uuid);
        }

        public boolean shouldDraw() {
            return this.isEnabled();
        }
    }

    private class MemberPanel
    extends Panel {
        public MemberPanel() {
            super((Panel)MyTeamScreen.this);
        }

        public void addWidgets() {
            ClientTeamManager manager = MyTeamScreen.this.getManager();
            if (manager == null || manager.isInvalid()) {
                return;
            }
            PARTY_RANKS.stream().flatMap(rank -> manager.selfTeam.getRanked((TeamRank)((Object)rank)).entrySet().stream().filter(e -> e.getValue() == rank).map(e -> manager.getKnownPlayer((UUID)e.getKey())).filter(Objects::nonNull).sorted(Comparator.comparing(kcp -> kcp.name)).map(kcp -> new MemberButton(this, (KnownClientPlayer)kcp, (TeamRank)((Object)rank)))).forEach(arg_0 -> ((MemberPanel)this).add(arg_0));
            if (manager.selfTeam.getType() == TeamType.PLAYER) {
                this.add((Widget)new CreatePartyButton(this));
            }
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(1, 2, 1));
            this.width = 80;
            for (Widget widget : this.widgets) {
                this.width = Math.max(this.width, widget.width);
            }
            for (Widget widget : this.widgets) {
                widget.setX(1);
                widget.setWidth(this.width - 2);
            }
            MyTeamScreen.this.chatPanel.setPosAndSize(this.width + 3, 23, MyTeamScreen.this.width - MyTeamScreen.this.memberPanel.width - 5, MyTeamScreen.this.height - 40);
            MyTeamScreen.this.chatBox.setPosAndSize(MyTeamScreen.this.chatPanel.posX, MyTeamScreen.this.height - 15, MyTeamScreen.this.chatPanel.width, 13);
        }
    }

    private class ChatPanel
    extends Panel {
        public ChatPanel() {
            super((Panel)MyTeamScreen.this);
        }

        public void addWidgets() {
            UUID prev = null;
            ClientTeamManager manager = MyTeamScreen.this.getManager();
            if (manager == null) {
                return;
            }
            for (final TeamMessage message : manager.selfTeam.getMessageHistory()) {
                if (!message.sender.equals(prev)) {
                    this.add((Widget)new VerticalSpaceWidget((Panel)this, 2));
                    class_5250 name = manager.getName(message.sender).method_27661().method_27693(":");
                    this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText((class_2561)name));
                    prev = message.sender;
                }
                this.add((Widget)new TextField(this){

                    public void addMouseOverText(TooltipList list) {
                        list.add((class_2561)new class_2585(DateFormat.getInstance().format(new Date(message.date))));
                    }
                }.setMaxWidth(this.width).setText((class_2561)new class_2585("  ").method_10852(message.text)));
            }
            if (!this.widgets.isEmpty()) {
                this.add((Widget)new TextField((Panel)this).setMaxWidth(this.width).setText(class_2585.field_24366));
            }
        }

        public void alignWidgets() {
            this.align((WidgetLayout)new WidgetLayout.Vertical(2, 1, 1));
            this.movePanelScroll(0.0, this.getContentHeight());
        }

        public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_2.draw(matrixStack, x, y, w, h);
        }
    }

    private class ChatBox
    extends TextBox {
        public ChatBox() {
            super((Panel)MyTeamScreen.this);
        }

        public void drawTextBox(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            NordColors.POLAR_NIGHT_3.draw(matrixStack, x, y, w, h);
        }

        public void onEnterPressed() {
            new SendMessageMessage(this.getText()).sendToServer();
            this.setText("");
            this.setFocused(true);
        }
    }
}

