/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeams;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.KnownClientPlayer;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.net.SyncMessageHistoryMessage;
import dev.ftb.mods.ftbteams.net.SyncTeamsMessage;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class TeamManager {
    public static final class_5218 FOLDER_NAME = new class_5218("ftbteams");
    private static final class_5218 OLD_ID_FILE = new class_5218("data/ftbchunks/info.json");
    public static TeamManager INSTANCE;
    public final MinecraftServer server;
    private UUID id;
    private boolean shouldSave;
    final Map<UUID, PlayerTeam> knownPlayers;
    final Map<UUID, Team> teamMap;
    Map<String, Team> nameMap;
    private class_2487 extraData;

    public TeamManager(MinecraftServer s) {
        this.server = s;
        this.knownPlayers = new LinkedHashMap<UUID, PlayerTeam>();
        this.teamMap = new LinkedHashMap<UUID, Team>();
        this.extraData = new class_2487();
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public UUID getId() {
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        return this.id;
    }

    public Map<UUID, PlayerTeam> getKnownPlayers() {
        return this.knownPlayers;
    }

    public Map<UUID, Team> getTeamMap() {
        return this.teamMap;
    }

    public Collection<Team> getTeams() {
        return this.getTeamMap().values();
    }

    public Map<String, Team> getTeamNameMap() {
        if (this.nameMap == null) {
            this.nameMap = new HashMap<String, Team>();
            for (Team team : this.getTeams()) {
                this.nameMap.put(team.getStringID(), team);
            }
        }
        return this.nameMap;
    }

    @Nullable
    public Team getTeamByID(UUID uuid) {
        return uuid == class_156.field_25140 ? null : this.teamMap.get(uuid);
    }

    public PlayerTeam getInternalPlayerTeam(UUID uuid) {
        return this.knownPlayers.get(uuid);
    }

    @Nullable
    public Team getPlayerTeam(UUID uuid) {
        PlayerTeam t = this.knownPlayers.get(uuid);
        return t == null ? null : t.actualTeam;
    }

    public Team getPlayerTeam(class_3222 player) {
        return Objects.requireNonNull(this.getPlayerTeam(player.method_5667()));
    }

    public boolean arePlayersInSameTeam(class_3222 player1, class_3222 player2) {
        return this.getPlayerTeam(player1).equals(this.getPlayerTeam(player2));
    }

    public UUID getPlayerTeamID(UUID id) {
        Team t = this.getPlayerTeam(id);
        return t == null ? id : t.getId();
    }

    public void load() {
        this.id = null;
        Path directory = this.server.method_27050(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        SNBTCompoundTag dataFileTag = SNBT.read((Path)directory.resolve("ftbteams.snbt"));
        if (dataFileTag != null) {
            if (dataFileTag.method_10545("id")) {
                this.id = UUID.fromString(dataFileTag.method_10558("id"));
            }
            this.extraData = dataFileTag.method_10562("extra");
            ((Consumer)TeamManagerEvent.LOADED.invoker()).accept(new TeamManagerEvent(this));
        } else {
            Path oldFile = this.server.method_27050(OLD_ID_FILE);
            if (Files.exists(oldFile, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(oldFile);){
                    this.id = UUID.fromString(((JsonObject)new GsonBuilder().create().fromJson((Reader)reader, JsonObject.class)).get("id").getAsString());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.save();
        }
        for (TeamType type : TeamType.MAP.values()) {
            Path dir = directory.resolve(type.method_15434());
            if (!Files.exists(dir, new LinkOption[0]) || !Files.isDirectory(dir, new LinkOption[0])) continue;
            try {
                Stream<Path> s = Files.list(dir);
                try {
                    s.filter(path -> path.getFileName().toString().endsWith(".snbt")).forEach(file -> {
                        SNBTCompoundTag nbt = SNBT.read((Path)file);
                        if (nbt != null) {
                            Team team = type.factory.apply(this);
                            team.id = UUID.fromString(nbt.method_10558("id"));
                            this.teamMap.put(team.id, team);
                            team.deserializeNBT((class_2487)nbt);
                        }
                    });
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Team team : this.teamMap.values()) {
            if (!(team instanceof PlayerTeam)) continue;
            this.knownPlayers.put(team.id, (PlayerTeam)team);
        }
        for (Team team : this.teamMap.values()) {
            if (!(team instanceof PartyTeam)) continue;
            for (UUID member : team.getMembers()) {
                PlayerTeam t = this.knownPlayers.get(member);
                if (t == null) continue;
                t.actualTeam = team;
            }
        }
        FTBTeams.LOGGER.info("loaded team data: {} known players, {} teams total", (Object)this.knownPlayers.size(), (Object)this.teamMap.size());
    }

    public void save() {
        this.shouldSave = true;
        this.nameMap = null;
    }

    public void saveNow() {
        Path directory = this.server.method_27050(FOLDER_NAME);
        if (Files.notExists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.shouldSave) {
            ((Consumer)TeamManagerEvent.SAVED.invoker()).accept(new TeamManagerEvent(this));
            SNBT.write((Path)directory.resolve("ftbteams.snbt"), (class_2487)this.serializeNBT());
            this.shouldSave = false;
        }
        for (TeamType type : TeamType.MAP.values()) {
            Path path = directory.resolve(type.method_15434());
            if (!Files.notExists(path, new LinkOption[0])) continue;
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Team team : this.getTeams()) {
            if (!team.shouldSave) continue;
            SNBT.write((Path)directory.resolve(team.getType().method_15434() + "/" + team.getId() + ".snbt"), (class_2487)team.serializeNBT());
            team.shouldSave = false;
        }
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag nbt = new SNBTCompoundTag();
        nbt.method_10582("id", this.getId().toString());
        nbt.method_10566("extra", (class_2520)this.extraData);
        return nbt;
    }

    private ServerTeam createServerTeam(class_3222 player, String name) {
        ServerTeam team = new ServerTeam(this);
        team.id = UUID.randomUUID();
        this.teamMap.put(team.id, team);
        team.setProperty(Team.DISPLAY_NAME, name.isEmpty() ? team.id.toString().substring(0, 8) : name);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.onCreated(player);
        return team;
    }

    private PartyTeam createPartyTeam(class_3222 player, String name) {
        PartyTeam team = new PartyTeam(this);
        team.id = UUID.randomUUID();
        team.owner = player.method_5667();
        this.teamMap.put(team.id, team);
        team.setProperty(Team.DISPLAY_NAME, name.isEmpty() ? player.method_7334().getName() + "'s Party" : name);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.onCreated(player);
        return team;
    }

    private PlayerTeam createPlayerTeam(@Nullable class_3222 player, UUID playerId, String playerName) {
        PlayerTeam team = new PlayerTeam(this);
        team.id = playerId;
        team.playerName = playerName;
        team.setProperty(Team.DISPLAY_NAME, team.playerName);
        team.setProperty(Team.COLOR, FTBTUtils.randomColor());
        team.ranks.put(playerId, TeamRank.OWNER);
        team.onCreated(player);
        return team;
    }

    public void playerLoggedIn(@Nullable class_3222 player, UUID id, String name) {
        PlayerTeam team = this.knownPlayers.get(id);
        boolean syncToAll = false;
        FTBTeams.LOGGER.debug("player {} logged in, player team = {}", (Object)id, (Object)team);
        if (team == null) {
            FTBTeams.LOGGER.debug("creating new player team for player {}", (Object)id);
            team = this.createPlayerTeam(player, id, name);
            this.teamMap.put(id, team);
            this.knownPlayers.put(id, team);
            syncToAll = true;
            team.changedTeam(null, id, player, false);
            FTBTeams.LOGGER.debug("  - team created");
        } else if (!team.playerName.equals(name)) {
            FTBTeams.LOGGER.debug("updating player name: {} -> {}", (Object)team.playerName, (Object)name);
            team.playerName = name;
            team.save();
            this.save();
            syncToAll = true;
        }
        FTBTeams.LOGGER.debug("syncing player team data, all = {}", (Object)syncToAll);
        if (player != null) {
            this.syncAllToPlayer(player, team.actualTeam);
        }
        if (syncToAll) {
            this.syncTeamsToAll(team.actualTeam);
        }
        FTBTeams.LOGGER.debug("updating team presence");
        team.online = true;
        team.updatePresence();
        if (player != null) {
            FTBTeams.LOGGER.debug("sending team login event for {}...", (Object)player.method_5667());
            ((Consumer)TeamEvent.PLAYER_LOGGED_IN.invoker()).accept(new PlayerLoggedInAfterTeamEvent(team.actualTeam, player));
            FTBTeams.LOGGER.debug("team login event for {} sent", (Object)player.method_5667());
        }
    }

    public void playerLoggedOut(class_3222 player) {
        PlayerTeam team = this.knownPlayers.get(player.method_5667());
        if (team != null) {
            team.online = false;
            team.updatePresence();
        }
    }

    private ClientTeamManager createClientTeamManager(Collection<Team> teams) {
        ClientTeamManager clientManager = new ClientTeamManager(this.getId());
        for (Team team : teams) {
            ClientTeam t = this.teamMap.containsKey(team.getId()) ? new ClientTeam(clientManager, team) : ClientTeam.invalidTeam(clientManager, team);
            clientManager.teamMap.put(t.getId(), t);
            if (!(team instanceof PlayerTeam)) continue;
            clientManager.knownPlayers.put(team.getId(), new KnownClientPlayer((PlayerTeam)team));
        }
        return clientManager;
    }

    public void syncAllToPlayer(class_3222 player, Team selfTeam) {
        new SyncTeamsMessage(this.createClientTeamManager(this.getTeams()), selfTeam, true).sendTo(player);
        new SyncMessageHistoryMessage(selfTeam).sendTo(player);
        this.server.method_3760().method_14576(player);
    }

    public void syncTeamsToAll(Team ... teams) {
        if (teams.length == 0) {
            return;
        }
        ClientTeamManager manager = this.createClientTeamManager(Arrays.stream(teams).toList());
        for (class_3222 player : this.server.method_3760().method_14571()) {
            Team selfTeam = this.getPlayerTeam(player);
            new SyncTeamsMessage(manager, selfTeam, false).sendTo(player);
            if (teams.length <= 1) continue;
            new SyncMessageHistoryMessage(selfTeam).sendTo(player);
        }
    }

    public Pair<Integer, PartyTeam> createParty(class_3222 player, String name) throws CommandSyntaxException {
        return this.createParty(player, name, null, null);
    }

    public Pair<Integer, PartyTeam> createParty(class_3222 player, String name, @Nullable String description, @Nullable Color4I color) throws CommandSyntaxException {
        if (FTBTeamsAPI.partyCreationOverride != null) {
            throw TeamArgument.API_OVERRIDE.create();
        }
        UUID id = player.method_5667();
        Team oldTeam = this.getPlayerTeam(player);
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        PartyTeam team = this.createPartyTeam(player, name);
        if (description != null) {
            team.setProperty(TeamBase.DESCRIPTION, description);
        }
        if (color != null) {
            team.setProperty(TeamBase.COLOR, color);
        }
        playerTeam.actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        team.sendMessage(class_156.field_25140, (class_2561)new class_2588("ftbteams.message.joined", new Object[]{player.method_5477()}).method_27692(class_124.field_1054));
        team.save();
        playerTeam.ranks.remove(id);
        playerTeam.save();
        playerTeam.updatePresence();
        this.syncTeamsToAll(team, playerTeam);
        team.changedTeam(playerTeam, id, player, false);
        return Pair.of((Object)1, (Object)team);
    }

    public Pair<Integer, ServerTeam> createServer(class_2168 source, String name) throws CommandSyntaxException {
        if (name.length() < 3) {
            throw TeamArgument.NAME_TOO_SHORT.create();
        }
        ServerTeam team = this.createServerTeam(source.method_9207(), name);
        source.method_9226((class_2561)new class_2588("ftbteams.message.created_server_team", new Object[]{team.getName()}), true);
        this.syncTeamsToAll(team);
        return Pair.of((Object)1, (Object)team);
    }

    public class_2561 getName(@Nullable UUID id) {
        if (id == null || id.equals(class_156.field_25140)) {
            return new class_2585("System").method_27692(class_124.field_1076);
        }
        PlayerTeam team = this.knownPlayers.get(id);
        return new class_2585(team == null ? "Unknown" : team.playerName).method_27692(class_124.field_1054);
    }

    public class_2487 getExtraData() {
        return this.extraData;
    }
}

