/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.ConditionChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PermissionNodeChangedEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerAddedToRankEvent;
import dev.ftb.mods.ftbranks.api.event.PlayerRemovedFromRankEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.api.event.RanksReloadedEvent;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.UUID;
import net.minecraft.class_3222;

public class FTBRanksIntegration {
    private static final String MAX_CLAIMED_PERM = "ftbchunks.max_claimed";
    private static final String MAX_FORCE_LOADED_PERM = "ftbchunks.max_force_loaded";
    private static final String CHUNK_LOAD_OFFLINE_PERM = "ftbchunks.chunk_load_offline";

    public static int getMaxClaimedChunks(class_3222 player, int def) {
        return Math.max(FTBRanksAPI.getPermissionValue((class_3222)player, (String)MAX_CLAIMED_PERM).asInteger().orElse(def), 0);
    }

    public static int getMaxForceLoadedChunks(class_3222 player, int def) {
        return Math.max(FTBRanksAPI.getPermissionValue((class_3222)player, (String)MAX_FORCE_LOADED_PERM).asInteger().orElse(def), 0);
    }

    public static boolean getChunkLoadOffline(class_3222 player, boolean def) {
        return FTBRanksAPI.getPermissionValue((class_3222)player, (String)CHUNK_LOAD_OFFLINE_PERM).asBoolean().orElse(def);
    }

    public static boolean getNoWilderness(class_3222 player, boolean def) {
        return FTBRanksAPI.getPermissionValue((class_3222)player, (String)"ftbchunks.no_wilderness").asBoolean().orElse(def);
    }

    public static void registerEvents() {
        RankEvent.ADD_PLAYER.register(FTBRanksIntegration::playerAdded);
        RankEvent.REMOVE_PLAYER.register(FTBRanksIntegration::playerRemoved);
        RankEvent.PERMISSION_CHANGED.register(FTBRanksIntegration::permissionSet);
        RankEvent.RELOADED.register(FTBRanksIntegration::ranksReloaded);
        RankEvent.CONDITION_CHANGED.register(FTBRanksIntegration::conditionChanged);
    }

    private static void playerAdded(PlayerAddedToRankEvent event) {
        FTBRanksIntegration.updateForPlayer(event.getManager(), event.getPlayer());
    }

    private static void playerRemoved(PlayerRemovedFromRankEvent event) {
        FTBRanksIntegration.updateForPlayer(event.getManager(), event.getPlayer());
    }

    private static void permissionSet(PermissionNodeChangedEvent event) {
        String node = event.getNode();
        if (node.equals(MAX_CLAIMED_PERM) || node.equals(MAX_FORCE_LOADED_PERM) || node.equals(CHUNK_LOAD_OFFLINE_PERM)) {
            FTBRanksIntegration.updateAll(event.getManager());
        }
    }

    private static void ranksReloaded(RanksReloadedEvent event) {
        FTBRanksIntegration.updateAll(event.getManager());
    }

    private static void conditionChanged(ConditionChangedEvent event) {
        FTBRanksIntegration.updateAll(event.getManager());
    }

    private static void updateAll(RankManager manager) {
        if (FTBChunksAPI.isManagerLoaded()) {
            manager.getServer().method_3760().method_14571().forEach(player -> {
                FTBChunksTeamData data = FTBChunksAPI.getManager().getData((class_3222)player);
                data.setForceLoadMember(player.method_5667(), FTBRanksIntegration.getChunkLoadOffline(player, false));
            });
            FTBTeamsAPI.getManager().getTeams().forEach(team -> FTBChunksAPI.getManager().getData((Team)team).updateLimits());
        }
    }

    private static void updateForPlayer(RankManager manager, GameProfile profile) {
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)profile.getId());
        if (team != null) {
            FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(team);
            class_3222 player = manager.getServer().method_3760().method_14602(profile.getId());
            if (player != null) {
                teamData.setForceLoadMember(player.method_5667(), FTBRanksIntegration.getChunkLoadOffline(player, false));
            }
            teamData.updateLimits();
        }
    }
}

