/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.core.BiomeFTBC;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class MapManager
implements MapTask {
    public static MapManager inst;
    public final Object lock = new Object();
    public boolean invalid = false;
    public final UUID serverId;
    public final Path directory;
    private final Map<class_5321<class_1937>, MapDimension> dimensions;
    public boolean saveData;
    private final Int2ObjectOpenHashMap<class_2960> blockColorIndexMap;
    private final Object2IntOpenHashMap<class_2960> blockColorIndexMapReverse;
    private final Int2ObjectOpenHashMap<class_5321<class_1959>> biomeColorIndexMap;
    private final Int2ObjectOpenHashMap<BlockColor> blockIdToColCache;
    private final List<BiomeFTBC> biomesToRelease;

    public MapManager(UUID id, Path dir) {
        this.serverId = id;
        this.directory = dir;
        this.dimensions = new LinkedHashMap<class_5321<class_1937>, MapDimension>();
        this.saveData = false;
        this.blockColorIndexMap = new Int2ObjectOpenHashMap();
        this.blockColorIndexMap.defaultReturnValue((Object)new class_2960("minecraft:air"));
        this.blockColorIndexMapReverse = new Object2IntOpenHashMap();
        this.blockColorIndexMapReverse.defaultReturnValue(0);
        this.biomeColorIndexMap = new Int2ObjectOpenHashMap();
        this.biomeColorIndexMap.defaultReturnValue((Object)class_1972.field_9451);
        this.blockIdToColCache = new Int2ObjectOpenHashMap();
        this.biomesToRelease = new ArrayList<BiomeFTBC>();
        try {
            Path path;
            Path blockFile;
            Path dimFile = this.directory.resolve("dimensions.txt");
            if (Files.exists(dimFile, new LinkOption[0])) {
                for (String string : Files.readAllLines(dimFile)) {
                    String string2 = string.trim();
                    if (string2.length() < 3) continue;
                    class_5321 key = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(string2));
                    this.dimensions.put((class_5321<class_1937>)key, new MapDimension(this, (class_5321<class_1937>)key));
                }
            } else {
                this.saveData = true;
            }
            if (Files.exists(blockFile = this.directory.resolve("block_map.txt"), new LinkOption[0])) {
                for (String s : Files.readAllLines(blockFile)) {
                    if ((s = s.trim()).isEmpty()) continue;
                    String[] s1 = s.split(" ", 2);
                    int i = Integer.decode(s1[0]);
                    class_2960 loc = new class_2960(s1[1]);
                    this.blockColorIndexMap.put(i, (Object)loc);
                    this.blockColorIndexMapReverse.put((Object)loc, i);
                }
            } else {
                this.saveData = true;
            }
            if (Files.exists(path = this.directory.resolve("biome_map.txt"), new LinkOption[0])) {
                for (String s : Files.readAllLines(path)) {
                    if ((s = s.trim()).isEmpty()) continue;
                    String[] s1 = s.split(" ", 2);
                    int i = Integer.decode(s1[0]);
                    class_2960 loc = new class_2960(s1[1]);
                    class_5321 key = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)loc);
                    this.biomeColorIndexMap.put(i, (Object)key);
                }
            } else {
                this.saveData = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<class_5321<class_1937>, MapDimension> getDimensions() {
        Object object = this.lock;
        synchronized (object) {
            return this.dimensions;
        }
    }

    public synchronized MapDimension getDimension(class_5321<class_1937> dim) {
        return this.getDimensions().computeIfAbsent(dim, d -> new MapDimension(this, (class_5321<class_1937>)d).created());
    }

    public void release() {
        for (MapDimension dimension : this.getDimensions().values()) {
            dimension.release();
        }
        for (BiomeFTBC b : this.biomesToRelease) {
            b.setFTBCBiomeColorIndex(-1);
        }
        this.biomesToRelease.clear();
        this.blockIdToColCache.clear();
        this.invalid = true;
    }

    public void updateAllRegions(boolean save) {
        for (MapDimension dimension : this.getDimensions().values()) {
            for (MapRegion region : dimension.getRegions().values()) {
                region.update(save);
            }
        }
        FTBChunksClient.updateMinimap = true;
    }

    @Override
    public void runMapTask() throws Exception {
        List dimensionsList = this.dimensions.keySet().stream().map(key -> key.method_29177().toString()).collect(Collectors.toList());
        List blockColorIndexMapList = this.blockColorIndexMap.int2ObjectEntrySet().stream().sorted(Map.Entry.comparingByValue()).map(key -> String.format("#%06X %s", key.getIntKey(), key.getValue())).collect(Collectors.toList());
        List biomeColorIndexMapList = this.biomeColorIndexMap.int2ObjectEntrySet().stream().sorted(Comparator.comparing(o -> ((class_5321)o.getValue()).method_29177())).map(key -> String.format("#%03X %s", key.getIntKey(), ((class_5321)key.getValue()).method_29177())).collect(Collectors.toList());
        FTBChunks.EXECUTOR.execute(() -> {
            try {
                Files.write(this.directory.resolve("dimensions.txt"), (Iterable<? extends CharSequence>)dimensionsList, new OpenOption[0]);
                Files.write(this.directory.resolve("block_map.txt"), (Iterable<? extends CharSequence>)blockColorIndexMapList, new OpenOption[0]);
                Files.write(this.directory.resolve("biome_map.txt"), (Iterable<? extends CharSequence>)biomeColorIndexMapList, new OpenOption[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public int getBlockColorIndex(class_2960 id) {
        int i = this.blockColorIndexMapReverse.getInt((Object)id);
        if (i == 0) {
            Random random = new Random((long)id.method_12836().hashCode() & 0xFFFFFFFFL | ((long)id.method_12832().hashCode() & 0xFFFFFFFFL) << 32);
            i = id.hashCode() & 0xFFFFFF;
            while (i == 0 || this.blockColorIndexMap.containsKey(i)) {
                i = random.nextInt() & 0xFFFFFF;
            }
            this.blockColorIndexMap.put(i, (Object)id);
            this.blockColorIndexMapReverse.put((Object)id, i);
            this.saveData = true;
        }
        return i;
    }

    public int getBiomeColorIndex(class_2378<class_1959> biomes, class_1959 biome, Object b0) {
        BiomeFTBC b;
        BiomeFTBC biomeFTBC = b = b0 instanceof BiomeFTBC ? (BiomeFTBC)b0 : null;
        if (b == null) {
            return 0;
        }
        int i = b.getFTBCBiomeColorIndex();
        if (i == -1) {
            class_5321 key = biomes.method_29113((Object)biome).orElse(null);
            if (key == null) {
                b.setFTBCBiomeColorIndex(0);
                return 0;
            }
            for (Int2ObjectMap.Entry entry : this.biomeColorIndexMap.int2ObjectEntrySet()) {
                if (entry.getValue() != key) continue;
                i = entry.getIntKey();
                b.setFTBCBiomeColorIndex(i);
                return i;
            }
            Random random = new Random((long)key.method_29177().method_12836().hashCode() & 0xFFFFFFFFL | ((long)key.method_29177().method_12832().hashCode() & 0xFFFFFFFFL) << 32);
            i = key.method_29177().hashCode() & 0x7FF;
            while (i == 0 || this.biomeColorIndexMap.containsKey(i)) {
                i = random.nextInt() & 0x7FF;
            }
            this.biomeColorIndexMap.put(i, (Object)key);
            b.setFTBCBiomeColorIndex(i);
            this.saveData = true;
            this.biomesToRelease.add(b);
        }
        return i;
    }

    public class_2248 getBlock(int id) {
        class_2960 rl = (class_2960)this.blockColorIndexMap.get(id & 0xFFFFFF);
        class_2248 block = rl == null ? null : (class_2248)FTBChunks.BLOCK_REGISTRY.get(rl);
        return block == null ? class_2246.field_10124 : block;
    }

    public BlockColor getBlockColor(int id) {
        try {
            return (BlockColor)this.blockIdToColCache.computeIfAbsent(id & 0xFFFFFF, i -> ColorMapLoader.getBlockColor((class_2960)this.blockColorIndexMap.get(i)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return BlockColors.ERROR;
        }
    }

    public class_5321<class_1959> getBiomeKey(int id) {
        return (class_5321)this.biomeColorIndexMap.get(id & 0x7FF);
    }

    public class_1959 getBiome(class_1937 level, int id) {
        return (class_1959)level.method_30349().method_30530(class_2378.field_25114).method_29107(this.getBiomeKey(id));
    }
}

