/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public enum ClaimExpirationManager {
    INSTANCE;

    private static final long RUN_INTERVAL = 600000L;
    private static final long DAYS_TO_MILLIS = 86400000L;
    private long lastRun = 0L;

    public void tick(MinecraftServer server) {
        long now;
        if ((server.method_3780() & 0x3F) == 0 && (now = System.currentTimeMillis()) - this.lastRun > 600000L) {
            Map<UUID, List<ClaimedChunk>> chunkMap = FTBChunksAPI.getManager().getClaimedChunksByTeam();
            this.checkForIdleTeams(server, now, chunkMap);
            this.checkForTemporaryClaims(server, now, chunkMap);
            this.lastRun = now;
        }
    }

    private void checkForIdleTeams(MinecraftServer server, long now, Map<UUID, List<ClaimedChunk>> chunkMap) {
        long maxClaim = (long)((Double)FTBChunksWorldConfig.MAX_IDLE_DAYS_BEFORE_UNCLAIM.get() * 8.64E7);
        long maxForce = (long)((Double)FTBChunksWorldConfig.MAX_IDLE_DAYS_BEFORE_UNFORCE.get() * 8.64E7);
        if (maxClaim == 0L && maxForce == 0L) {
            return;
        }
        ArrayList expiredClaims = new ArrayList();
        ArrayList expiredForceloads = new ArrayList();
        chunkMap.forEach((id, chunks) -> {
            ArrayList toExpireClaims = new ArrayList();
            ArrayList toExpireForce = new ArrayList();
            chunks.forEach(cc -> {
                if (maxClaim > 0L && now - cc.teamData.getLastLoginTime() > maxClaim && cc.teamData.getTeam().getOnlineMembers().isEmpty()) {
                    toExpireClaims.add(cc);
                }
                if (maxForce > 0L && cc.isForceLoaded() && now - cc.teamData.getLastLoginTime() > maxForce && cc.teamData.getTeam().getOnlineMembers().isEmpty()) {
                    toExpireForce.add(cc);
                }
            });
            if (!toExpireClaims.isEmpty()) {
                FTBChunks.LOGGER.info("all chunk claims for team {} have expired due to team inactivity; unclaiming {} chunks", (Object)id.toString(), (Object)toExpireClaims.size());
                expiredClaims.addAll(toExpireClaims);
            }
            if (!toExpireForce.isEmpty()) {
                FTBChunks.LOGGER.info("all forceloads for team {} have expired due to team inactivity; unforcing {} chunks", (Object)id.toString(), (Object)toExpireForce.size());
                expiredForceloads.addAll(toExpireForce);
            }
        });
        class_2168 sourceStack = server.method_3739();
        HashMap<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>> toSync = new HashMap<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>>();
        if (!expiredForceloads.isEmpty()) {
            expiredForceloads.forEach(cc -> ClaimExpirationManager.unloadChunk(now, cc, toSync, sourceStack));
        }
        if (!expiredClaims.isEmpty()) {
            expiredClaims.forEach(cc -> ClaimExpirationManager.unclaimChunk(now, cc, toSync, sourceStack));
        }
        if (!toSync.isEmpty()) {
            ClaimExpirationManager.syncChunks(toSync, server, class_156.field_25140);
        }
    }

    private void checkForTemporaryClaims(MinecraftServer server, long now, Map<UUID, List<ClaimedChunk>> chunkMap) {
        chunkMap.forEach((teamId, chunks) -> {
            List<ClaimedChunk> expired = chunks.stream().filter(cc -> cc.isForceLoaded() && cc.hasExpired(now)).toList();
            if (!expired.isEmpty()) {
                FTBChunksTeamData teamData = expired.get((int)0).teamData;
                class_2168 sourceStack = server.method_3739();
                HashMap<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>> toSync = new HashMap<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>>();
                expired.forEach(cc -> {
                    FTBChunks.LOGGER.info("un-forceloading chunk {} - expiry time {} passed", cc, (Object)cc.getForceLoadExpiryTime());
                    ClaimExpirationManager.unloadChunk(now, cc, toSync, sourceStack);
                });
                ClaimExpirationManager.syncChunks(toSync, server, teamData.getTeamId());
            }
        });
    }

    private static void unclaimChunk(long now, ClaimedChunk c, Map<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>> toSync, class_2168 sourceStack) {
        c.unclaim(sourceStack, false);
        toSync.computeIfAbsent((class_5321<class_1937>)c.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, c.pos.x, c.pos.z, null));
    }

    private static void unloadChunk(long now, ClaimedChunk c, Map<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>> toSync, class_2168 sourceStack) {
        c.unload(sourceStack);
        toSync.computeIfAbsent((class_5321<class_1937>)c.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, c.pos.x, c.pos.z, c));
    }

    private static void syncChunks(Map<class_5321<class_1937>, List<SendChunkPacket.SingleChunk>> toSync, MinecraftServer server, UUID teamId) {
        toSync.forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                new SendManyChunksPacket((class_5321<class_1937>)dimension, teamId, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(server);
            }
        });
    }
}

