/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftbchunks.data.ProtectionOverride;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManager {
    public static final class_5218 DATA_DIR = new class_5218("ftbchunks");
    private static final Long2ObjectMap<UUID> EMPTY_CHUNKS = Long2ObjectMaps.emptyMap();
    private final TeamManager teamManager;
    private final Map<UUID, FTBChunksTeamData> teamData;
    private final Map<ChunkDimPos, ClaimedChunk> claimedChunks;
    private final Path dataDirectory;
    private Map<class_5321<class_1937>, Long2ObjectMap<UUID>> forceLoadedChunkCache;

    public ClaimedChunkManager(TeamManager m) {
        this.teamManager = m;
        this.teamData = new HashMap<UUID, FTBChunksTeamData>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunk>();
        this.dataDirectory = this.getMinecraftServer().method_27050(DATA_DIR);
        Path localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(localDirectory, new LinkOption[0])) {
                Files.createDirectories(localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initForceLoadedChunks(class_3218 level) {
        Long2ObjectMap<UUID> map = this.getForceLoadedChunks((class_5321<class_1937>)level.method_27983());
        if (map.isEmpty() || level.method_14178() == null) {
            return;
        }
        map.forEach((pos, id) -> {
            class_1923 chunkPos = new class_1923(pos.longValue());
            FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", id, chunkPos.field_9181, chunkPos.field_9180, true);
        });
        level.method_14178().method_17298(false);
        FTBChunks.LOGGER.info("Force-loaded %d chunks in %s".formatted(map.size(), level.method_27983().method_29177()));
    }

    private FTBChunksTeamData loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(team.getId() + ".snbt");
        FTBChunksTeamData data = new FTBChunksTeamData(this, path, team);
        SNBTCompoundTag dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT((class_2487)dataFile);
            this.teamData.put(team.getId(), data);
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.server;
    }

    public FTBChunksTeamData getData(@Nullable Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found!");
        }
        FTBChunksTeamData data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    public FTBChunksTeamData getPersonalData(UUID id) {
        PlayerTeam team = FTBTeamsAPI.getManager().getInternalPlayerTeam(id);
        return team == null ? null : this.getData((Team)team);
    }

    public FTBChunksTeamData getPersonalData(class_3222 player) {
        return this.getPersonalData(player.method_5667());
    }

    public FTBChunksTeamData getData(class_3222 player) {
        return this.getData(FTBTeamsAPI.getPlayerTeam((class_3222)player));
    }

    public boolean hasData(class_3222 player) {
        Team team = FTBTeamsAPI.getManager().getPlayerTeam(player.method_5667());
        return team != null && this.teamData.containsKey(team.getId());
    }

    public void deleteTeam(Team toDelete) {
        FTBChunksTeamData data = this.teamData.get(toDelete.getId());
        if (data != null && toDelete.getMembers().isEmpty()) {
            FTBChunks.LOGGER.debug("dropping references to empty team " + toDelete.getId());
            this.teamData.remove(toDelete.getId());
            try {
                Files.deleteIfExists(data.file);
            }
            catch (IOException e) {
                FTBChunks.LOGGER.error(String.format("can't delete file %s: %s", data.file, e.getMessage()));
            }
        }
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }

    public Map<UUID, List<ClaimedChunk>> getClaimedChunksByTeam() {
        return this.getAllClaimedChunks().stream().collect(Collectors.groupingBy(cc -> cc.teamData.getTeamId()));
    }

    public boolean getBypassProtection(UUID player) {
        PlayerTeam team = this.teamManager.getInternalPlayerTeam(player);
        return team != null && team.getExtraData().method_10577("BypassFTBChunksProtection");
    }

    public void setBypassProtection(UUID player, boolean bypass) {
        PlayerTeam team = this.teamManager.getInternalPlayerTeam(player);
        if (team != null) {
            team.getExtraData().method_10556("BypassFTBChunksProtection", bypass);
            team.save();
        }
    }

    public boolean protect(@Nullable class_1297 entity, class_1268 hand, class_2338 pos, Protection protection, @Nullable class_1297 targetEntity) {
        class_3222 player;
        block10: {
            block9: {
                if (!(entity instanceof class_3222)) break block9;
                player = (class_3222)entity;
                if (!((Boolean)FTBChunksWorldConfig.DISABLE_PROTECTION.get()).booleanValue() && player.field_6002 != null) break block10;
            }
            return false;
        }
        boolean isFake = PlayerHooks.isFake((class_1657)player);
        if (isFake && ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).isOverride()) {
            return ((ProtectionOverride)((Object)FTBChunksWorldConfig.FAKE_PLAYERS.get())).getProtect();
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(player.field_6002, pos));
        if (chunk != null) {
            ProtectionOverride override = protection.override(player, pos, hand, chunk, targetEntity);
            if (override.isOverride()) {
                return override.getProtect();
            }
            return isFake || !this.getBypassProtection(player.method_5667());
        }
        if (FTBChunksWorldConfig.noWilderness(player)) {
            ProtectionOverride override = protection.override(player, pos, hand, null, targetEntity);
            if (override.isOverride()) {
                return override.getProtect();
            }
            if (!isFake && this.getBypassProtection(player.method_5667())) {
                return false;
            }
            player.method_7353((class_2561)new class_2585("You need to claim this chunk to interact with blocks here!"), true);
            return true;
        }
        return false;
    }

    public void clearForceLoadedCache() {
        this.forceLoadedChunkCache = null;
    }

    public Map<class_5321<class_1937>, Long2ObjectMap<UUID>> getForceLoadedChunks() {
        if (this.forceLoadedChunkCache == null) {
            this.forceLoadedChunkCache = new HashMap<class_5321<class_1937>, Long2ObjectMap<UUID>>();
            for (ClaimedChunk chunk : this.getAllClaimedChunks()) {
                if (!chunk.isActuallyForceLoaded()) continue;
                Long2ObjectMap pos2idMap = this.forceLoadedChunkCache.computeIfAbsent((class_5321<class_1937>)chunk.pos.dimension, k -> new Long2ObjectOpenHashMap());
                pos2idMap.put(class_1923.method_8331((int)chunk.pos.x, (int)chunk.pos.z), (Object)chunk.teamData.getTeamId());
            }
            this.forceLoadedChunkCache = this.forceLoadedChunkCache.isEmpty() ? Collections.emptyMap() : this.forceLoadedChunkCache;
        }
        return this.forceLoadedChunkCache;
    }

    @Nonnull
    public Long2ObjectMap<UUID> getForceLoadedChunks(class_5321<class_1937> dimension) {
        return this.getForceLoadedChunks().getOrDefault(dimension, EMPTY_CHUNKS);
    }

    public boolean isChunkForceLoaded(class_5321<class_1937> dimension, int x, int z) {
        return this.getForceLoadedChunks(dimension).containsKey(class_1923.method_8331((int)x, (int)z));
    }

    public void registerClaim(ChunkDimPos pos, ClaimedChunk chunk) {
        this.claimedChunks.put(pos, chunk);
    }

    public void unregisterClaim(ChunkDimPos pos) {
        this.claimedChunks.remove(pos);
    }
}

