/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.automobile.DisplayStat;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.render.AutomobilityModels;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_5617;

public record AutomobileFrame(class_2960 id, float weight, FrameModel model) implements AutomobileComponent<AutomobileFrame>
{
    public static final class_2960 ID = Automobility.id("frame");
    public static final SimpleMapContentRegistry<AutomobileFrame> REGISTRY = new SimpleMapContentRegistry();
    public static final AutomobileFrame EMPTY = REGISTRY.register(new AutomobileFrame(Automobility.id("empty"), 0.25f, new FrameModel(new class_2960("empty"), Automobility.id("empty"), WheelBase.basic(16.0f, 16.0f), 16.0f, 8.0f, 8.0f, 4.0f, 8.0f, 8.0f)));
    public static final AutomobileFrame WOODEN_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("wooden", 0.3f));
    public static final AutomobileFrame COPPER_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("copper", 0.4f));
    public static final AutomobileFrame STEEL_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("steel", 0.475f));
    public static final AutomobileFrame GOLDEN_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("golden", 0.525f));
    public static final AutomobileFrame BEJEWELED_MOTORCAR = REGISTRY.register(AutomobileFrame.motorcar("bejeweled", 0.555f));
    public static final AutomobileFrame STANDARD_WHITE = REGISTRY.register(AutomobileFrame.standard("white"));
    public static final AutomobileFrame STANDARD_ORANGE = REGISTRY.register(AutomobileFrame.standard("orange"));
    public static final AutomobileFrame STANDARD_MAGENTA = REGISTRY.register(AutomobileFrame.standard("magenta"));
    public static final AutomobileFrame STANDARD_LIGHT_BLUE = REGISTRY.register(AutomobileFrame.standard("light_blue"));
    public static final AutomobileFrame STANDARD_YELLOW = REGISTRY.register(AutomobileFrame.standard("yellow"));
    public static final AutomobileFrame STANDARD_LIME = REGISTRY.register(AutomobileFrame.standard("lime"));
    public static final AutomobileFrame STANDARD_PINK = REGISTRY.register(AutomobileFrame.standard("pink"));
    public static final AutomobileFrame STANDARD_GRAY = REGISTRY.register(AutomobileFrame.standard("gray"));
    public static final AutomobileFrame STANDARD_LIGHT_GRAY = REGISTRY.register(AutomobileFrame.standard("light_gray"));
    public static final AutomobileFrame STANDARD_CYAN = REGISTRY.register(AutomobileFrame.standard("cyan"));
    public static final AutomobileFrame STANDARD_PURPLE = REGISTRY.register(AutomobileFrame.standard("purple"));
    public static final AutomobileFrame STANDARD_BLUE = REGISTRY.register(AutomobileFrame.standard("blue"));
    public static final AutomobileFrame STANDARD_BROWN = REGISTRY.register(AutomobileFrame.standard("brown"));
    public static final AutomobileFrame STANDARD_GREEN = REGISTRY.register(AutomobileFrame.standard("green"));
    public static final AutomobileFrame STANDARD_RED = REGISTRY.register(AutomobileFrame.standard("red"));
    public static final AutomobileFrame STANDARD_BLACK = REGISTRY.register(AutomobileFrame.standard("black"));
    public static final AutomobileFrame AMETHYST_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("amethyst", 0.2f));
    public static final AutomobileFrame QUARTZ_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("quartz", 0.25f));
    public static final AutomobileFrame PRISMARINE_RICKSHAW = REGISTRY.register(AutomobileFrame.rickshaw("prismarine", 0.14f));
    public static final AutomobileFrame RED_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("red"));
    public static final AutomobileFrame YELLOW_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("yellow"));
    public static final AutomobileFrame GREEN_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("green"));
    public static final AutomobileFrame BLUE_TRACTOR = REGISTRY.register(AutomobileFrame.tractor("blue"));
    public static final AutomobileFrame SHOPPING_CART = REGISTRY.register(new AutomobileFrame(Automobility.id("shopping_cart"), 0.25f, new FrameModel(Automobility.id("textures/entity/automobile/frame/shopping_cart.png"), Automobility.id("frame_shopping_cart"), WheelBase.basic(17.0f, 12.05f), 25.0f, 11.0f, 7.0f, 17.0f, 11.0f, 11.0f)));
    public static final AutomobileFrame C_ARR = REGISTRY.register(new AutomobileFrame(Automobility.id("c_arr"), 0.85f, new FrameModel(Automobility.id("textures/entity/automobile/frame/c_arr.png"), Automobility.id("frame_c_arr"), WheelBase.basic(44.5f, 16.0f), 44.0f, 6.0f, 19.5f, 10.5f, 23.0f, 23.0f)));
    public static final AutomobileFrame PINEAPPLE = REGISTRY.register(new AutomobileFrame(Automobility.id("pineapple"), 0.75f, new FrameModel(Automobility.id("textures/entity/automobile/frame/pineapple.png"), Automobility.id("frame_pineapple"), WheelBase.basic(10.0f, 18.0f), 20.0f, 16.0f, 8.0f, 6.0f, 9.0f, 9.0f)));
    public static final AutomobileFrame DABABY = REGISTRY.register(new AutomobileFrame(Automobility.id("dababy"), 0.93f, new FrameModel(Automobility.id("textures/entity/automobile/frame/dababy.png"), Automobility.id("frame_dababy"), WheelBase.basic(40.0f, 8.0f), 40.0f, 22.0f, 13.0f, 3.0f, 24.0f, 24.0f)));
    public static final DisplayStat<AutomobileFrame> STAT_WEIGHT = new DisplayStat<AutomobileFrame>("weight", AutomobileFrame::weight);

    private static AutomobileFrame standard(String color) {
        return new AutomobileFrame(Automobility.id("standard_" + color), 0.6f, new FrameModel(Automobility.id("textures/entity/automobile/frame/standard_" + color + ".png"), Automobility.id("frame_standard"), WheelBase.basic(26.0f, 10.0f), 26.0f, 5.0f, 13.0f, 3.0f, 18.0f, 22.0f));
    }

    private static AutomobileFrame motorcar(String variant, float weight) {
        return new AutomobileFrame(Automobility.id(variant + "_motorcar"), weight, new FrameModel(Automobility.id("textures/entity/automobile/frame/" + variant + "_motorcar.png"), Automobility.id("frame_motorcar"), WheelBase.basic(32.0f, 12.0f), 28.0f, 3.0f, 18.0f, 2.0f, 23.0f, 22.0f));
    }

    private static AutomobileFrame tractor(String color) {
        return new AutomobileFrame(Automobility.id(color + "_tractor"), 0.9f, new FrameModel(Automobility.id("textures/entity/automobile/frame/" + color + "_tractor.png"), Automobility.id("frame_tractor"), new WheelBase(new WheelBase.WheelPos(-2.0f, -7.0f, 1.8f, 0.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(-2.0f, 7.0f, 1.8f, 180.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.RIGHT), new WheelBase.WheelPos(15.0f, -1.0f, 1.0f, 0.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(15.0f, 1.0f, 1.0f, 180.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.RIGHT)), 24.0f, 9.0f, 9.0f, 8.0f, 12.0f, 19.0f));
    }

    private static AutomobileFrame rickshaw(String prefix, float weight) {
        return new AutomobileFrame(Automobility.id(prefix + "_rickshaw"), weight, new FrameModel(Automobility.id("textures/entity/automobile/frame/" + prefix + "_rickshaw.png"), Automobility.id("frame_rickshaw"), new WheelBase(new WheelBase.WheelPos(-11.0f, -7.5f, 1.0f, 0.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(-11.0f, 7.5f, 1.0f, 180.0f, WheelBase.WheelEnd.BACK, WheelBase.WheelSide.RIGHT), new WheelBase.WheelPos(11.0f, -0.1f, 1.0f, 0.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.LEFT), new WheelBase.WheelPos(11.0f, 0.1f, 1.0f, 180.0f, WheelBase.WheelEnd.FRONT, WheelBase.WheelSide.RIGHT)), 26.0f, 2.5f, 13.0f, 3.0f, 17.5f, 14.5f));
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public class_2960 containerId() {
        return ID;
    }

    @Override
    public void forEachStat(Consumer<DisplayStat<AutomobileFrame>> action) {
        action.accept(STAT_WEIGHT);
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return "frame." + this.id.method_12836() + "." + this.id.method_12832();
    }

    public record FrameModel(class_2960 texture, class_2960 modelId, WheelBase wheelBase, float lengthPx, float seatHeight, float enginePosBack, float enginePosUp, float rearAttachmentPos, float frontAttachmentPos) {
        @Environment(value=EnvType.CLIENT)
        public Function<class_5617.class_5618, class_3879> model() {
            return AutomobilityModels.MODELS.get(this.modelId);
        }
    }
}

