/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.BlockRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.ChestRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.SaddledBarrelRearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.util.duck.EnderChestInventoryDuck;
import java.util.function.BiFunction;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1730;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_5560;
import net.minecraft.class_5561;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class BaseChestRearAttachment
extends BlockRearAttachment {
    public static final class_2561 TITLE_CHEST = new class_2588("container.chest");
    public static final class_2561 TITLE_ENDER_CHEST = new class_2588("container.enderchest");
    public static final class_2561 TITLE_BARREL = new class_2588("container.barrel");
    private final class_5561 viewerManager = new class_5561(){

        protected void method_31681(class_1937 world, class_2338 pos, class_2680 state) {
            BaseChestRearAttachment.sound(world, pos, BaseChestRearAttachment.this.getOpenSound());
        }

        protected void method_31683(class_1937 world, class_2338 pos, class_2680 state) {
            BaseChestRearAttachment.sound(world, pos, BaseChestRearAttachment.this.getCloseSound());
        }

        protected void method_31682(class_1937 world, class_2338 pos, class_2680 state, int oldViewerCount, int newViewerCount) {
            if (!world.method_8608()) {
                BaseChestRearAttachment.this.updateTrackedAnimation(newViewerCount);
            }
        }

        protected boolean method_31679(class_1657 player) {
            if (!(player.field_7512 instanceof class_1707)) {
                return false;
            }
            class_1263 inventory = ((class_1707)player.field_7512).method_7629();
            return inventory == BaseChestRearAttachment.this;
        }
    };
    public final class_5560 lidAnimator = new class_5560();

    public BaseChestRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity, class_2680 block, @Nullable BiFunction<class_3914, BlockRearAttachment, class_3908> screenProvider) {
        super(type, entity, block, screenProvider);
    }

    public void open(class_1657 player) {
        if (!player.method_7325()) {
            this.viewerManager.method_31684(player, this.world(), this.automobile.method_24515(), class_2246.field_10124.method_9564());
        }
    }

    public void close(class_1657 player) {
        if (!player.method_7325()) {
            this.viewerManager.method_31685(player, this.world(), this.automobile.method_24515(), class_2246.field_10124.method_9564());
        }
    }

    @Override
    public void onTrackedAnimationUpdated(float animation) {
        super.onTrackedAnimationUpdated(animation);
        this.lidAnimator.method_31674(animation > 0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world().method_8608()) {
            this.lidAnimator.method_31672();
        }
    }

    protected class_3414 getOpenSound() {
        return class_3417.field_14952;
    }

    protected class_3414 getCloseSound() {
        return class_3417.field_15206;
    }

    private static void sound(class_1937 world, class_2338 pos, class_3414 soundEvent) {
        world.method_8465(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundEvent, class_3419.field_15245, 0.5f, world.field_9229.nextFloat() * 0.1f + 0.9f);
    }

    public static BaseChestRearAttachment chest(RearAttachmentType<?> type, AutomobileEntity entity) {
        return new ChestRearAttachment(type, entity, class_2246.field_10443.method_9564(), (ctx, att) -> {
            ChestRearAttachment chest;
            return att instanceof ChestRearAttachment ? (chest = (ChestRearAttachment)att) : null;
        });
    }

    public static BaseChestRearAttachment enderChest(RearAttachmentType<?> type, AutomobileEntity entity) {
        return new BaseChestRearAttachment(type, entity, class_2246.field_10443.method_9564(), (ctx, att) -> new class_747((syncId, inventory, player) -> {
            class_1730 enderChest = player.method_7274();
            if (att instanceof BaseChestRearAttachment) {
                BaseChestRearAttachment chest = (BaseChestRearAttachment)att;
                EnderChestInventoryDuck.of(enderChest).automobility$setActiveAttachment(chest);
            }
            return class_1707.method_19245((int)syncId, (class_1661)inventory, (class_1263)enderChest);
        }, TITLE_ENDER_CHEST));
    }

    public static BaseChestRearAttachment saddledBarrel(RearAttachmentType<?> type, AutomobileEntity entity) {
        return new SaddledBarrelRearAttachment(type, entity, class_2246.field_16328.method_9564(), (ctx, att) -> {
            SaddledBarrelRearAttachment barrel;
            return att instanceof SaddledBarrelRearAttachment ? (barrel = (SaddledBarrelRearAttachment)att) : null;
        });
    }
}

