/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.DeployableRearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.network.PayloadPackets;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public abstract class ExtendableRearAttachment
extends DeployableRearAttachment {
    protected boolean extended;
    private int extendAnimation;
    private int lastExtendAnimation;

    protected ExtendableRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity) {
        super(type, entity);
        this.lastExtendAnimation = this.extendAnimation = 0;
    }

    public float extendAnimation(float delta) {
        return class_3532.method_16439((float)delta, (float)this.lastExtendAnimation, (float)this.extendAnimation) / 14.0f;
    }

    public void setExtended(boolean extended) {
        if (!this.world().method_8608()) {
            this.updateTrackedAnimation(extended ? 1.0f : 0.0f);
        }
        this.extended = extended;
    }

    public boolean extended() {
        return this.extended;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.world().method_8608()) {
            this.lastExtendAnimation = this.extendAnimation;
            this.extendAnimation = AUtils.shift(this.extendAnimation, 1, this.extended() ? 0 : this.extendAnimTime());
        }
    }

    @Override
    public void updatePacketRequested(class_3222 player) {
        super.updatePacketRequested(player);
        PayloadPackets.sendExtendableAttachmentUpdatePacket(this.automobile(), this.extended(), player);
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        super.writeNbt(nbt);
        nbt.method_10556("extended", this.extended());
    }

    @Override
    public void readNbt(class_2487 nbt) {
        super.readNbt(nbt);
        this.setExtended(nbt.method_10577("extended"));
    }

    @Override
    public void deploy() {
        this.setExtended(!this.extended());
    }

    @Override
    public void onTrackedAnimationUpdated(float animation) {
        super.onTrackedAnimationUpdated(animation);
        this.setExtended(animation > 0.0f);
    }

    protected abstract int extendAnimTime();
}

