/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render;

import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.render.BaseModel;
import io.github.foundationgames.automobility.automobile.render.ExhaustFumesModel;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.automobile.render.SkidEffectModel;
import io.github.foundationgames.automobility.automobile.render.attachment.front.FrontAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.attachment.rear.RearAttachmentRenderModel;
import io.github.foundationgames.automobility.automobile.render.wheel.WheelContextReceiver;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;

public final class AutomobileRenderer
extends Enum<AutomobileRenderer> {
    private static class_3879 skidEffectModel;
    private static class_3879 exhaustFumesModel;
    private static final /* synthetic */ AutomobileRenderer[] $VALUES;

    public static AutomobileRenderer[] values() {
        return (AutomobileRenderer[])$VALUES.clone();
    }

    public static AutomobileRenderer valueOf(String name) {
        return Enum.valueOf(AutomobileRenderer.class, name);
    }

    public static void render(class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, float tickDelta, class_5617.class_5618 ctx, RenderableAutomobile automobile) {
        FrontAttachmentType<?> frontAtt;
        AutomobileFrame frame = automobile.getFrame();
        AutomobileWheel wheels = automobile.getWheels();
        AutomobileEngine engine = automobile.getEngine();
        if (skidEffectModel == null || exhaustFumesModel == null) {
            skidEffectModel = new SkidEffectModel(ctx);
            exhaustFumesModel = new ExhaustFumesModel(ctx);
        }
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
        matrices.method_22907(class_1160.field_20705.method_23214(automobile.getAutomobileYaw(tickDelta) + 180.0f));
        float chassisRaise = wheels.model().radius() / 16.0f;
        float bounce = automobile.getSuspensionBounce(tickDelta) * 0.048f;
        class_3879 frameModel = automobile.getFrameModel(ctx);
        class_3879 wheelModel = automobile.getWheelModel(ctx);
        class_3879 engineModel = automobile.getEngineModel(ctx);
        class_3879 rearAttachmentModel = automobile.getRearAttachmentModel(ctx);
        class_3879 frontAttachmentModel = automobile.getFrontAttachmentModel(ctx);
        matrices.method_22904(0.0, (double)(-chassisRaise), 0.0);
        matrices.method_22903();
        matrices.method_22904(0.0, (double)bounce + (automobile.engineRunning() ? Math.cos((double)((float)automobile.getTime() + tickDelta) * 2.7) / 156.0 : 0.0), 0.0);
        class_2960 frameTexture = frame.model().texture();
        class_2960 engineTexture = engine.model().texture();
        if (!frame.isEmpty() && frameModel != null) {
            frameModel.method_2828(matrices, vertexConsumers.getBuffer(frameModel.method_23500(frameTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (frameModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frameModel;
                base.doOtherLayerRender(matrices, vertexConsumers, light, overlay);
            }
        }
        float eBack = frame.model().enginePosBack() / 16.0f;
        float eUp = frame.model().enginePosUp() / 16.0f;
        matrices.method_22904(0.0, (double)(-eUp), (double)eBack);
        matrices.method_22907(class_1160.field_20705.method_23214(180.0f));
        if (!engine.isEmpty() && engineModel != null) {
            engineModel.method_2828(matrices, vertexConsumers.getBuffer(engineModel.method_23500(engineTexture)), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (engineModel instanceof BaseModel) {
                BaseModel base = (BaseModel)engineModel;
                base.doOtherLayerRender(matrices, vertexConsumers, light, overlay);
            }
        }
        class_4588 exhaustBuffer = null;
        if (automobile.getBoostTimer() > 0) {
            exhaustTexes = ExhaustFumesModel.FLAME_TEXTURES;
            index = (int)(automobile.getTime() % (long)exhaustTexes.length);
            exhaustBuffer = vertexConsumers.getBuffer(class_1921.method_23026((class_2960)exhaustTexes[index]));
        } else if (automobile.engineRunning()) {
            exhaustTexes = ExhaustFumesModel.SMOKE_TEXTURES;
            index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)exhaustTexes.length);
            exhaustBuffer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)exhaustTexes[index]));
        }
        if (exhaustBuffer != null) {
            for (AutomobileEngine.ExhaustPos exhaust : engine.model().exhausts()) {
                matrices.method_22903();
                matrices.method_22904((double)(exhaust.x() / 16.0f), (double)(-exhaust.y() / 16.0f), (double)(exhaust.z() / 16.0f));
                matrices.method_22907(class_1160.field_20705.method_23214(exhaust.yaw()));
                matrices.method_22907(class_1160.field_20703.method_23214(exhaust.pitch()));
                exhaustFumesModel.method_2828(matrices, exhaustBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
        RearAttachmentType<?> rearAtt = automobile.getRearAttachmentType();
        if (!rearAtt.isEmpty()) {
            matrices.method_22903();
            matrices.method_22904(0.0, (double)chassisRaise, (double)(frame.model().rearAttachmentPos() / 16.0f));
            matrices.method_22907(class_1160.field_20704.method_23214(automobile.getAutomobileYaw(tickDelta) - automobile.getRearAttachmentYaw(tickDelta)));
            matrices.method_22904(0.0, 0.0, (double)(rearAtt.model().pivotDistPx() / 16.0f));
            if (rearAttachmentModel instanceof RearAttachmentRenderModel) {
                RearAttachmentRenderModel rm = (RearAttachmentRenderModel)rearAttachmentModel;
                rm.setRenderState(automobile.getRearAttachment(), (float)Math.toRadians(automobile.getWheelAngle(tickDelta)), tickDelta);
            }
            rearAttachmentModel.method_2828(matrices, vertexConsumers.getBuffer(rearAttachmentModel.method_23500(rearAtt.model().texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (rearAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)rearAttachmentModel;
                base.doOtherLayerRender(matrices, vertexConsumers, light, overlay);
            }
            matrices.method_22909();
        }
        if (!(frontAtt = automobile.getFrontAttachmentType()).isEmpty()) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, (double)(frame.model().frontAttachmentPos() / -16.0f));
            if (frontAttachmentModel instanceof FrontAttachmentRenderModel) {
                FrontAttachmentRenderModel fm = (FrontAttachmentRenderModel)frontAttachmentModel;
                fm.setRenderState(automobile.getFrontAttachment(), chassisRaise, tickDelta);
            }
            frontAttachmentModel.method_2828(matrices, vertexConsumers.getBuffer(frontAttachmentModel.method_23500(frontAtt.model().texture())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            if (frontAttachmentModel instanceof BaseModel) {
                BaseModel base = (BaseModel)frontAttachmentModel;
                base.doOtherLayerRender(matrices, vertexConsumers, light, overlay);
            }
            matrices.method_22909();
        }
        WheelBase.WheelPos[] wPoses = frame.model().wheelBase().wheels;
        if (!wheels.isEmpty()) {
            class_4588 wheelBuffer = vertexConsumers.getBuffer(wheelModel.method_23500(wheels.model().texture()));
            float wheelAngle = automobile.getWheelAngle(tickDelta);
            int wheelCount = automobile.getWheelCount();
            for (WheelBase.WheelPos pos : wPoses) {
                if (wheelCount <= 0) break;
                if (wheelModel instanceof WheelContextReceiver) {
                    WheelContextReceiver receiver = (WheelContextReceiver)wheelModel;
                    receiver.provideContext(pos);
                }
                float scale = pos.scale();
                float wheelRadius = wheels.model().radius() - wheels.model().radius() * (scale - 1.0f);
                matrices.method_22903();
                matrices.method_22904((double)(pos.right() / 16.0f), (double)(wheelRadius / 16.0f), (double)(-pos.forward() / 16.0f));
                if (pos.end() == WheelBase.WheelEnd.FRONT) {
                    matrices.method_22907(class_1160.field_20705.method_23214(automobile.getSteering(tickDelta) * 27.0f));
                }
                matrices.method_22904(0.0, (double)(-chassisRaise), 0.0);
                matrices.method_22907(class_1160.field_20703.method_23214(wheelAngle));
                matrices.method_22905(scale, scale, scale);
                matrices.method_22907(class_1160.field_20705.method_23214(180.0f + pos.yaw()));
                wheelModel.method_2828(matrices, wheelBuffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                if (wheelModel instanceof BaseModel) {
                    BaseModel base = (BaseModel)wheelModel;
                    base.doOtherLayerRender(matrices, vertexConsumers, light, overlay);
                }
                matrices.method_22909();
                --wheelCount;
            }
        }
        if ((automobile.getTurboCharge() > 35 || automobile.debris()) && automobile.automobileOnGround()) {
            class_2960[] skidTexes = SkidEffectModel.COOL_SPARK_TEXTURES;
            boolean bright = true;
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (automobile.getTurboCharge() > 115) {
                skidTexes = SkidEffectModel.FLAME_TEXTURES;
            } else if (automobile.getTurboCharge() > 70) {
                skidTexes = SkidEffectModel.HOT_SPARK_TEXTURES;
            } else if (automobile.debris()) {
                skidTexes = SkidEffectModel.DEBRIS_TEXTURES;
                class_1160 c = automobile.debrisColor();
                r = c.method_4943() * 0.85f;
                g = c.method_4945() * 0.85f;
                b = c.method_4947() * 0.85f;
                bright = false;
            }
            int index = (int)Math.floor(((float)automobile.getTime() + tickDelta) / 1.5f % (float)skidTexes.length);
            class_4588 skidEffectBuffer = vertexConsumers.getBuffer(bright ? class_1921.method_23026((class_2960)skidTexes[index]) : class_1921.method_23584((class_2960)skidTexes[index]));
            for (WheelBase.WheelPos pos : wPoses) {
                if (pos.end() != WheelBase.WheelEnd.BACK) continue;
                float scale = pos.scale();
                float heightOffset = wheels.model().radius();
                float wheelRadius = wheels.model().radius() * scale;
                float wheelWidth = wheels.model().width() / 16.0f * scale;
                float back = wheelRadius > 2.0f ? (float)(Math.sqrt((double)(wheelRadius * wheelRadius) - Math.pow(wheelRadius - 2.0f, 2.0)) - 0.85) / 16.0f : 0.08f;
                matrices.method_22903();
                matrices.method_22904((double)(pos.right() / 16.0f + wheelWidth * (float)(pos.side() == WheelBase.WheelSide.RIGHT ? 1 : -1)), (double)(heightOffset / 16.0f), (double)(-pos.forward() / 16.0f + back));
                matrices.method_22905(pos.side() == WheelBase.WheelSide.LEFT ? -1.0f : 1.0f, 1.0f, -1.0f);
                skidEffectModel.method_2828(matrices, skidEffectBuffer, light, overlay, r, g, b, 0.6f);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
    }

    private static /* synthetic */ AutomobileRenderer[] $values() {
        return new AutomobileRenderer[0];
    }

    static {
        $VALUES = AutomobileRenderer.$values();
    }
}

