/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.entity;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.automobile.WheelBase;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.DeployableRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.automobile.render.RenderableAutomobile;
import io.github.foundationgames.automobility.block.AutomobileAssemblerBlock;
import io.github.foundationgames.automobility.block.LaunchGelBlock;
import io.github.foundationgames.automobility.block.OffRoadBlock;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.entity.EntityWithInventory;
import io.github.foundationgames.automobility.item.AutomobileInteractable;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.particle.AutomobilityParticles;
import io.github.foundationgames.automobility.screen.AutomobileScreenHandlerContext;
import io.github.foundationgames.automobility.sound.AutomobileSoundInstance;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.duck.CollisionArea;
import io.github.foundationgames.automobility.util.midnightcontrols.ControllerUtils;
import io.github.foundationgames.automobility.util.network.PayloadPackets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11;
import net.minecraft.class_1113;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1480;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3879;
import net.minecraft.class_3908;
import net.minecraft.class_3980;
import net.minecraft.class_5575;
import net.minecraft.class_5617;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class AutomobileEntity
extends class_1297
implements RenderableAutomobile,
EntityWithInventory {
    private static final class_2940<Float> REAR_ATTACHMENT_YAW = class_2945.method_12791(AutomobileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> REAR_ATTACHMENT_ANIMATION = class_2945.method_12791(AutomobileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> FRONT_ATTACHMENT_ANIMATION = class_2945.method_12791(AutomobileEntity.class, (class_2941)class_2943.field_13320);
    private AutomobileFrame frame = AutomobileFrame.REGISTRY.getOrDefault(null);
    private AutomobileWheel wheels = AutomobileWheel.REGISTRY.getOrDefault(null);
    private AutomobileEngine engine = AutomobileEngine.REGISTRY.getOrDefault(null);
    private RearAttachment rearAttachment;
    private FrontAttachment frontAttachment;
    private final AutomobileStats stats = new AutomobileStats();
    @Environment(value=EnvType.CLIENT)
    private class_3879 frameModel = null;
    @Environment(value=EnvType.CLIENT)
    private class_3879 wheelModel = null;
    @Environment(value=EnvType.CLIENT)
    private class_3879 engineModel = null;
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private class_3879 rearAttachmentModel = null;
    @Environment(value=EnvType.CLIENT)
    @Nullable
    private class_3879 frontAttachmentModel = null;
    public static final int SMALL_TURBO_TIME = 35;
    public static final int MEDIUM_TURBO_TIME = 70;
    public static final int LARGE_TURBO_TIME = 115;
    public static final float TERMINAL_VELOCITY = -1.2f;
    private long clientTime;
    private double trackedX;
    private double trackedY;
    private double trackedZ;
    private float trackedYaw;
    private int lerpTicks;
    private boolean dirty = false;
    private float engineSpeed = 0.0f;
    private float boostSpeed = 0.0f;
    private float speedDirection = 0.0f;
    private float lastBoostSpeed = this.boostSpeed;
    private int boostTimer = 0;
    private float boostPower = 0.0f;
    private int jumpCooldown = 0;
    private float hSpeed = 0.0f;
    private float vSpeed = 0.0f;
    private class_243 addedVelocity = this.method_18798();
    private float steering;
    private float lastSteering = this.steering = 0.0f;
    private float angularSpeed = 0.0f;
    private float wheelAngle = 0.0f;
    private float lastWheelAngle = 0.0f;
    private final Displacement displacement = new Displacement();
    private boolean drifting = false;
    private boolean burningOut = false;
    private int driftDir = 0;
    private int turboCharge = 0;
    private float lockedViewOffset = 0.0f;
    private boolean automobileOnGround;
    private boolean wasOnGround = this.automobileOnGround = true;
    private boolean isFloorDirectlyBelow = true;
    private boolean touchingWall = false;
    private class_243 lastVelocity = class_243.field_1353;
    private class_243 lastPosForDisplacement = class_243.field_1353;
    private class_243 prevTailPos = null;
    private int slopeStickingTimer = 0;
    private float grip = 1.0f;
    private int suspensionBounceTimer;
    private int lastSusBounceTimer = this.suspensionBounceTimer = 0;
    private final Deque<Double> prevYDisplacements = new ArrayDeque<Double>();
    private boolean offRoad = false;
    private class_1160 debrisColor = new class_1160();
    private int fallTicks = 0;
    private int despawnTime = -1;
    private int despawnCountdown = 0;
    private boolean decorative = false;
    private boolean wasEngineRunning = false;
    private float standStillTime = -1.3f;
    private boolean accelerating = false;
    private boolean braking = false;
    private boolean steeringLeft = false;
    private boolean steeringRight = false;
    private boolean holdingDrift;
    private boolean prevHoldDrift = this.holdingDrift = false;
    @Environment(value=EnvType.CLIENT)
    public boolean updateModels = true;

    public void writeSyncToClientData(class_2540 buf) {
        buf.writeInt(this.boostTimer);
        buf.writeFloat(this.steering);
        buf.writeFloat(this.wheelAngle);
        buf.writeInt(this.turboCharge);
        buf.writeFloat(this.engineSpeed);
        buf.writeFloat(this.boostSpeed);
        buf.writeByte((int)this.compactInputData());
        buf.writeBoolean(this.drifting);
        buf.writeBoolean(this.burningOut);
    }

    public void readSyncToClientData(class_2540 buf) {
        this.boostTimer = buf.readInt();
        this.steering = buf.readFloat();
        this.wheelAngle = buf.readFloat();
        this.turboCharge = buf.readInt();
        this.engineSpeed = buf.readFloat();
        this.boostSpeed = buf.readFloat();
        this.readCompactedInputData(buf.readByte());
        this.setDrifting(buf.readBoolean());
        this.setBurningOut(buf.readBoolean());
    }

    public void method_5749(class_2487 nbt) {
        this.setComponents(AutomobileFrame.REGISTRY.getOrDefault(class_2960.method_12829((String)nbt.method_10558("frame"))), AutomobileWheel.REGISTRY.getOrDefault(class_2960.method_12829((String)nbt.method_10558("wheels"))), AutomobileEngine.REGISTRY.getOrDefault(class_2960.method_12829((String)nbt.method_10558("engine"))));
        class_2487 rAtt = nbt.method_10562("rearAttachment");
        this.setRearAttachment(RearAttachment.fromNbt(rAtt));
        this.rearAttachment.readNbt(rAtt);
        class_2487 fAtt = nbt.method_10562("frontAttachment");
        this.setFrontAttachment(FrontAttachment.fromNbt(fAtt));
        this.frontAttachment.readNbt(fAtt);
        this.engineSpeed = nbt.method_10583("engineSpeed");
        this.boostSpeed = nbt.method_10583("boostSpeed");
        this.boostTimer = nbt.method_10550("boostTimer");
        this.boostPower = nbt.method_10583("boostPower");
        this.speedDirection = nbt.method_10583("speedDirection");
        this.vSpeed = nbt.method_10583("verticalSpeed");
        this.hSpeed = nbt.method_10583("horizontalSpeed");
        this.addedVelocity = AUtils.v3dFromNbt(nbt.method_10562("addedVelocity"));
        this.lastVelocity = AUtils.v3dFromNbt(nbt.method_10562("lastVelocity"));
        this.angularSpeed = nbt.method_10583("angularSpeed");
        this.steering = nbt.method_10583("steering");
        this.wheelAngle = nbt.method_10583("wheelAngle");
        this.drifting = nbt.method_10577("drifting");
        this.driftDir = nbt.method_10550("driftDir");
        this.burningOut = nbt.method_10577("burningOut");
        this.turboCharge = nbt.method_10550("turboCharge");
        this.accelerating = nbt.method_10577("accelerating");
        this.braking = nbt.method_10577("braking");
        this.steeringLeft = nbt.method_10577("steeringLeft");
        this.steeringRight = nbt.method_10577("steeringRight");
        this.holdingDrift = nbt.method_10577("holdingDrift");
        this.fallTicks = nbt.method_10550("fallTicks");
        this.despawnTime = nbt.method_10550("despawnTime");
        this.despawnCountdown = nbt.method_10550("despawnCountdown");
        this.decorative = nbt.method_10577("decorative");
        this.updateModels = true;
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10582("frame", this.frame.getId().toString());
        nbt.method_10582("wheels", this.wheels.getId().toString());
        nbt.method_10582("engine", this.engine.getId().toString());
        nbt.method_10566("rearAttachment", (class_2520)this.rearAttachment.toNbt());
        nbt.method_10566("frontAttachment", (class_2520)this.frontAttachment.toNbt());
        nbt.method_10548("engineSpeed", this.engineSpeed);
        nbt.method_10548("boostSpeed", this.boostSpeed);
        nbt.method_10569("boostTimer", this.boostTimer);
        nbt.method_10548("boostPower", this.boostPower);
        nbt.method_10548("speedDirection", this.speedDirection);
        nbt.method_10548("verticalSpeed", this.vSpeed);
        nbt.method_10548("horizontalSpeed", this.hSpeed);
        nbt.method_10566("addedVelocity", (class_2520)AUtils.v3dToNbt(this.addedVelocity));
        nbt.method_10566("lastVelocity", (class_2520)AUtils.v3dToNbt(this.lastVelocity));
        nbt.method_10548("angularSpeed", this.angularSpeed);
        nbt.method_10548("steering", this.steering);
        nbt.method_10548("wheelAngle", this.wheelAngle);
        nbt.method_10556("drifting", this.drifting);
        nbt.method_10569("driftDir", this.driftDir);
        nbt.method_10556("burningOut", this.burningOut);
        nbt.method_10569("turboCharge", this.turboCharge);
        nbt.method_10556("accelerating", this.accelerating);
        nbt.method_10556("braking", this.braking);
        nbt.method_10556("steeringLeft", this.steeringLeft);
        nbt.method_10556("steeringRight", this.steeringRight);
        nbt.method_10556("holdingDrift", this.holdingDrift);
        nbt.method_10569("fallTicks", this.fallTicks);
        nbt.method_10569("despawnTime", this.despawnTime);
        nbt.method_10569("despawnCountdown", this.despawnCountdown);
        nbt.method_10556("decorative", this.decorative);
    }

    public byte compactInputData() {
        int r = ((((this.accelerating ? 1 : 0) << 1 | (this.braking ? 1 : 0)) << 1 | (this.steeringLeft ? 1 : 0)) << 1 | (this.steeringRight ? 1 : 0)) << 1 | (this.holdingDrift ? 1 : 0);
        return (byte)r;
    }

    public void readCompactedInputData(byte data) {
        int d = data;
        this.holdingDrift = (1 & d) > 0;
        this.steeringRight = (1 & (d >>= 1)) > 0;
        this.steeringLeft = (1 & (d >>= 1)) > 0;
        this.braking = (1 & (d >>= 1)) > 0;
        this.accelerating = (1 & (d >>= 1)) > 0;
    }

    public AutomobileEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.setRearAttachment(RearAttachmentType.REGISTRY.getOrDefault(null));
        this.setFrontAttachment(FrontAttachmentType.REGISTRY.getOrDefault(null));
    }

    public AutomobileEntity(class_1937 world) {
        this(AutomobilityEntities.AUTOMOBILE, world);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.field_6002.method_8608()) {
            PayloadPackets.requestSyncAutomobileComponentsPacket(this);
        }
    }

    @Override
    public AutomobileFrame getFrame() {
        return this.frame;
    }

    @Override
    public AutomobileWheel getWheels() {
        return this.wheels;
    }

    @Override
    public AutomobileEngine getEngine() {
        return this.engine;
    }

    @Override
    @Nullable
    public RearAttachment getRearAttachment() {
        return this.rearAttachment;
    }

    @Override
    @Nullable
    public FrontAttachment getFrontAttachment() {
        return this.frontAttachment;
    }

    @Override
    public float getSteering(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastSteering, (float)this.steering);
    }

    @Override
    public float getWheelAngle(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastWheelAngle, (float)this.wheelAngle);
    }

    public float getBoostSpeed(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastBoostSpeed, (float)this.boostSpeed);
    }

    @Override
    public float getSuspensionBounce(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastSusBounceTimer, (float)this.suspensionBounceTimer);
    }

    @Override
    public boolean engineRunning() {
        return this.method_5782();
    }

    @Override
    public int getTurboCharge() {
        return this.turboCharge;
    }

    @Override
    public long getTime() {
        return this.clientTime;
    }

    public float getHSpeed() {
        return this.hSpeed;
    }

    public float getVSpeed() {
        return this.vSpeed;
    }

    @Override
    public int getBoostTimer() {
        return this.boostTimer;
    }

    public double getEffectiveSpeed() {
        class_1657 player;
        class_1297 class_12972 = this.method_5642();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_7340()) {
            return Math.max(this.addedVelocity.method_1033(), (double)Math.abs(this.hSpeed));
        }
        return Math.max(this.addedVelocity.method_1033(), (double)Math.abs(this.engineSpeed + this.boostSpeed));
    }

    @Override
    public boolean automobileOnGround() {
        return this.automobileOnGround;
    }

    @Override
    public boolean debris() {
        return this.offRoad && this.hSpeed != 0.0f;
    }

    @Override
    public class_1160 debrisColor() {
        return this.debrisColor;
    }

    public boolean burningOut() {
        return this.burningOut;
    }

    private void setDrifting(boolean drifting) {
        if (this.field_6002.method_8608() && !this.drifting && drifting) {
            this.playSkiddingSound();
        }
        this.drifting = drifting;
    }

    private void setBurningOut(boolean burningOut) {
        if (this.field_6002.method_8608() && !this.drifting && !this.burningOut && burningOut) {
            this.playSkiddingSound();
        }
        this.burningOut = burningOut;
    }

    public boolean isDrifting() {
        return this.drifting;
    }

    public <T extends RearAttachment> void setRearAttachment(RearAttachmentType<T> rearAttachment) {
        if (rearAttachment == null) {
            return;
        }
        if (this.rearAttachment == null || this.rearAttachment.type != rearAttachment) {
            if (this.rearAttachment != null) {
                this.rearAttachment.onRemoved();
            }
            this.rearAttachment = (RearAttachment)rearAttachment.constructor().apply(rearAttachment, this);
            this.rearAttachment.setYaw(this.method_36454());
            if (!this.field_6002.method_8608() && !this.rearAttachment.isRideable() && this.method_5685().size() > 1) {
                ((class_1297)this.method_5685().get(1)).method_5848();
            }
            this.updateModels = true;
            this.syncAttachments();
        }
    }

    public <T extends FrontAttachment> void setFrontAttachment(FrontAttachmentType<T> frontAttachment) {
        if (frontAttachment == null) {
            return;
        }
        if (this.frontAttachment == null || this.frontAttachment.type != frontAttachment) {
            if (this.frontAttachment != null) {
                this.frontAttachment.onRemoved();
            }
            this.frontAttachment = (FrontAttachment)frontAttachment.constructor().apply(frontAttachment, this);
            this.updateModels = true;
            this.syncAttachments();
        }
    }

    public void setComponents(AutomobileFrame frame, AutomobileWheel wheel, AutomobileEngine engine) {
        this.frame = frame;
        this.wheels = wheel;
        this.engine = engine;
        this.updateModels = true;
        this.field_6013 = this.wheels.size();
        this.stats.from(frame, wheel, engine);
        this.displacement.applyWheelbase(frame.model().wheelBase());
        if (!this.field_6002.method_8608()) {
            this.syncComponents();
        }
    }

    public void forNearbyPlayers(int radius, boolean ignoreDriver, Consumer<class_3222> action) {
        for (class_1657 p : this.field_6002.method_18456()) {
            if (ignoreDriver && p == this.method_31483() || !(p.method_19538().method_1022(this.method_19538()) < (double)radius) || !(p instanceof class_3222)) continue;
            class_3222 player = (class_3222)p;
            action.accept(player);
        }
    }

    public class_243 getTailPos() {
        return this.method_19538().method_1019(new class_243(0.0, 0.0, (double)this.getFrame().model().rearAttachmentPos() * 0.0625).method_1024((float)Math.toRadians(180.0f - this.method_36454())));
    }

    public class_243 getHeadPos() {
        return this.method_19538().method_1019(new class_243(0.0, 0.0, (double)this.getFrame().model().frontAttachmentPos() * 0.0625).method_1024((float)Math.toRadians(-this.method_36454())));
    }

    public boolean hasSpaceForPassengers() {
        return this.rearAttachment.isRideable() ? this.method_5685().size() < 2 : !this.method_5782();
    }

    public void setSpeed(float horizontal, float vertical) {
        this.hSpeed = horizontal;
        this.vSpeed = vertical;
    }

    @Environment(value=EnvType.CLIENT)
    private void playEngineSound() {
        if (this.getEngine().isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        client.method_1483().method_4873((class_1113)new AutomobileSoundInstance.EngineSound(client, this));
    }

    @Environment(value=EnvType.CLIENT)
    private void playSkiddingSound() {
        class_310 client = class_310.method_1551();
        client.method_1483().method_4873((class_1113)new AutomobileSoundInstance.SkiddingSound(client, this));
    }

    public void method_5773() {
        boolean first = this.field_5953;
        if (this.lastWheelAngle != this.wheelAngle) {
            this.markDirty();
        }
        this.lastWheelAngle = this.wheelAngle;
        if (!this.wasEngineRunning && this.engineRunning() && this.field_6002.method_8608()) {
            this.playEngineSound();
        }
        this.wasEngineRunning = this.engineRunning();
        if (!this.method_5782() || !this.getFrontAttachment().canDrive(this.method_31483())) {
            this.accelerating = false;
            this.braking = false;
            this.steeringLeft = false;
            this.steeringRight = false;
            this.holdingDrift = false;
        }
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        super.method_5773();
        if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
            this.rearAttachment.tick();
        }
        if (!((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
            this.frontAttachment.tick();
        }
        class_243 prevPos = this.method_19538();
        this.positionTrackingTick();
        this.collisionStateTick();
        this.steeringTick();
        this.driftingTick();
        this.burnoutTick();
        this.movementTick();
        if (this.method_5787()) {
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        this.postMovementTick();
        if (!this.field_6002.method_8608()) {
            Object object;
            class_243 prevTailPos = this.prevTailPos != null ? this.prevTailPos : this.getTailPos();
            class_243 tailPos = this.getTailPos();
            this.rearAttachment.pull(prevTailPos.method_1020(tailPos));
            this.prevTailPos = tailPos;
            if (this.dirty) {
                this.syncData();
                this.dirty = false;
            }
            if (this.hasSpaceForPassengers() && !this.decorative) {
                List touchingEntities = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1009(0.2, 0.0, 0.2), class_1301.method_5911((class_1297)this));
                object = touchingEntities.iterator();
                while (object.hasNext()) {
                    class_1297 entity = (class_1297)object.next();
                    if (entity.method_5626((class_1297)this) || entity.method_5765() || !(entity.method_17681() <= this.method_17681()) || !(entity instanceof class_1308) || entity instanceof class_1480) continue;
                    entity.method_5804((class_1297)this);
                }
            }
            if (this.method_5782()) {
                if (this.getFrontAttachment().canDrive(this.method_31483()) && (object = this.method_31483()) instanceof class_1308) {
                    class_1308 mob = (class_1308)object;
                    this.provideMobDriverInputs(mob);
                }
                this.despawnCountdown = 0;
            } else if (this.despawnTime > 0) {
                ++this.despawnCountdown;
                if (this.despawnCountdown >= this.despawnTime) {
                    this.destroyAutomobile(false, class_1297.class_5529.field_26999);
                }
            }
        } else {
            ++this.clientTime;
            this.lastSusBounceTimer = this.suspensionBounceTimer;
            if (this.suspensionBounceTimer > 0) {
                --this.suspensionBounceTimer;
            }
            this.standStillTime = (double)Math.abs(this.hSpeed) < 0.05 && !this.burningOut && this.method_5642() instanceof class_1657 ? AUtils.shift(this.standStillTime, 0.05f, 1.0f) : AUtils.shift(this.standStillTime, 0.15f, -1.3f);
        }
        this.displacementTick(first || this.method_19538().method_1020(prevPos).method_1033() > 0.0 || this.method_36454() != this.field_5982);
    }

    public void positionTrackingTick() {
        if (this.method_5787()) {
            this.lerpTicks = 0;
            this.method_18003(this.method_23317(), this.method_23318(), this.method_23321());
        } else if (this.lerpTicks > 0) {
            this.method_5814(this.method_23317() + (this.trackedX - this.method_23317()) / (double)this.lerpTicks, this.method_23318() + (this.trackedY - this.method_23318()) / (double)this.lerpTicks, this.method_23321() + (this.trackedZ - this.method_23321()) / (double)this.lerpTicks);
            this.method_36456(this.method_36454() + class_3532.method_15393((float)(this.trackedYaw - this.method_36454())) / (float)this.lerpTicks);
            --this.lerpTicks;
        }
    }

    public void markDirty() {
        this.dirty = true;
    }

    private void syncData() {
        this.forNearbyPlayers(200, true, player -> PayloadPackets.sendSyncAutomobileDataPacket(this, player));
    }

    private void syncComponents() {
        this.forNearbyPlayers(200, false, player -> PayloadPackets.sendSyncAutomobileComponentsPacket(this, player));
    }

    private void syncAttachments() {
        this.forNearbyPlayers(200, false, player -> PayloadPackets.sendSyncAutomobileAttachmentsPacket(this, player));
    }

    public class_1799 asPrefabItem() {
        class_1799 stack = new class_1799((class_1935)AutomobilityItems.AUTOMOBILE);
        class_2487 automobile = stack.method_7911("Automobile");
        automobile.method_10582("frame", this.frame.getId().toString());
        automobile.method_10582("wheels", this.wheels.getId().toString());
        automobile.method_10582("engine", this.engine.getId().toString());
        return stack;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.asPrefabItem();
    }

    public void provideMobDriverInputs(class_1308 driver) {
        if (driver == null || driver.method_29504() || driver.method_31481()) {
            if (this.accelerating || this.steeringLeft || this.steeringRight) {
                this.markDirty();
            }
            this.accelerating = false;
            this.steeringLeft = false;
            this.steeringRight = false;
            return;
        }
        class_11 path = driver.method_5942().method_6345();
        if (path != null && !path.method_46() && path.method_45() != null) {
            class_243 fnPos;
            double fnTarget;
            class_243 pos = path.method_45().method_35496().method_1020(this.method_19538());
            double target = class_3532.method_15338((double)Math.toDegrees(Math.atan2(pos.method_10216(), pos.method_10215())));
            if (Math.abs(target - (fnTarget = class_3532.method_15338((double)Math.toDegrees(Math.atan2((fnPos = path.method_29301().method_35496().method_1020(this.method_19538())).method_10216(), fnPos.method_10215()))))) > 69.0) {
                pos = fnPos;
                target = fnTarget;
            }
            float yaw = class_3532.method_15393((float)(-this.method_36454()));
            double offset = class_3532.method_15338((double)((double)yaw - target));
            boolean reverse = false;
            float mul = 0.5f + class_3532.method_15363((float)this.hSpeed, (float)0.0f, (float)1.0f) * 0.5f;
            if (pos.method_1033() < (double)(20.0f * mul) && Math.abs(offset) > (double)(180.0f - 170.0f * mul)) {
                long time = this.field_6002.method_8510();
                reverse = time % 80L <= 30L;
            }
            this.accelerating = !reverse;
            this.braking = reverse;
            if (offset < -7.0) {
                this.steeringRight = reverse;
                this.steeringLeft = !reverse;
            } else if (offset > 7.0) {
                this.steeringRight = !reverse;
                this.steeringLeft = reverse;
            }
            this.markDirty();
        } else {
            if (this.accelerating || this.steeringLeft || this.steeringRight) {
                this.markDirty();
            }
            this.accelerating = false;
            this.steeringLeft = false;
            this.steeringRight = false;
        }
    }

    public void movementTick() {
        class_2248 class_22482;
        class_2338 below;
        class_2680 state;
        this.lastBoostSpeed = this.boostSpeed;
        if (this.boostTimer > 0) {
            --this.boostTimer;
            this.boostSpeed = Math.min(this.boostPower, this.boostSpeed + 0.09f);
            if (this.engineSpeed < this.stats.getComfortableSpeed()) {
                this.engineSpeed += 0.012f;
            }
            this.markDirty();
        } else {
            this.boostSpeed = AUtils.zero(this.boostSpeed, 0.09f);
        }
        class_2338 blockBelow = new class_2338(this.method_23317(), this.method_23318() - 0.05, this.method_23321());
        this.grip = 1.0f - class_3532.method_15363((float)((this.field_6002.method_8320(blockBelow).method_26204().method_9499() - 0.6f) / 0.4f), (float)0.0f, (float)1.0f) * (1.0f - this.stats.getGrip() * 0.8f);
        this.grip *= this.grip;
        if (this.automobileOnGround && this.jumpCooldown <= 0 && this.field_6002.method_8320(this.method_24515()).method_26204() instanceof LaunchGelBlock) {
            this.setSpeed(Math.max(this.getHSpeed(), 0.1f), Math.max(this.getVSpeed(), 0.9f));
            this.jumpCooldown = 5;
            this.automobileOnGround = false;
        }
        this.lastPosForDisplacement = this.method_19538();
        class_243 cumulative = this.addedVelocity;
        cumulative = cumulative.method_1031(0.0, (double)(this.vSpeed * (this.method_5869() ? 0.15f : 1.0f)), 0.0);
        this.speedDirection = this.method_36454() - (this.drifting ? Math.min((float)(this.turboCharge * 6), 43.0f + -this.steering * 12.0f) * (float)this.driftDir : -this.steering * 12.0f);
        if (this.accelerating) {
            float speed = Math.max(this.engineSpeed, 0.0f);
            this.engineSpeed = (float)((double)this.engineSpeed + (this.drifting && AUtils.haveSameSign(this.steering, this.driftDir) || !this.drifting && this.steering != 0.0f && (double)this.hSpeed > 0.5 ? (this.hSpeed < this.stats.getComfortableSpeed() ? 0.001 : 0.0) : (double)this.calculateAcceleration(speed, this.stats) * (this.drifting ? 0.86 : 1.0) * (double)(this.engineSpeed > this.stats.getComfortableSpeed() ? 0.25f : 1.0f) * (double)this.grip));
        }
        if (this.braking) {
            this.engineSpeed = Math.max(this.engineSpeed - 0.15f, -0.25f);
        }
        if (!this.accelerating && !this.braking) {
            this.engineSpeed = AUtils.zero(this.engineSpeed, 0.025f);
        }
        if (!this.drifting && this.steering != 0.0f && (double)this.hSpeed > 0.8) {
            this.engineSpeed -= this.engineSpeed * 4.2E-4f;
        }
        if (this.burningOut()) {
            this.engineSpeed = (float)((double)this.engineSpeed - (double)this.engineSpeed * 0.5);
        }
        this.slopeStickingTimer = (state = this.field_6002.method_8320(below = new class_2338(Math.floor(this.method_23317()), Math.floor(this.method_23318() - 0.51), Math.floor(this.method_23321())))).method_26164(Automobility.STICKY_SLOPES) ? 1 : Math.max(0, this.slopeStickingTimer--);
        if (this.boostSpeed < 0.4f && (class_22482 = this.field_6002.method_8320(this.method_24515()).method_26204()) instanceof OffRoadBlock) {
            OffRoadBlock offRoad = (OffRoadBlock)class_22482;
            int layers = (Integer)this.field_6002.method_8320(this.method_24515()).method_11654((class_2769)OffRoadBlock.LAYERS);
            float cap = this.stats.getComfortableSpeed() * (1.0f - (float)layers / 3.5f);
            this.engineSpeed = Math.min(cap, this.engineSpeed);
            this.debrisColor = offRoad.color;
            this.offRoad = true;
        } else {
            this.offRoad = false;
        }
        if (!this.burningOut()) {
            this.hSpeed = this.engineSpeed + this.boostSpeed;
        }
        double lowestPrevYDisp = 0.0;
        for (double d : this.prevYDisplacements) {
            lowestPrevYDisp = Math.min(d, lowestPrevYDisp);
        }
        if (this.slopeStickingTimer > 0 && this.automobileOnGround && lowestPrevYDisp <= 0.0) {
            double cumulHSpeed = Math.sqrt(cumulative.field_1352 * cumulative.field_1352 + cumulative.field_1350 * cumulative.field_1350);
            cumulative = cumulative.method_1031(0.0, -(0.25 + cumulHSpeed), 0.0);
        }
        float angle = (float)Math.toRadians(-this.speedDirection);
        if (this.burningOut()) {
            if ((double)Math.abs(this.hSpeed) > 0.02) {
                this.addedVelocity = new class_243(Math.sin(angle) * (double)this.hSpeed, 0.0, Math.cos(angle) * (double)this.hSpeed);
                this.hSpeed = 0.0f;
                cumulative = cumulative.method_1019(this.addedVelocity);
            }
        } else {
            cumulative = cumulative.method_1031(Math.sin(angle) * (double)this.hSpeed, 0.0, Math.cos(angle) * (double)this.hSpeed);
        }
        if ((cumulative = cumulative.method_1021((double)this.grip).method_1019(this.lastVelocity.method_1021((double)(1.0f - this.grip)))).method_1033() < 0.001) {
            cumulative = class_243.field_1353;
        }
        float wheelCircumference = (float)((double)(2.0f * (this.wheels.model().radius() / 16.0f)) * Math.PI);
        if (this.hSpeed > 0.0f) {
            this.markDirty();
        }
        this.wheelAngle += 300.0f * (this.hSpeed / wheelCircumference) + (this.hSpeed > 0.0f ? (1.0f - this.grip) * 15.0f : 0.0f);
        if (this.method_5787()) {
            this.method_18799(cumulative);
        }
        this.method_5785();
        this.field_6007 = true;
        this.lastVelocity = cumulative;
        if ((double)Math.abs(this.hSpeed) > 0.2) {
            this.runOverEntities(cumulative);
        }
    }

    public void runOverEntities(class_243 velocity) {
        class_238 frontBox = this.method_5829().method_997(velocity.method_1021(0.5));
        class_243 velAdd = velocity.method_1031(0.0, 0.1, 0.0).method_1021(3.0);
        for (class_1297 entity2 : this.field_6002.method_18023(class_5575.method_31795(class_1297.class), frontBox, entity -> entity != this && entity != this.method_31483())) {
            if (entity2.method_5655() || !(entity2 instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity2;
            if (entity2.method_5854() == this) continue;
            living.method_5643(AutomobilityEntities.AUTOMOBILE_DAMAGE_SOURCE, this.hSpeed * 10.0f);
            entity2.method_5762(velAdd.field_1352, velAdd.field_1351, velAdd.field_1350);
        }
    }

    public void postMovementTick() {
        double addVelLen;
        float addedVelReduction = 0.1f;
        if (this.burningOut()) {
            addedVelReduction = 0.05f;
        }
        if ((addVelLen = this.addedVelocity.method_1033()) > 0.0) {
            this.addedVelocity = this.addedVelocity.method_1021(Math.max(0.0, addVelLen - (double)addedVelReduction) / addVelLen);
        }
        float angle = (float)Math.toRadians(-this.speedDirection);
        if (this.touchingWall && (double)this.hSpeed > 0.1 && this.addedVelocity.method_1033() <= 0.0) {
            this.engineSpeed = (float)((double)this.engineSpeed / 3.6);
            double knockSpeed = -0.2 * (double)this.hSpeed - 0.5;
            this.addedVelocity = this.addedVelocity.method_1031(Math.sin(angle) * knockSpeed, 0.0, Math.cos(angle) * knockSpeed);
            this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), AutomobilitySounds.COLLISION, class_3419.field_15256, 0.76f, 0.65f + 0.06f * (this.field_6002.field_9229.nextFloat() - 0.5f), true);
        }
        double yDisp = this.method_19538().method_1020(this.lastPosForDisplacement).method_10214();
        this.fallTicks = !this.automobileOnGround && yDisp < 0.0 ? ++this.fallTicks : 0;
        double highestPrevYDisp = 0.0;
        for (double d : this.prevYDisplacements) {
            highestPrevYDisp = Math.max(d, highestPrevYDisp);
        }
        if (this.wasOnGround && !this.automobileOnGround && !this.isFloorDirectlyBelow) {
            this.vSpeed = (float)class_3532.method_15350((double)highestPrevYDisp, (double)0.0, (double)(this.hSpeed * 0.6f));
        }
        this.vSpeed = Math.max(this.vSpeed - 0.08f, !this.automobileOnGround ? -1.2f : -0.01f);
        this.prevYDisplacements.push(yDisp);
        if (this.prevYDisplacements.size() > 2) {
            this.prevYDisplacements.removeLast();
        }
        if (this.hSpeed != 0.0f) {
            float vOTarget;
            float f = vOTarget = this.drifting ? (float)(this.driftDir * -23) : this.steering * -5.6f;
            this.lockedViewOffset = vOTarget == 0.0f ? AUtils.zero(this.lockedViewOffset, 2.5f) : (this.lockedViewOffset < vOTarget ? Math.min(this.lockedViewOffset + 3.7f, vOTarget) : Math.max(this.lockedViewOffset - 3.7f, vOTarget));
        }
        float newAngularSpeed = this.angularSpeed;
        if (this.burningOut()) {
            float speed = (float)this.addedVelocity.method_1033();
            float acc = 1.7f / (1.0f + this.frame.weight()) + 4.0f * speed;
            float lim = 9.0f + 4.0f * speed;
            newAngularSpeed = this.steering != 0.0f ? class_3532.method_15363((float)(newAngularSpeed + acc * this.steering), (float)(-lim), (float)lim) : AUtils.shift(newAngularSpeed, acc * 0.5f, 0.0f);
        } else if (this.hSpeed != 0.0f) {
            float traction = 1.0f / (1.0f + 4.0f * this.hSpeed) + 0.3f * this.stats.getGrip();
            newAngularSpeed = AUtils.shift(newAngularSpeed, 6.0f * traction, (this.drifting ? ((this.steering + (float)this.driftDir) * (float)this.driftDir * 2.5f + 1.5f) * (float)this.driftDir * ((1.0f - this.stats.getGrip() + 2.0f) / 2.5f) : this.steering * (4.0f * Math.min(this.hSpeed, 1.0f) + (this.hSpeed > 0.0f ? 2.0f : -3.5f))) * ((this.stats.getHandling() + 1.0f) / 2.0f));
        } else {
            newAngularSpeed = AUtils.shift(newAngularSpeed, 3.0f, 0.0f);
        }
        this.angularSpeed = newAngularSpeed * this.grip + this.angularSpeed * (1.0f - this.grip);
        if ((double)Math.abs(this.angularSpeed) < 3.0E-5) {
            this.angularSpeed = 0.0f;
        }
        if (this.hSpeed != 0.0f || this.burningOut()) {
            float yawInc = this.angularSpeed;
            float prevYaw = this.method_36454();
            this.method_36456(this.method_36454() + yawInc);
            if (this.field_6002.field_9236) {
                class_1297 passenger = this.method_31483();
                if (passenger instanceof class_1657) {
                    class_1657 player = (class_1657)passenger;
                    if (AutomobileEntity.inLockedViewMode()) {
                        player.method_36456(class_3532.method_15393((float)(this.method_36454() + this.lockedViewOffset)));
                        player.method_5636(class_3532.method_15393((float)(this.method_36454() + this.lockedViewOffset)));
                    } else {
                        player.method_36456(class_3532.method_15393((float)(player.method_36454() + yawInc)));
                        player.method_5636(class_3532.method_15393((float)(player.method_36454() + yawInc)));
                    }
                }
            } else {
                for (class_1297 e : this.method_5685()) {
                    if (e != this.method_31483()) continue;
                    e.method_36456(class_3532.method_15393((float)(e.method_36454() + yawInc)));
                    e.method_5636(class_3532.method_15393((float)(e.method_36454() + yawInc)));
                }
            }
            if (this.field_6002.method_8608()) {
                this.field_5982 = prevYaw;
            }
        }
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        if (!this.field_6002.method_8608() && movementType == class_1313.field_6305) {
            AUtils.IGNORE_ENTITY_GROUND_CHECK_STEPPING = true;
        }
        super.method_5784(movementType, movement);
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public void accumulateCollisionAreas(Collection<CollisionArea> areas) {
        this.field_6002.method_8390(class_1297.class, this.method_5829().method_1009(3.0, 3.0, 3.0), e -> e != this && e.method_5854() != this).forEach(e -> areas.add(CollisionArea.entity(e)));
    }

    public void displacementTick(boolean tick) {
        if (this.field_6002.method_8608()) {
            this.displacement.preTick();
            if (tick) {
                this.displacement.otherColliders.clear();
                this.accumulateCollisionAreas(this.displacement.otherColliders);
                this.displacement.tick(this.field_6002, this, this.method_19538(), this.method_36454(), this.field_6013);
            }
            if (this.field_6002.method_8320(this.method_24515()).method_26204() instanceof AutomobileAssemblerBlock) {
                this.displacement.lastVertical = this.displacement.verticalTarget = -this.wheels.model().radius() / 16.0f;
            }
        }
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public void collisionStateTick() {
        this.wasOnGround = this.automobileOnGround;
        this.automobileOnGround = false;
        this.isFloorDirectlyBelow = false;
        this.touchingWall = false;
        class_238 b = this.method_5829();
        class_238 groundBox = new class_238(b.field_1323, b.field_1322 - 0.04, b.field_1321, b.field_1320, b.field_1322, b.field_1324);
        double wid = (b.method_17939() + b.method_17941()) * 0.5;
        class_238 floorBox = new class_238(b.field_1323 + wid * 0.94, b.field_1322 - 0.05, b.field_1321 + wid * 0.94, b.field_1320 - wid * 0.94, b.field_1322, b.field_1324 - wid * 0.94);
        class_238 wallBox = b.method_1011(0.05).method_997(this.lastVelocity.method_1029().method_1021(0.12));
        class_2338 start = new class_2338(b.field_1323 - 0.1, b.field_1322 - 0.2, b.field_1321 - 0.1);
        class_2338 end = new class_2338(b.field_1320 + 0.1, b.field_1325 + 0.2 + (double)this.field_6013, b.field_1324 + 0.1);
        class_265 groundCuboid = class_259.method_1078((class_238)groundBox);
        class_265 floorCuboid = class_259.method_1078((class_238)floorBox);
        class_265 wallCuboid = class_259.method_1078((class_238)wallBox);
        class_265 stepWallCuboid = wallCuboid.method_1096(0.0, (double)this.field_6013 - 0.05, 0.0);
        boolean wallHit = false;
        boolean stepWallHit = false;
        class_3726 shapeCtx = class_3726.method_16195((class_1297)this);
        if (this.field_6002.method_22343(start, end)) {
            class_2338.class_2339 pos = new class_2338.class_2339();
            for (int x = start.method_10263(); x <= end.method_10263(); ++x) {
                for (int y = start.method_10264(); y <= end.method_10264(); ++y) {
                    for (int z = start.method_10260(); z <= end.method_10260(); ++z) {
                        pos.method_10103(x, y, z);
                        class_2680 state = this.field_6002.method_8320((class_2338)pos);
                        class_265 blockShape = state.method_26194((class_1922)this.field_6002, (class_2338)pos, shapeCtx).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                        this.automobileOnGround |= class_259.method_1074((class_265)blockShape, (class_265)groundCuboid, (class_247)class_247.field_16896);
                        this.isFloorDirectlyBelow |= class_259.method_1074((class_265)blockShape, (class_265)floorCuboid, (class_247)class_247.field_16896);
                        wallHit |= class_259.method_1074((class_265)blockShape, (class_265)wallCuboid, (class_247)class_247.field_16896);
                        stepWallHit |= class_259.method_1074((class_265)blockShape, (class_265)stepWallCuboid, (class_247)class_247.field_16896);
                    }
                }
            }
        }
        this.touchingWall = wallHit && stepWallHit;
        HashSet<CollisionArea> otherColliders = new HashSet<CollisionArea>();
        this.accumulateCollisionAreas(otherColliders);
        this.automobileOnGround |= otherColliders.stream().anyMatch(col -> col.boxIntersects(groundBox));
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.trackedX = x;
        this.trackedY = y;
        this.trackedZ = z;
        this.trackedYaw = yaw;
        this.lerpTicks = this.method_5864().method_18388() + 1;
    }

    private float calculateAcceleration(float speed, AutomobileStats stats) {
        return 1.0f / (300.0f * speed + (18.5f - stats.getAcceleration() * 5.3f)) * (0.9f * ((stats.getAcceleration() + 1.0f) / 2.0f));
    }

    @Environment(value=EnvType.CLIENT)
    public void provideClientInput(boolean fwd, boolean back, boolean left, boolean right, boolean space) {
        if (fwd != this.accelerating || back != this.braking || left != this.steeringLeft || right != this.steeringRight || space != this.holdingDrift) {
            this.setInputs(fwd, back, left, right, space);
            PayloadPackets.sendSyncAutomobileInputPacket(this, this.accelerating, this.braking, this.steeringLeft, this.steeringRight, this.holdingDrift);
        }
    }

    public void setInputs(boolean fwd, boolean back, boolean left, boolean right, boolean space) {
        this.accelerating = fwd;
        this.braking = back;
        this.steeringLeft = left;
        this.steeringRight = right;
        this.holdingDrift = space;
    }

    public void boost(float power, int time) {
        if (power > this.boostPower || time > this.boostTimer) {
            this.boostTimer = time;
            this.boostPower = power;
        }
        if (this.method_5787()) {
            this.engineSpeed = Math.max(this.engineSpeed, this.stats.getComfortableSpeed() * 0.5f);
        }
    }

    private void steeringTick() {
        this.lastSteering = this.steering;
        if (this.steeringLeft == this.steeringRight) {
            this.steering = AUtils.zero(this.steering, 0.42f);
        } else if (this.steeringLeft) {
            this.steering -= 0.42f;
            this.steering = Math.max(-1.0f, this.steering);
        } else {
            this.steering += 0.42f;
            this.steering = Math.min(1.0f, this.steering);
        }
    }

    private void consumeTurboCharge() {
        if (this.turboCharge > 115) {
            this.boost(0.38f, 38);
        } else if (this.turboCharge > 70) {
            this.boost(0.3f, 21);
        } else if (this.turboCharge > 35) {
            this.boost(0.23f, 9);
        }
        this.turboCharge = 0;
    }

    private void driftingTick() {
        if (!this.prevHoldDrift && this.holdingDrift) {
            RearAttachment rearAttachment;
            if (this.steering != 0.0f && !this.drifting && this.hSpeed > 0.4f && this.automobileOnGround) {
                this.setDrifting(true);
                this.driftDir = this.steering > 0.0f ? 1 : -1;
                this.engineSpeed = (float)((double)this.engineSpeed - 0.028 * (double)this.engineSpeed);
            } else if (this.steering == 0.0f && !this.method_37908().method_8608() && (rearAttachment = this.getRearAttachment()) instanceof DeployableRearAttachment) {
                DeployableRearAttachment att = (DeployableRearAttachment)rearAttachment;
                att.deploy();
            }
        }
        if (this.drifting) {
            if (this.automobileOnGround()) {
                this.createDriftParticles();
            }
            if (this.prevHoldDrift && !this.holdingDrift) {
                this.setDrifting(false);
                this.consumeTurboCharge();
            } else if (this.hSpeed < 0.33f) {
                this.setDrifting(false);
                this.turboCharge = 0;
            }
            if (this.automobileOnGround) {
                this.turboCharge += this.steeringLeft && this.driftDir < 0 || this.steeringRight && this.driftDir > 0 ? 2 : 1;
            }
        }
        this.prevHoldDrift = this.holdingDrift;
    }

    private void endBurnout() {
        this.setBurningOut(false);
        this.engineSpeed = 0.0f;
    }

    private void burnoutTick() {
        if (this.burningOut()) {
            if (this.automobileOnGround()) {
                if (this.addedVelocity.method_1033() > 0.05 || (double)Math.abs(this.angularSpeed) > 0.05) {
                    this.createDriftParticles();
                }
                if ((double)this.hSpeed < 0.08 && this.turboCharge <= 35) {
                    ++this.turboCharge;
                }
            }
            if (!this.braking) {
                this.endBurnout();
                this.consumeTurboCharge();
            } else if (!this.accelerating) {
                this.endBurnout();
                this.turboCharge = 0;
            }
            this.wheelAngle += 20.0f;
        } else if ((this.accelerating || (double)this.hSpeed > 0.05) && this.braking) {
            this.setBurningOut(true);
            this.turboCharge = 0;
        }
    }

    public void createDriftParticles() {
        class_243 origin = this.method_19538().method_1031(0.0, (double)this.displacement.verticalTarget, 0.0);
        for (WheelBase.WheelPos wheel : this.getFrame().model().wheelBase().wheels) {
            if (wheel.end() != WheelBase.WheelEnd.BACK) continue;
            class_243 pos = new class_243((double)(wheel.right() + (float)(wheel.right() > 0.0f ? 1 : -1) * this.getWheels().model().width() * wheel.scale()), 0.0, (double)wheel.forward()).method_1037((float)Math.toRadians(this.displacement.currAngularX)).method_31033((float)Math.toRadians(this.displacement.currAngularZ)).method_1024((float)Math.toRadians(-this.method_36454())).method_1021(0.0625).method_1031(0.0, 0.4, 0.0);
            this.field_6002.method_8406((class_2394)AutomobilityParticles.DRIFT_SMOKE, origin.field_1352 + pos.field_1352, origin.field_1351 + pos.field_1351, origin.field_1350 + pos.field_1350, 0.0, 0.0, 0.0);
        }
    }

    private static boolean inLockedViewMode() {
        return ControllerUtils.inControllerMode();
    }

    @Environment(value=EnvType.CLIENT)
    private void updateModels(class_5617.class_5618 ctx) {
        if (this.updateModels) {
            this.frameModel = this.frame.model().model().apply(ctx);
            this.wheelModel = this.wheels.model().model().apply(ctx);
            this.engineModel = this.engine.model().model().apply(ctx);
            this.rearAttachmentModel = ((RearAttachmentType)this.rearAttachment.type).model().model().apply(ctx);
            this.frontAttachmentModel = ((FrontAttachmentType)this.frontAttachment.type).model().model().apply(ctx);
            this.updateModels = false;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_3879 getWheelModel(class_5617.class_5618 ctx) {
        this.updateModels(ctx);
        return this.wheelModel;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_3879 getFrameModel(class_5617.class_5618 ctx) {
        this.updateModels(ctx);
        return this.frameModel;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_3879 getEngineModel(class_5617.class_5618 ctx) {
        this.updateModels(ctx);
        return this.engineModel;
    }

    @Override
    @Nullable
    public class_3879 getRearAttachmentModel(class_5617.class_5618 ctx) {
        this.updateModels(ctx);
        return this.rearAttachmentModel;
    }

    @Override
    @Nullable
    public class_3879 getFrontAttachmentModel(class_5617.class_5618 ctx) {
        this.updateModels(ctx);
        return this.frontAttachmentModel;
    }

    @Override
    public float getAutomobileYaw(float tickDelta) {
        return this.method_5705(tickDelta);
    }

    @Override
    public float getRearAttachmentYaw(float tickDelta) {
        return this.rearAttachment.yaw(tickDelta);
    }

    @Nullable
    public class_1297 method_5642() {
        return this.method_31483();
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.hasSpaceForPassengers();
    }

    @Override
    public boolean hasInventory() {
        return this.getRearAttachment().hasMenu();
    }

    @Override
    public void openInventory(class_1657 player) {
        class_3908 factory = this.getRearAttachment().createMenu(new AutomobileScreenHandlerContext(this));
        if (factory != null) {
            player.method_17355(factory);
        }
    }

    public float getStandStillTime() {
        return this.standStillTime;
    }

    public void playHitSound() {
        this.field_6002.method_33596(class_5712.field_28736, (class_1297)this);
        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_26960, class_3419.field_15256, 1.0f, 0.9f + this.field_6002.field_9229.nextFloat() * 0.2f);
    }

    private void dropParts(class_243 pos) {
        this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, pos.field_1352, pos.field_1351, pos.field_1350, AutomobilityItems.AUTOMOBILE_FRAME.createStack(this.getFrame())));
        this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, pos.field_1352, pos.field_1351, pos.field_1350, AutomobilityItems.AUTOMOBILE_ENGINE.createStack(this.getEngine())));
        class_1799 wheelStack = AutomobilityItems.AUTOMOBILE_WHEEL.createStack(this.getWheels());
        wheelStack.method_7939(this.getFrame().model().wheelBase().wheelCount);
        this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, pos.field_1352, pos.field_1351, pos.field_1350, wheelStack));
    }

    public void destroyRearAttachment(boolean drop) {
        if (drop) {
            class_243 dropPos = this.rearAttachment.pos();
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, AutomobilityItems.REAR_ATTACHMENT.createStack(this.getRearAttachmentType())));
        }
        this.setRearAttachment(RearAttachmentType.EMPTY);
    }

    public void destroyFrontAttachment(boolean drop) {
        if (drop) {
            class_243 dropPos = this.frontAttachment.pos();
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, AutomobilityItems.FRONT_ATTACHMENT.createStack(this.getFrontAttachmentType())));
        }
        this.setFrontAttachment(FrontAttachmentType.EMPTY);
    }

    public void destroyAutomobile(boolean drop, class_1297.class_5529 reason) {
        if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
            this.destroyRearAttachment(drop);
        }
        if (!((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
            this.destroyFrontAttachment(drop);
        }
        if (drop) {
            this.dropParts(this.method_19538().method_1031(0.0, 0.3, 0.0));
        }
        this.method_5650(reason);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5715() && this.hasInventory()) {
            if (!this.field_6002.method_8608()) {
                this.openInventory(player);
                return class_1269.field_5811;
            }
            return class_1269.field_5812;
        }
        class_1799 stack = player.method_5998(hand);
        if ((!this.decorative || player.method_7337()) && stack.method_31574(AutomobilityItems.CROWBAR)) {
            double playerAngle = Math.toDegrees(Math.atan2(player.method_23321() - this.method_23321(), player.method_23317() - this.method_23317()));
            double angleDiff = class_3532.method_15338((double)((double)this.method_36454() - playerAngle));
            if (angleDiff < 0.0 && !((FrontAttachmentType)this.frontAttachment.type).isEmpty()) {
                this.destroyFrontAttachment(!player.method_7337());
                this.playHitSound();
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (!((RearAttachmentType)this.rearAttachment.type).isEmpty()) {
                this.destroyRearAttachment(!player.method_7337());
                this.playHitSound();
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            this.destroyAutomobile(!player.method_7337(), class_1297.class_5529.field_26998);
            this.playHitSound();
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (!this.decorative) {
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof AutomobileInteractable) {
                AutomobileInteractable interactable = (AutomobileInteractable)class_17922;
                return interactable.interactAutomobile(stack, player, hand, this);
            }
            if (!this.hasSpaceForPassengers()) {
                if (!(this.method_31483() instanceof class_1657)) {
                    if (!this.field_6002.method_8608()) {
                        this.method_31483().method_5848();
                    }
                    return class_1269.method_29236((boolean)this.field_6002.field_9236);
                }
                return class_1269.field_5811;
            }
            if (!this.field_6002.method_8608()) {
                player.method_5804((class_1297)this);
            }
            return class_1269.method_29236((boolean)this.field_6002.method_8608());
        }
        return class_1269.field_5811;
    }

    public double method_5621() {
        return (this.wheels.model().radius() + this.frame.model().seatHeight() - 4.0f) / 16.0f;
    }

    public void method_5865(class_1297 passenger) {
        if (passenger == this.method_31483()) {
            class_243 pos = this.method_19538().method_1031(0.0, (double)this.displacement.verticalTarget + passenger.method_5678(), 0.0).method_1019(new class_243(0.0, this.method_5621(), 0.0).method_1037((float)Math.toRadians(-this.displacement.currAngularX)).method_31033((float)Math.toRadians(-this.displacement.currAngularZ)));
            passenger.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        } else if (this.method_5626(passenger)) {
            class_243 pos = this.method_19538().method_1019(new class_243(0.0, (double)this.displacement.verticalTarget, (double)this.getFrame().model().rearAttachmentPos() * 0.0625).method_1024((float)Math.toRadians(180.0f - this.method_36454())).method_1031(0.0, this.rearAttachment.getPassengerHeightOffset() + passenger.method_5678() - 0.14, 0.0).method_1019(this.rearAttachment.scaledYawVec()).method_1037((float)Math.toRadians(-this.displacement.currAngularX)).method_31033((float)Math.toRadians(-this.displacement.currAngularZ)));
            passenger.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        }
    }

    public boolean method_30949(class_1297 other) {
        return class_1690.method_30959((class_1297)this, (class_1297)other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public boolean method_5810() {
        return true;
    }

    protected void method_5693() {
        this.field_6011.method_12784(REAR_ATTACHMENT_YAW, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(REAR_ATTACHMENT_ANIMATION, (Object)Float.valueOf(0.0f));
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (REAR_ATTACHMENT_YAW.equals(data)) {
            this.rearAttachment.onTrackedYawUpdated(this.getTrackedRearAttachmentYaw());
        } else if (REAR_ATTACHMENT_ANIMATION.equals(data)) {
            this.rearAttachment.onTrackedAnimationUpdated(this.getTrackedRearAttachmentAnimation());
        } else if (FRONT_ATTACHMENT_ANIMATION.equals(data)) {
            this.frontAttachment.onTrackedAnimationUpdated(this.getTrackedFrontAttachmentAnimation());
        }
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void setTrackedRearAttachmentYaw(float value) {
        this.field_6011.method_12778(REAR_ATTACHMENT_YAW, (Object)Float.valueOf(value));
    }

    public float getTrackedRearAttachmentYaw() {
        return ((Float)this.field_6011.method_12789(REAR_ATTACHMENT_YAW)).floatValue();
    }

    public void setTrackedRearAttachmentAnimation(float animation) {
        this.field_6011.method_12778(REAR_ATTACHMENT_ANIMATION, (Object)Float.valueOf(animation));
    }

    public float getTrackedRearAttachmentAnimation() {
        return ((Float)this.field_6011.method_12789(REAR_ATTACHMENT_ANIMATION)).floatValue();
    }

    public void setTrackedFrontAttachmentAnimation(float animation) {
        this.field_6011.method_12778(FRONT_ATTACHMENT_ANIMATION, (Object)Float.valueOf(animation));
    }

    public float getTrackedFrontAttachmentAnimation() {
        return ((Float)this.field_6011.method_12789(FRONT_ATTACHMENT_ANIMATION)).floatValue();
    }

    public void bounce() {
        this.suspensionBounceTimer = 3;
        this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), AutomobilitySounds.LANDING, class_3419.field_15256, 1.0f, 1.5f + 0.15f * (this.field_6002.field_9229.nextFloat() - 0.5f), true);
    }

    public static final class Displacement {
        private static final int SCAN_STEPS_PER_BLOCK = 20;
        private static final double INV_SCAN_STEPS = 0.05;
        private boolean wereAllOnGround = true;
        private float lastVertical = 0.0f;
        private float lastAngularX = 0.0f;
        private float lastAngularZ = 0.0f;
        private float currAngularX = 0.0f;
        private float currAngularZ = 0.0f;
        private float verticalTarget = 0.0f;
        private float angularXTarget = 0.0f;
        private float angularZTarget = 0.0f;
        private final List<class_243> scanPoints = new ArrayList<class_243>();
        public final Set<CollisionArea> otherColliders = new HashSet<CollisionArea>();

        public void preTick() {
            this.lastAngularX = this.currAngularX;
            this.lastAngularZ = this.currAngularZ;
            this.lastVertical = this.verticalTarget;
            this.currAngularX = AUtils.shift(this.currAngularX, 9.0f, this.angularXTarget);
            this.currAngularZ = AUtils.shift(this.currAngularZ, 9.0f, this.angularZTarget);
        }

        public void tick(class_1937 world, AutomobileEntity entity, class_243 centerPos, double yaw, double stepHeight) {
            yaw = 360.0 - yaw;
            class_243 lowestDisplacementPos = null;
            class_243 highestDisplacementPos = null;
            ArrayList<class_243> scannedPoints = new ArrayList<class_243>();
            HashSet<CollisionArea> colliders = new HashSet<CollisionArea>();
            boolean anyOnGround = false;
            boolean allOnGround = true;
            for (class_243 scanPoint : this.scanPoints) {
                scanPoint = scanPoint.method_1024((float)Math.toRadians(yaw));
                class_243 pointPos = scanPoint.method_1019(centerPos);
                colliders.clear();
                colliders.addAll(this.otherColliders);
                double scanDist = scanPoint.method_1033();
                int heightOffset = (int)Math.ceil(scanDist);
                class_3980 iter = new class_3980((int)Math.min(Math.floor(centerPos.field_1352), Math.floor(pointPos.field_1352)), (int)Math.floor(centerPos.field_1351) - heightOffset, (int)Math.min(Math.floor(centerPos.field_1350), Math.floor(pointPos.field_1350)), (int)Math.max(Math.floor(centerPos.field_1352), Math.floor(pointPos.field_1352)), (int)Math.floor(centerPos.field_1351) + heightOffset, (int)Math.max(Math.floor(centerPos.field_1350), Math.floor(pointPos.field_1350)));
                class_2338.class_2339 mpos = new class_2338.class_2339();
                while (iter.method_17963()) {
                    mpos.method_10103(iter.method_18671(), iter.method_18672(), iter.method_18673());
                    class_265 shape = world.method_8320((class_2338)mpos).method_26220((class_1922)world, (class_2338)mpos);
                    if (shape.method_1110()) continue;
                    if (shape == class_259.method_1077()) {
                        colliders.add(CollisionArea.box(mpos.method_10263(), (double)mpos.method_10264() - 0.1, mpos.method_10260(), mpos.method_10263() + 1, mpos.method_10264() + 1, mpos.method_10260() + 1));
                        continue;
                    }
                    shape.method_1096((double)mpos.method_10263(), (double)mpos.method_10264(), (double)mpos.method_10260()).method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> colliders.add(CollisionArea.box(minX, minY - 0.1, minZ, maxX, maxY, maxZ)));
                }
                class_243 pointDir = new class_243(scanPoint.field_1352, 0.0, scanPoint.field_1350).method_1029().method_1021(0.05);
                double pointY = centerPos.field_1351;
                int i = 0;
                while ((double)i < Math.ceil(scanDist * 20.0)) {
                    double pointX = centerPos.field_1352 + (double)i * pointDir.field_1352;
                    double pointZ = centerPos.field_1350 + (double)i * pointDir.field_1350;
                    pointY -= 0.07500000000000001;
                    boolean ground = false;
                    for (CollisionArea col : colliders) {
                        double hY;
                        double diff;
                        if (!col.isPointInside(pointX, pointY, pointZ) || !((diff = (hY = col.highestY(pointX, pointY, pointZ)) - pointY) < stepHeight + 0.07500000000000001)) continue;
                        pointY = hY;
                        ground = true;
                    }
                    if (ground) {
                        anyOnGround = true;
                    } else {
                        allOnGround = false;
                    }
                    ++i;
                }
                pointPos = new class_243(pointPos.field_1352, pointY, pointPos.field_1350);
                if (lowestDisplacementPos == null || pointPos.field_1351 < lowestDisplacementPos.field_1351) {
                    lowestDisplacementPos = pointPos;
                }
                if (highestDisplacementPos == null || pointPos.field_1351 > highestDisplacementPos.field_1351) {
                    highestDisplacementPos = pointPos;
                }
                scannedPoints.add(pointPos);
            }
            if (allOnGround && !this.wereAllOnGround) {
                entity.bounce();
            }
            this.wereAllOnGround = allOnGround;
            if (!anyOnGround) {
                return;
            }
            this.angularXTarget = 0.0f;
            this.angularZTarget = 0.0f;
            this.verticalTarget = 0.0f;
            if (lowestDisplacementPos != null) {
                class_243 displacementCenterPos = new class_243(centerPos.field_1352, (lowestDisplacementPos.field_1351 + highestDisplacementPos.field_1351) * 0.5, centerPos.field_1350);
                class_243 combinedNormals = class_243.field_1353;
                int normalCount = 0;
                class_243 positiveXOffset = null;
                class_243 negativeXOffset = null;
                class_243 positiveZOffset = null;
                class_243 negativeZOffset = null;
                for (class_243 pointPos : scannedPoints) {
                    class_243 normal;
                    class_243 pointOffset = pointPos.method_1020(displacementCenterPos);
                    if (pointOffset.field_1352 > 0.0) {
                        if (positiveXOffset != null) {
                            normal = positiveXOffset.method_1036(pointOffset).method_1029();
                            if (normal.field_1351 < 0.0) {
                                normal = normal.method_22882();
                            }
                            combinedNormals = combinedNormals.method_1019(normal);
                            ++normalCount;
                            positiveXOffset = null;
                            continue;
                        }
                        positiveXOffset = pointOffset;
                        continue;
                    }
                    if (pointOffset.field_1352 < 0.0) {
                        if (negativeXOffset != null) {
                            normal = negativeXOffset.method_1036(pointOffset).method_1029();
                            if (normal.field_1351 < 0.0) {
                                normal = normal.method_22882();
                            }
                            combinedNormals = combinedNormals.method_1019(normal);
                            ++normalCount;
                            negativeXOffset = null;
                            continue;
                        }
                        negativeXOffset = pointOffset;
                        continue;
                    }
                    if (pointOffset.field_1350 > 0.0) {
                        if (positiveZOffset != null) {
                            normal = positiveZOffset.method_1036(pointOffset).method_1029();
                            if (normal.field_1351 < 0.0) {
                                normal = normal.method_22882();
                            }
                            combinedNormals = combinedNormals.method_1019(normal);
                            ++normalCount;
                            positiveZOffset = null;
                            continue;
                        }
                        positiveZOffset = pointOffset;
                        continue;
                    }
                    if (!(pointOffset.field_1350 < 0.0)) continue;
                    if (negativeZOffset != null) {
                        normal = negativeZOffset.method_1036(pointOffset).method_1029();
                        if (normal.field_1351 < 0.0) {
                            normal = normal.method_22882();
                        }
                        combinedNormals = combinedNormals.method_1019(normal);
                        ++normalCount;
                        negativeZOffset = null;
                        continue;
                    }
                    negativeZOffset = pointOffset;
                }
                combinedNormals = normalCount > 0 ? combinedNormals.method_1021((double)(1.0f / (float)normalCount)) : new class_243(0.0, 1.0, 0.0);
                this.angularXTarget = class_3532.method_15393((float)(90.0f - (float)Math.toDegrees(Math.atan2(combinedNormals.field_1351, combinedNormals.field_1350))));
                this.angularZTarget = class_3532.method_15393((float)(270.0f + (float)Math.toDegrees(Math.atan2(combinedNormals.field_1351, combinedNormals.field_1352))));
                this.verticalTarget = (float)displacementCenterPos.method_1020((class_243)centerPos).field_1351;
            }
        }

        public void applyWheelbase(WheelBase wheelBase) {
            this.scanPoints.clear();
            for (WheelBase.WheelPos pos : wheelBase.wheels) {
                this.scanPoints.add(new class_243((double)(pos.right() / 16.0f), 0.0, (double)(pos.forward() / 16.0f)));
            }
        }

        public float getVertical(float tickDelta) {
            return class_3532.method_16439((float)tickDelta, (float)this.lastVertical, (float)this.verticalTarget);
        }

        public float getAngularX(float tickDelta) {
            return class_3532.method_17821((float)tickDelta, (float)this.lastAngularX, (float)this.currAngularX);
        }

        public float getAngularZ(float tickDelta) {
            return class_3532.method_17821((float)tickDelta, (float)this.lastAngularZ, (float)this.currAngularZ);
        }
    }
}

