/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.automobile.AutomobileComponent;
import io.github.foundationgames.automobility.util.SimpleMapContentRegistry;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_6501;
import org.jetbrains.annotations.Nullable;

public class AutomobileComponentItem<T extends AutomobileComponent<T>>
extends class_1792 {
    protected final String nbtKey;
    protected final String translationKey;
    protected final SimpleMapContentRegistry<T> registry;

    public AutomobileComponentItem(class_1792.class_1793 settings, String nbtKey, String translationKey, SimpleMapContentRegistry<T> registry) {
        super(settings);
        this.nbtKey = nbtKey;
        this.translationKey = translationKey;
        this.registry = registry;
    }

    public class_1799 createStack(T component) {
        if (component.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 stack = new class_1799((class_1935)this);
        this.setComponent(stack, component.getId());
        return stack;
    }

    public void setComponent(class_1799 stack, class_2960 component) {
        stack.method_7948().method_10582(this.nbtKey, component.toString());
    }

    public T getComponent(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545(this.nbtKey)) {
            return (T)((AutomobileComponent)this.registry.getOrDefault(class_2960.method_12829((String)stack.method_7969().method_10558(this.nbtKey))));
        }
        return (T)((AutomobileComponent)this.registry.getOrDefault(null));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        T component = this.getComponent(stack);
        class_2960 id = component.getId();
        String compKey = id.method_12836() + "." + id.method_12832();
        tooltip.add((class_2561)new class_2588(this.translationKey + "." + compKey).method_27692(class_124.field_1078));
        component.appendTexts(tooltip, component);
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        if (this.method_7877(group)) {
            this.registry.forEach(component -> {
                if (this.addToCreative(component)) {
                    stacks.add((Object)this.createStack(component));
                }
            });
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected boolean renders(T component) {
        return !component.isEmpty();
    }

    protected boolean addToCreative(T component) {
        return !component.isEmpty();
    }

    @Environment(value=EnvType.CLIENT)
    public void registerItemRenderer(Function<T, class_3879> modelProvider, Function<T, class_2960> textureProvider, class_6501<T> scaleProvider) {
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)this, (stack, mode, matrices, vertexConsumers, light, overlay) -> {
            T component = this.getComponent(stack);
            if (this.renders(component)) {
                class_3879 model = (class_3879)modelProvider.apply(component);
                float scale = scaleProvider.apply(component);
                matrices.method_22904(0.5, 0.0, 0.5);
                matrices.method_22905(scale, -scale, -scale);
                model.method_2828(matrices, vertexConsumers.getBuffer(model.method_23500((class_2960)textureProvider.apply(component))), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
    }
}

