/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.iterator.PatternType;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class PatternCommand
extends ChunkyCommand {
    public PatternCommand(Chunky chunky) {
        super(chunky);
    }

    @Override
    public void execute(Sender sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage("help_pattern", new Object[0]);
            return;
        }
        Optional<String> inputPattern = Input.tryPattern(args[1]);
        if (!inputPattern.isPresent()) {
            sender.sendMessage("help_pattern", new Object[0]);
            return;
        }
        String pattern = inputPattern.get();
        this.chunky.getSelection().pattern(pattern);
        sender.sendMessagePrefixed("format_pattern", Translator.translate("pattern_" + pattern, new Object[0]));
    }

    @Override
    public List<String> tabSuggestions(String[] args) {
        if (args.length == 2) {
            return PatternType.ALL;
        }
        return Collections.emptyList();
    }
}

