/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.iterator;

import org.popcraft.chunky.Selection;
import org.popcraft.chunky.iterator.ChunkIterator;
import org.popcraft.chunky.iterator.ConcentricChunkIterator;
import org.popcraft.chunky.iterator.Loop2ChunkIterator;
import org.popcraft.chunky.iterator.SpiralChunkIterator;

public class ChunkIteratorFactory {
    private ChunkIteratorFactory() {
    }

    public static ChunkIterator getChunkIterator(Selection selection, long count) {
        switch (selection.shape()) {
            case "rectangle": 
            case "ellipse": 
            case "oval": {
                return new Loop2ChunkIterator(selection, count);
            }
        }
        switch (selection.pattern()) {
            case "loop": {
                return new Loop2ChunkIterator(selection, count);
            }
            case "spiral": {
                return new SpiralChunkIterator(selection, count);
            }
        }
        return new ConcentricChunkIterator(selection, count);
    }

    public static ChunkIterator getChunkIterator(Selection selection) {
        return ChunkIteratorFactory.getChunkIterator(selection, 0L);
    }
}

