/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.Config;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class GsonConfig
implements Config {
    private final Supplier<Chunky> chunky;
    private final Gson gson;
    private final Path configPath;
    private ConfigModel configModel;

    public GsonConfig(Supplier<Chunky> chunky, File configFile) {
        this.chunky = chunky;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.configPath = configFile.toPath();
        if (!configFile.exists()) {
            try {
                if (configFile.createNewFile()) {
                    this.configModel = new ConfigModel();
                    this.configModel.version = 1;
                    this.configModel.language = "en";
                    this.configModel.continueOnRestart = false;
                    this.saveConfig();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.reload();
        }
        Translator.setLanguage(this.getLanguage());
    }

    @Override
    public Path getDirectory() {
        return this.configPath.getParent();
    }

    @Override
    public Optional<GenerationTask> loadTask(World world) {
        if (this.configModel == null) {
            return Optional.empty();
        }
        Map tasks = this.configModel.tasks;
        if (tasks == null) {
            return Optional.empty();
        }
        TaskModel taskModel = (TaskModel)tasks.get(world.getName());
        if (taskModel == null || taskModel.cancelled.booleanValue()) {
            return Optional.empty();
        }
        Selection.Builder selection = Selection.builder(world).centerX(taskModel.centerX).centerZ(taskModel.centerZ).radiusX(taskModel.radius).radiusZ(taskModel.radiusZ == null ? taskModel.radius : taskModel.radiusZ).pattern(taskModel.iterator).shape(taskModel.shape);
        long count = taskModel.count;
        long time = taskModel.time;
        return Optional.of(new GenerationTask(this.chunky.get(), selection.build(), count, time));
    }

    @Override
    public List<GenerationTask> loadTasks() {
        ArrayList<GenerationTask> generationTasks = new ArrayList<GenerationTask>();
        this.chunky.get().getServer().getWorlds().forEach(world -> this.loadTask((World)world).ifPresent(generationTasks::add));
        return generationTasks;
    }

    @Override
    public void saveTask(GenerationTask generationTask) {
        if (this.configModel == null) {
            this.configModel = new ConfigModel();
        }
        if (this.configModel.tasks == null) {
            this.configModel.tasks = new HashMap();
        }
        Map tasks = this.configModel.tasks;
        Selection selection = generationTask.getSelection();
        TaskModel taskModel = tasks.getOrDefault(selection.world().getName(), new TaskModel());
        String shape = generationTask.getShape().name();
        taskModel.cancelled = generationTask.isCancelled();
        taskModel.radius = selection.radiusX();
        if ("rectangle".equals(shape) || "ellipse".equals(shape)) {
            taskModel.radiusZ = selection.radiusZ();
        }
        taskModel.centerX = selection.centerX();
        taskModel.centerZ = selection.centerZ();
        taskModel.iterator = generationTask.getChunkIterator().name();
        taskModel.shape = shape;
        taskModel.count = generationTask.getCount();
        taskModel.time = generationTask.getTotalTime();
        tasks.put(selection.world().getName(), taskModel);
        this.saveConfig();
    }

    @Override
    public void saveTasks() {
        this.chunky.get().getGenerationTasks().values().forEach(this::saveTask);
    }

    @Override
    public void cancelTask(World world) {
        this.loadTask(world).ifPresent(generationTask -> {
            generationTask.stop(true);
            this.saveTask((GenerationTask)generationTask);
        });
    }

    @Override
    public void cancelTasks() {
        this.loadTasks().forEach(generationTask -> {
            generationTask.stop(true);
            this.saveTask((GenerationTask)generationTask);
        });
    }

    @Override
    public int getVersion() {
        return this.getConfigModel().map(model -> ((ConfigModel)model).version).orElse(0);
    }

    @Override
    public String getLanguage() {
        return this.getConfigModel().map(model -> Input.checkLanguage(((ConfigModel)model).language)).orElse("en");
    }

    @Override
    public boolean getContinueOnRestart() {
        return this.getConfigModel().map(model -> ((ConfigModel)model).continueOnRestart).orElse(false);
    }

    @Override
    public void reload() {
        StringBuilder configBuilder = new StringBuilder();
        try (Stream<String> input = Files.lines(this.configPath);){
            input.forEach(configBuilder::append);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configModel = (ConfigModel)this.gson.fromJson(configBuilder.toString(), new TypeToken<ConfigModel>(){}.getType());
    }

    public void saveConfig() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configPath.toFile()));){
            this.gson.toJson((Object)this.configModel, new TypeToken<ConfigModel>(){}.getType(), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Optional<ConfigModel> getConfigModel() {
        return Optional.ofNullable(this.configModel);
    }

    public static class TaskModel {
        private Boolean cancelled;
        private Double radius;
        private Double radiusZ;
        private Double centerX;
        private Double centerZ;
        private String iterator;
        private String shape;
        private Long count;
        private Long time;

        public Boolean getCancelled() {
            return this.cancelled;
        }

        public void setCancelled(Boolean cancelled) {
            this.cancelled = cancelled;
        }

        public Double getRadius() {
            return this.radius;
        }

        public void setRadius(Double radius) {
            this.radius = radius;
        }

        public Double getRadiusZ() {
            return this.radiusZ;
        }

        public void setRadiusZ(Double radiusZ) {
            this.radiusZ = radiusZ;
        }

        public Double getCenterX() {
            return this.centerX;
        }

        public void setCenterX(Double centerX) {
            this.centerX = centerX;
        }

        public Double getCenterZ() {
            return this.centerZ;
        }

        public void setCenterZ(Double centerZ) {
            this.centerZ = centerZ;
        }

        public String getIterator() {
            return this.iterator;
        }

        public void setIterator(String iterator) {
            this.iterator = iterator;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }
    }

    public static class ConfigModel {
        private Integer version;
        private String language;
        private Boolean continueOnRestart;
        private Map<String, TaskModel> tasks;

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public Boolean getContinueOnRestart() {
            return this.continueOnRestart;
        }

        public void setContinueOnRestart(Boolean continueOnRestart) {
            this.continueOnRestart = continueOnRestart;
        }

        public Map<String, TaskModel> getTasks() {
            return this.tasks;
        }

        public void setTasks(Map<String, TaskModel> tasks) {
            this.tasks = tasks;
        }
    }
}

