/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandPerformEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import fr.frinn.custommachinery.api.component.variant.RegisterComponentVariantEvent;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.command.CMCommand;
import fr.frinn.custommachinery.common.component.variant.ComponentVariantRegistry;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.CustomMachineJsonReloadListener;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.network.SLootTablesPacket;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.network.SUpdateUpgradesPacket;
import fr.frinn.custommachinery.common.upgrade.Upgrades;
import fr.frinn.custommachinery.common.upgrade.UpgradesCustomReloadListener;
import fr.frinn.custommachinery.common.util.CMLogger;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import fr.frinn.custommachinery.common.util.MachineList;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.class_1269;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMachinery {
    public static final String MODID = "custommachinery";
    public static Logger LOGGER = LogManager.getLogger((String)"Custom Machinery");
    public static final Map<class_2960, CustomMachine> MACHINES = new HashMap<class_2960, CustomMachine>();
    public static final Upgrades UPGRADES = new Upgrades();

    public static void init() {
        ConfigHolder config = AutoConfig.register(CMConfig.class, Toml4jConfigSerializer::new);
        config.registerSaveListener((holder, cmConfig) -> {
            CMLogger.setDebugLevel(cmConfig.debugLevel.getLevel());
            return class_1269.field_5812;
        });
        CMLogger.init();
        Registration.BLOCKS.register();
        Registration.ITEMS.register();
        Registration.TILE_ENTITIES.register();
        Registration.CONTAINERS.register();
        Registration.RECIPE_SERIALIZERS.register();
        Registration.RECIPE_TYPES.register();
        Registration.GUI_ELEMENTS.register();
        Registration.MACHINE_COMPONENTS.register();
        Registration.REQUIREMENTS.register();
        Registration.APPEARANCE_PROPERTIES.register();
        Registration.DATAS.register();
        Registration.PROCESSORS.register();
        RegisterComponentVariantEvent.EVENT.register(Registration::registerComponentVariants);
        LifecycleEvent.SETUP.register(CustomMachinery::setup);
        LifecycleEvent.SERVER_STARTING.register(CustomMachinery::serverStarting);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new CustomMachineJsonReloadListener());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new UpgradesCustomReloadListener());
        CommandRegistrationEvent.EVENT.register(CustomMachinery::registerCommands);
        CommandPerformEvent.EVENT.register(CustomMachinery::onReload);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> ClientHandler::init);
    }

    private static void setup() {
        PacketManager.init();
        ComponentVariantRegistry.init();
    }

    private static void serverStarting(MinecraftServer server) {
        LootTableHelper.generate(server);
    }

    public static void syncData(class_3222 player) {
        new SUpdateMachinesPacket(MACHINES).sendTo(player);
        new SUpdateUpgradesPacket(UPGRADES.getAllUpgrades()).sendTo(player);
        new SLootTablesPacket(LootTableHelper.getLoots()).sendTo(player);
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 selection) {
        dispatcher.register(CMCommand.register(MODID));
        dispatcher.register(CMCommand.register("cm"));
    }

    private static EventResult onReload(CommandPerformEvent event) {
        if (event.getResults().getReader().getString().startsWith("/reload")) {
            CMLogger.reset();
            MachineList.setNeedRefresh();
        }
        return EventResult.pass();
    }
}

