/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.client.integration.jei.RecipeHelper;
import fr.frinn.custommachinery.client.integration.jei.RequirementDisplayInfo;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.impl.integration.jei.GuiElementJEIRendererRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3956;
import net.minecraft.class_4587;

public abstract class AbstractRecipeCategory<T extends IMachineRecipe>
implements IRecipeCategory<T> {
    protected static final int ICON_SIZE = 10;
    protected final CustomMachine machine;
    protected final RecipeType<T> recipeType;
    protected final IGuiHelper guiHelper;
    protected final RecipeHelper recipeHelper;
    protected final LoadingCache<IDisplayInfoRequirement, RequirementDisplayInfo> infoCache;
    protected LoadingCache<T, List<IJEIIngredientWrapper<?>>> wrapperCache;
    protected int offsetX;
    protected int offsetY;
    protected int width;
    protected int height;
    protected int rowY;
    protected int maxIconPerRow;

    public AbstractRecipeCategory(CustomMachine machine, RecipeType<T> type, IJeiHelpers helpers) {
        this.machine = machine;
        this.recipeType = type;
        this.guiHelper = helpers.getGuiHelper();
        this.recipeHelper = new RecipeHelper(machine, helpers);
        this.setupRecipeDimensions();
        this.infoCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IDisplayInfoRequirement, RequirementDisplayInfo>(){

            public RequirementDisplayInfo load(IDisplayInfoRequirement requirement) {
                RequirementDisplayInfo info = new RequirementDisplayInfo();
                requirement.getDisplayInfo(info);
                return info;
            }
        });
        this.wrapperCache = CacheBuilder.newBuilder().build(new CacheLoader<T, List<IJEIIngredientWrapper<?>>>(){

            public List<IJEIIngredientWrapper<?>> load(T recipe) {
                ImmutableList.Builder wrappers = ImmutableList.builder();
                recipe.getJEIIngredientRequirements().forEach(requirement -> wrappers.addAll(requirement.getJEIIngredientWrappers((IMachineRecipe)recipe)));
                return wrappers.build();
            }
        });
    }

    private void setupRecipeDimensions() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        List<IGuiElement> elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        for (IGuiElement element : elements) {
            if (!GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType())) continue;
            minX = Math.min(minX, element.getX());
            minY = Math.min(minY, element.getY());
            maxX = Math.max(maxX, element.getX() + element.getWidth());
            maxY = Math.max(maxY, element.getY() + element.getHeight());
        }
        this.rowY = Math.max(maxY - minY, 20);
        this.offsetX = Math.max(minX, 0);
        this.offsetY = Math.max(minY, 0);
        this.width = Math.max(maxX - minX, 20);
        this.maxIconPerRow = this.width / 12;
        int maxDisplayRequirement = class_310.method_1551().field_1687.method_8433().method_30027((class_3956)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().filter(recipe -> recipe.getMachineId().equals((Object)this.machine.getId())).mapToInt(recipe -> recipe.getDisplayInfoRequirements().size()).max().orElse(1);
        int rows = maxDisplayRequirement / this.maxIconPerRow + 1;
        this.height = this.rowY + 12 * rows;
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public class_2960 getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends T> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public class_2561 getTitle() {
        return this.machine.getName();
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(this.width, this.height);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CustomMachineItem.makeMachineItem(this.machine.getId()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(this.width - 11, this.height - 11);
        ArrayList wrappers = new ArrayList((Collection)this.wrapperCache.getUnchecked(recipe));
        List<IGuiElement> elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        elements.forEach(element -> {
            Iterator iterator = wrappers.iterator();
            while (iterator.hasNext()) {
                IJEIIngredientWrapper wrapper = (IJEIIngredientWrapper)iterator.next();
                if (!wrapper.setupRecipe(builder, this.offsetX, this.offsetY, (IGuiElement)element, this.recipeHelper)) continue;
                iterator.remove();
                break;
            }
        });
    }

    public void draw(T recipe, IRecipeSlotsView slotsView, class_4587 matrix, double mouseX, double mouseY) {
        List<IGuiElement> elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        elements.stream().filter(element -> GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType())).forEach(element -> {
            int x = element.getX() - this.offsetX;
            int y = element.getY() - this.offsetY;
            IJEIElementRenderer<IGuiElement> renderer = GuiElementJEIRendererRegistry.getJEIRenderer(element.getType());
            matrix.method_22903();
            matrix.method_22904((double)(-this.offsetX), (double)(-this.offsetY), 0.0);
            renderer.renderElementInJEI(matrix, (IGuiElement)element, (IMachineRecipe)recipe, (int)mouseX, (int)mouseY);
            matrix.method_22909();
        });
        class_332.method_25294((class_4587)matrix, (int)-3, (int)this.rowY, (int)(this.width + 3), (int)(this.rowY + 1), (int)0x30000000);
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        recipe.getDisplayInfoRequirements().stream().map(this.infoCache).forEach(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            matrix.method_22903();
            matrix.method_22904((double)x, (double)y, 0.0);
            info.renderIcon(matrix, 10);
            matrix.method_22909();
        });
    }

    public List<class_2561> getTooltipStrings(T recipe, IRecipeSlotsView view, double mouseX, double mouseY) {
        List<IGuiElement> elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        for (IGuiElement element : elements) {
            int y;
            int x;
            IJEIElementRenderer<IGuiElement> renderer;
            if (!GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) || !(renderer = GuiElementJEIRendererRegistry.getJEIRenderer(element.getType())).isHoveredInJei(element, x = element.getX() - this.offsetX, y = element.getY() - this.offsetY, (int)mouseX, (int)mouseY)) continue;
            return renderer.getJEITooltips(element, (IMachineRecipe)recipe);
        }
        int index = 0;
        int row = 0;
        for (RequirementDisplayInfo info : recipe.getDisplayInfoRequirements().stream().map(this.infoCache).toList()) {
            int x = index * 12 - 2;
            int y = this.rowY + 2 + 12 * row;
            if (index++ >= this.maxIconPerRow) {
                index = 0;
                ++row;
            }
            if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + 10)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + 10)) || class_310.method_1551().field_1755 == null) continue;
            return info.getTooltips();
        }
        return Collections.emptyList();
    }

    public boolean handleInput(T recipe, double mouseX, double mouseY, class_3675.class_306 mouseButton) {
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        return recipe.getDisplayInfoRequirements().stream().map(this.infoCache).anyMatch(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            if (mouseX >= (double)x && mouseX <= (double)(x + 10) && mouseY >= (double)y && mouseY <= (double)(y + 10) && class_310.method_1551().field_1755 != null) {
                return info.handleClick(this.machine, mouseButton);
            }
            return false;
        });
    }
}

