/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.google.common.collect.Lists;
import dev.architectury.registry.fuel.FuelRegistry;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.client.integration.jei.CMRecipeTypes;
import fr.frinn.custommachinery.client.integration.jei.CustomCraftRecipeCategory;
import fr.frinn.custommachinery.client.integration.jei.CustomMachineRecipeCategory;
import fr.frinn.custommachinery.client.integration.jei.DummyIngredientRenderer;
import fr.frinn.custommachinery.client.integration.jei.energy.EnergyIngredientHelper;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;

@JeiPlugin
public class CustomMachineryJEIPlugin
implements IModPlugin {
    public static final class_2960 PLUGIN_ID = new class_2960("custommachinery", "jei_plugin");
    public static final List<class_1799> FUEL_INGREDIENTS = Lists.newArrayList();

    public class_2960 getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new class_1792[]{(class_1792)Registration.CUSTOM_MACHINE_ITEM.get()});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        CustomMachinery.MACHINES.forEach((id, machine) -> {
            if (machine.getProcessorTemplate().getType() == Registration.MACHINE_PROCESSOR.get()) {
                registry.addRecipeCategories(new IRecipeCategory[]{new CustomMachineRecipeCategory((CustomMachine)machine, CMRecipeTypes.create(id, CustomMachineRecipe.class), registry.getJeiHelpers())});
            } else if (machine.getProcessorTemplate().getType() == Registration.CRAFT_PROCESSOR.get()) {
                registry.addRecipeCategories(new IRecipeCategory[]{new CustomCraftRecipeCategory((CustomMachine)machine, CMRecipeTypes.create(id, CustomCraftRecipe.class), registry.getJeiHelpers())});
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registry) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        Map<class_2960, List<CustomMachineRecipe>> machineRecipes = class_310.method_1551().field_1687.method_8433().method_30027((class_3956)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().sorted(Comparators.JEI_PRIORITY_COMPARATOR.reversed()).collect(Collectors.groupingBy(CustomMachineRecipe::getMachineId));
        machineRecipes.forEach((id, list) -> {
            RecipeType<CustomMachineRecipe> type = CMRecipeTypes.machine(id);
            if (type != null) {
                registry.addRecipes(type, list);
            }
        });
        Map<class_2960, List<CustomCraftRecipe>> craftRecipes = class_310.method_1551().field_1687.method_8433().method_30027((class_3956)Registration.CUSTOM_CRAFT_RECIPE.get()).stream().sorted(Comparators.JEI_PRIORITY_COMPARATOR.reversed()).collect(Collectors.groupingBy(CustomCraftRecipe::getMachineId));
        craftRecipes.forEach((id, list) -> {
            RecipeType<CustomCraftRecipe> type = CMRecipeTypes.craft(id);
            if (type != null) {
                registry.addRecipes(type, list);
            }
        });
        registry.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK).stream().filter(stack -> FuelRegistry.get((class_1799)stack) > 0).forEach(FUEL_INGREDIENTS::add);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(CustomIngredientTypes.ENERGY, new ArrayList(), (IIngredientHelper)new EnergyIngredientHelper(), new DummyIngredientRenderer());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CustomMachineScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<CustomMachineScreen>(){

            public Collection<IGuiClickableArea> getGuiClickableAreas(CustomMachineScreen screen, double mouseX, double mouseY) {
                List<IGuiElement> elements = screen.getMachine().getGuiElements();
                ProgressBarGuiElement progress = elements.stream().filter(element -> element.getType() == Registration.PROGRESS_GUI_ELEMENT.get()).findFirst().orElse(null);
                if (progress != null) {
                    int posX = progress.getX();
                    int posY = progress.getY();
                    boolean invertAxis = progress.getEmptyTexture().equals((Object)ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && progress.getFilledTexture().equals((Object)ProgressBarGuiElement.BASE_FILLED_TEXTURE) && progress.getDirection() != ProgressBarGuiElement.Orientation.RIGHT && progress.getDirection() != ProgressBarGuiElement.Orientation.LEFT;
                    int width = invertAxis ? progress.getHeight() : progress.getWidth();
                    int height = invertAxis ? progress.getWidth() : progress.getHeight();
                    return Collections.singleton(IGuiClickableArea.createBasic((int)posX, (int)posY, (int)width, (int)height, (RecipeType[])new RecipeType[]{CMRecipeTypes.fromID(screen.getMachine().getId())}));
                }
                return Collections.emptyList();
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        CustomMachinery.MACHINES.forEach((id, machine) -> {
            RecipeType<? extends IMachineRecipe> type = CMRecipeTypes.fromID(id);
            if (type != null) {
                registration.addRecipeCatalyst(CustomMachineItem.makeMachineItem(id), new RecipeType[]{type});
                machine.getCatalysts().stream().filter(catalyst -> CustomMachinery.MACHINES.containsKey(catalyst) && !catalyst.equals(id)).forEach(catalyst -> registration.addRecipeCatalyst(CustomMachineItem.makeMachineItem(catalyst), new RecipeType[]{type}));
            }
        });
    }
}

