/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.impl.util.TextureSizeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4587;

public class RequirementDisplayInfo
implements IDisplayInfo {
    private class_2960 icon = new class_2960("custommachinery", "textures/gui/creation/create_icon.png");
    private int width = 10;
    private int height = 10;
    private int u = 0;
    private int v = 0;
    private class_1058 sprite;
    private class_1799 item;
    private final List<class_2561> tooltips = new ArrayList<class_2561>();
    private BiConsumer<ICustomMachine, Integer> clickAction;
    private IconType iconType = IconType.TEXTURE;

    @Override
    public RequirementDisplayInfo setTextureIcon(class_2960 icon, int width, int height, int u, int v) {
        this.icon = icon;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.iconType = IconType.TEXTURE;
        return this;
    }

    @Override
    public IDisplayInfo setSpriteIcon(class_1058 sprite) {
        this.sprite = sprite;
        this.iconType = IconType.ANIMATED;
        return this;
    }

    @Override
    public RequirementDisplayInfo setItemIcon(class_1799 stack) {
        this.item = stack;
        this.iconType = IconType.ITEM;
        return this;
    }

    @Override
    public RequirementDisplayInfo addTooltip(class_2561 tooltip) {
        this.tooltips.add(tooltip);
        return this;
    }

    @Override
    public void setClickAction(BiConsumer<ICustomMachine, Integer> clickAction) {
        this.clickAction = clickAction;
    }

    public void renderIcon(class_4587 matrix, int size) {
        switch (this.iconType) {
            case TEXTURE: {
                ClientHandler.bindTexture(this.icon);
                class_332.method_25293((class_4587)matrix, (int)0, (int)0, (int)size, (int)size, (float)this.u, (float)this.v, (int)this.width, (int)this.height, (int)TextureSizeHelper.getTextureWidth(this.icon), (int)TextureSizeHelper.getTextureHeight(this.icon));
                break;
            }
            case ANIMATED: {
                ClientHandler.bindTexture(this.sprite.method_24119().method_24106());
                class_332.method_25298((class_4587)matrix, (int)0, (int)0, (int)0, (int)size, (int)size, (class_1058)this.sprite);
                break;
            }
            case ITEM: {
                matrix.method_22905((float)size / 16.0f, (float)size / 16.0f, 1.0f);
                ClientHandler.renderItemAndEffectsIntoGUI(matrix, this.item, 0, 0);
            }
        }
    }

    public List<class_2561> getTooltips() {
        return this.tooltips;
    }

    public boolean hasClickAction() {
        return this.clickAction != null;
    }

    public boolean handleClick(CustomMachine machine, class_3675.class_306 button) {
        if (this.hasClickAction()) {
            this.clickAction.accept(machine, button.method_1444());
            return true;
        }
        return false;
    }

    public static enum IconType {
        TEXTURE,
        ANIMATED,
        ITEM;

    }
}

