/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.client.integration.jei.energy.EnergyJEIIngredientRenderer;
import fr.frinn.custommachinery.common.guielement.EnergyGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.integration.jei.CustomIngredientTypes;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.class_2588;

public class EnergyIngredientWrapper
implements IJEIIngredientWrapper<Energy> {
    private final RequirementIOMode mode;
    private final int recipeTime;
    private final Energy energy;

    public EnergyIngredientWrapper(RequirementIOMode mode, int amount, double chance, boolean isPerTick, int recipeTime) {
        this.mode = mode;
        this.recipeTime = recipeTime;
        this.energy = new Energy(amount, chance, isPerTick);
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        EnergyGuiElement energyElement;
        block3: {
            block2: {
                if (!(element instanceof EnergyGuiElement)) break block2;
                energyElement = (EnergyGuiElement)element;
                if (element.getType() == Registration.ENERGY_GUI_ELEMENT.get()) break block3;
            }
            return false;
        }
        ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset, element.getY() - yOffset).setCustomRenderer(CustomIngredientTypes.ENERGY, (IIngredientRenderer)new EnergyJEIIngredientRenderer(energyElement)).addIngredient(CustomIngredientTypes.ENERGY, (Object)this.energy)).addTooltipCallback((recipeSlotView, tooltip) -> {
            class_2588 component;
            String amount = Utils.format(this.energy.getAmount()) + " " + PlatformHelper.energy().unit();
            if (this.energy.isPerTick()) {
                String totalEnergy = Utils.format(this.energy.getAmount() * this.recipeTime) + " " + PlatformHelper.energy().unit();
                component = this.mode == RequirementIOMode.INPUT ? new class_2588("custommachinery.jei.ingredient.energy.pertick.input", new Object[]{totalEnergy, amount}) : new class_2588("custommachinery.jei.ingredient.energy.pertick.output", new Object[]{totalEnergy, amount});
            } else {
                component = this.mode == RequirementIOMode.INPUT ? new class_2588("custommachinery.jei.ingredient.energy.input", new Object[]{amount}) : new class_2588("custommachinery.jei.ingredient.energy.output", new Object[]{amount});
            }
            tooltip.set(0, component);
        });
        return true;
    }
}

