/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ItemIngredientWrapper
implements IJEIIngredientWrapper<class_1799> {
    private final RequirementIOMode mode;
    private final IIngredient<class_1792> item;
    private final int amount;
    private final double chance;
    private final boolean useDurability;
    @Nullable
    private final class_2487 nbt;
    private final String slot;

    public ItemIngredientWrapper(RequirementIOMode mode, IIngredient<class_1792> item, int amount, double chance, boolean useDurability, @Nullable class_2487 nbt, String slot) {
        this.mode = mode;
        this.item = item;
        this.amount = amount;
        this.chance = chance;
        this.useDurability = useDurability;
        this.nbt = nbt;
        this.slot = slot;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        SlotGuiElement slotElement;
        block5: {
            block4: {
                if (!(element instanceof SlotGuiElement)) break block4;
                slotElement = (SlotGuiElement)element;
                if (element.getType() == Registration.SLOT_GUI_ELEMENT.get()) break block5;
            }
            return false;
        }
        List<class_1799> ingredients = this.item.getAll().stream().map(item -> Utils.makeItemStack(item, this.useDurability ? 1 : this.amount, this.nbt)).toList();
        Optional<IMachineComponentTemplate<?>> template = helper.getComponentForElement(slotElement);
        if (slotElement.getID().equals(this.slot) || template.map(t -> t.canAccept(ingredients, this.mode == RequirementIOMode.INPUT, helper.getDummyManager()) && (this.slot.isEmpty() || t.getId().equals(this.slot))).orElse(false).booleanValue()) {
            ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset, element.getY() - yOffset).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, ingredients)).addTooltipCallback((view, tooltips) -> {
                if (this.useDurability && this.mode == RequirementIOMode.INPUT) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.item.durability.consume", new Object[]{this.amount}));
                } else if (this.useDurability && this.mode == RequirementIOMode.OUTPUT) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.item.durability.repair", new Object[]{this.amount}));
                }
                if (this.chance == 0.0) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.chance.0").method_27692(class_124.field_1079));
                } else if (this.chance != 1.0) {
                    double percentage = this.chance * 100.0;
                    if (percentage < (double)0.01f) {
                        tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{"<0.01"}));
                    } else {
                        BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                        if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                            tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{decimal.intValue()}));
                        } else {
                            tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{decimal.doubleValue()}));
                        }
                    }
                }
                if (!this.slot.isEmpty() && class_310.method_1551().field_1690.field_1827) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.item.specificSlot").method_27692(class_124.field_1079));
                }
            });
            return true;
        }
        return false;
    }
}

