/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import net.minecraft.class_1058;
import net.minecraft.class_1159;
import net.minecraft.class_1723;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class FluidRenderer {
    private static final int MIN_FLUID_HEIGHT = 1;
    private static final int TEXTURE_SIZE = 16;

    public static void renderFluid(class_4587 poseStack, int posX, int posY, int width, int height, FluidStack fluidStack, long capacity) {
        class_3611 fluid = fluidStack.getFluid();
        if (fluid == null || fluid == class_3612.field_15906) {
            return;
        }
        RenderSystem.enableBlend();
        poseStack.method_22903();
        poseStack.method_22904((double)posX, (double)posY, 0.0);
        class_1058 sprite = FluidStackHooks.getStillTexture((FluidStack)fluidStack);
        int fluidColor = FluidStackHooks.getColor((FluidStack)fluidStack);
        long amount = fluidStack.getAmount();
        int scaledAmount = (int)(amount * (long)height / capacity);
        if (amount > 0L && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > height) {
            scaledAmount = height;
        }
        FluidRenderer.drawTiledSprite(poseStack, width, height, fluidColor, scaledAmount, sprite);
        poseStack.method_22909();
        RenderSystem.disableBlend();
    }

    private static void drawTiledSprite(class_4587 poseStack, int tiledWidth, int tiledHeight, int color, int scaledAmount, class_1058 sprite) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        class_1159 matrix = poseStack.method_23760().method_23761();
        FluidRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xTile * 16;
                int y = tiledHeight - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 1.0f;
        }
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(class_1159 matrix, float xCoord, float yCoord, class_1058 textureSprite, int maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + (float)maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        tessellator.method_1350();
    }
}

