/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public abstract class BaseScreen
extends class_437 {
    private static final class_2960 BLANK_BACKGROUND = new class_2960("custommachinery", "textures/gui/background.png");
    private final List<Widget> customWidgets = new ArrayList<Widget>();
    private final List<Pair<DragType, Rectangle>> draggingAreas = new ArrayList<Pair<DragType, Rectangle>>();
    public final int xSize;
    public final int ySize;
    private int xPos;
    private int yPos;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private double widthOffset = 0.0;
    private double heightOffset = 0.0;
    private DragType currentDragType = DragType.NONE;
    @Nullable
    private PopupScreen popup = null;

    public BaseScreen(class_2561 component, int xSize, int ySize) {
        super(component);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public int getX() {
        return this.xPos + (int)this.xOffset;
    }

    public int getY() {
        return this.yPos + (int)this.yOffset;
    }

    public int getWidth() {
        return this.xSize + (int)this.widthOffset;
    }

    public int getHeight() {
        return this.ySize + (int)this.heightOffset;
    }

    public <T extends Widget> T addCustomWidget(T widget) {
        this.customWidgets.add(widget);
        return widget;
    }

    protected <T extends class_364 & class_6379> T method_25429(T listener) {
        throw new IllegalStateException("Forbidden method");
    }

    protected <T extends class_4068> T method_37060(T widget) {
        throw new IllegalStateException("Forbidden method");
    }

    protected <T extends class_364 & class_4068> T method_37063(T widget) {
        throw new IllegalStateException("Forbidden method");
    }

    public void openPopup(PopupScreen popup) {
        this.popup = popup;
        this.popup.setParent(this);
        this.popup.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
    }

    public void closePopup() {
        this.popup = null;
    }

    public void addDraggingArea(DragType type, Rectangle rectangle) {
        this.draggingAreas.add((Pair<DragType, Rectangle>)Pair.of((Object)((Object)type), (Object)rectangle));
    }

    public DragType getDragType(double mouseX, double mouseY) {
        for (Pair<DragType, Rectangle> pair : this.draggingAreas) {
            if (!((Rectangle)pair.getSecond()).isIn(mouseX, mouseY)) continue;
            return (DragType)((Object)pair.getFirst());
        }
        return DragType.NONE;
    }

    public void baseMoveDraggingArea() {
        this.addDraggingArea(DragType.MOVE, new Rectangle(() -> this.getX() + 2, () -> this.getX() + this.getWidth() - 2, () -> this.getY() + 2, () -> this.getY() + 10));
    }

    public void baseSizeDraggingArea(int margin) {
        this.addDraggingArea(DragType.TOP, new Rectangle(() -> this.getX() + margin, () -> this.getX() + this.getWidth() - margin, () -> this.getY() - margin, () -> this.getY() + margin));
        this.addDraggingArea(DragType.TOP_LEFT, new Rectangle(() -> this.getX() - margin, () -> this.getX() + margin, () -> this.getY() - margin, () -> this.getY() + margin));
        this.addDraggingArea(DragType.TOP_RIGHT, new Rectangle(() -> this.getX() + this.getWidth() - margin, () -> this.getX() + this.getWidth() + margin, () -> this.getY() - margin, () -> this.getY() + margin));
        this.addDraggingArea(DragType.LEFT, new Rectangle(() -> this.getX() - margin, () -> this.getX() + margin, () -> this.getY() + margin, () -> this.getY() + this.getHeight() - margin));
        this.addDraggingArea(DragType.RIGHT, new Rectangle(() -> this.getX() + this.getWidth() - margin, () -> this.getX() + this.getWidth() + margin, () -> this.getY() + margin, () -> this.getY() + this.getHeight() - margin));
        this.addDraggingArea(DragType.BOTTOM, new Rectangle(() -> this.getX() + margin, () -> this.getX() + this.getWidth() - margin, () -> this.getY() + this.getHeight() - margin, () -> this.getY() + this.getHeight() + margin));
        this.addDraggingArea(DragType.BOTTOM_LEFT, new Rectangle(() -> this.getX() - margin, () -> this.getX() + margin, () -> this.getY() + this.getHeight() - margin, () -> this.getY() + this.getHeight() + margin));
        this.addDraggingArea(DragType.BOTTOM_RIGHT, new Rectangle(() -> this.getX() + this.getWidth() - margin, () -> this.getX() + this.getWidth() + margin, () -> this.getY() + this.getHeight() - margin, () -> this.getY() + this.getHeight() + margin));
    }

    protected void method_25426() {
        this.customWidgets.clear();
        this.draggingAreas.clear();
        this.xPos = (this.field_22789 - this.xSize) / 2;
        this.yPos = (this.field_22790 - this.ySize) / 2;
        if (this.popup != null) {
            this.popup.method_25423(class_310.method_1551(), this.field_22789, this.field_22790);
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        this.customWidgets.forEach(widget -> widget.render(poseStack, mouseX, mouseY, partialTicks));
        if (this.popup != null) {
            this.popup.method_25394(poseStack, mouseX, mouseY, partialTicks);
            return;
        }
        this.customWidgets.stream().filter(widget -> widget.method_25405(mouseX, mouseY)).forEach(widget -> this.method_32634(poseStack, widget.getTooltips(), Optional.empty(), mouseX, mouseY));
    }

    public void method_25420(class_4587 pose) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.popup != null) {
            return this.popup.method_25402(mouseX, mouseY, button);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.method_25405(mouseX, mouseY) || !widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        this.currentDragType = this.getDragType(mouseX, mouseY);
        if (this.currentDragType != DragType.NONE) {
            this.method_25398(true);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.method_25398(false);
        this.currentDragType = DragType.NONE;
        if (this.popup != null) {
            return this.popup.method_25406(mouseX, mouseY, button);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.method_25405(mouseX, mouseY) || !widget.method_25406(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.popup != null) {
            return this.popup.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.method_25397() && button == 0 && this.currentDragType != DragType.NONE) {
            switch (this.currentDragType) {
                case MOVE: {
                    this.xOffset += dragX;
                    this.yOffset += dragY;
                    break;
                }
                case TOP: {
                    this.yOffset = Math.min(0.0, this.yOffset + dragY);
                    this.heightOffset = Math.max(0.0, this.heightOffset - dragY);
                    break;
                }
                case BOTTOM: {
                    this.heightOffset = Math.max(0.0, this.heightOffset + dragY);
                    break;
                }
                case LEFT: {
                    this.widthOffset = Math.max(0.0, this.widthOffset - dragX);
                    if (!(this.widthOffset > 0.0)) break;
                    this.xOffset = Math.min(0.0, this.xOffset + dragX);
                    break;
                }
                case RIGHT: {
                    this.widthOffset = Math.max(0.0, this.widthOffset + dragX);
                    break;
                }
                case TOP_LEFT: 
                case TOP_RIGHT: 
                case BOTTOM_LEFT: 
                case BOTTOM_RIGHT: {
                    this.widthOffset += dragX;
                    this.heightOffset += dragY;
                }
            }
            return true;
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.method_25405(mouseX, mouseY) || !widget.method_25403(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.popup != null) {
            return this.popup.method_25401(mouseX, mouseY, delta);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.method_25405(mouseX, mouseY) || !widget.method_25401(mouseX, mouseY, delta)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.popup != null) {
            return this.popup.method_25404(keyCode, scanCode, modifiers);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.popup != null) {
            return this.popup.method_16803(keyCode, scanCode, modifiers);
        }
        for (Widget widget : this.customWidgets) {
            if (!widget.method_16803(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    public static void baseBackground(class_4587 pose, int x, int y, int width, int height) {
        class_332.method_33284((class_4587)pose, (int)x, (int)y, (int)width, (int)height, (int)-1072689136, (int)-804253680, (int)0);
    }

    public static void blankBackground(class_4587 pose, int x, int y, int width, int height) {
        BaseScreen.bindTexture(BLANK_BACKGROUND);
        BaseScreen.method_25290((class_4587)pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)4, (int)4, (int)8, (int)8);
        BaseScreen.method_25293((class_4587)pose, (int)(x + 4), (int)y, (int)(width - 8), (int)4, (float)4.0f, (float)0.0f, (int)1, (int)4, (int)8, (int)8);
        BaseScreen.method_25290((class_4587)pose, (int)(x + width - 4), (int)y, (float)4.0f, (float)0.0f, (int)4, (int)3, (int)8, (int)8);
        BaseScreen.method_25293((class_4587)pose, (int)x, (int)(y + 4), (int)4, (int)(height - 7), (float)0.0f, (float)4.0f, (int)4, (int)1, (int)8, (int)8);
        BaseScreen.method_25293((class_4587)pose, (int)(x + 4), (int)(y + 4), (int)(width - 7), (int)(height - 7), (float)4.0f, (float)3.0f, (int)1, (int)1, (int)8, (int)8);
        BaseScreen.method_25293((class_4587)pose, (int)(x + width - 4), (int)(y + 3), (int)4, (int)(height - 7), (float)4.0f, (float)3.0f, (int)4, (int)1, (int)8, (int)8);
        BaseScreen.method_25290((class_4587)pose, (int)x, (int)(y + height - 3), (float)0.0f, (float)5.0f, (int)4, (int)3, (int)8, (int)8);
        BaseScreen.method_25293((class_4587)pose, (int)(x + 4), (int)(y + height - 4), (int)(width - 8), (int)4, (float)3.0f, (float)4.0f, (int)1, (int)4, (int)8, (int)8);
        BaseScreen.method_25293((class_4587)pose, (int)(x + width - 4), (int)(y + height - 4), (int)4, (int)4, (float)4.0f, (float)4.0f, (int)4, (int)4, (int)8, (int)8);
    }

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static enum DragType {
        MOVE,
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT,
        NONE;

    }

    public static class Rectangle {
        private final Supplier<Integer> left;
        private final Supplier<Integer> right;
        private final Supplier<Integer> top;
        private final Supplier<Integer> bottom;

        public Rectangle(Supplier<Integer> left, Supplier<Integer> right, Supplier<Integer> top, Supplier<Integer> bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }

        public boolean isIn(double x, double y) {
            return x >= (double)this.left.get().intValue() && x <= (double)this.right.get().intValue() && y >= (double)this.top.get().intValue() && y <= (double)this.bottom.get().intValue();
        }

        public void render(class_4587 pose, int color) {
            class_332.method_25294((class_4587)pose, (int)this.left.get(), (int)this.top.get(), (int)this.right.get(), (int)this.bottom.get(), (int)color);
        }
    }
}

