/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import fr.frinn.custommachinery.impl.util.TextureSizeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class ButtonWidget
extends Widget {
    private class_2561 title = class_2585.field_24366;
    private boolean displayTitle = false;
    private Consumer<ButtonWidget> onPress = button -> {};
    private class_2960 texture = null;
    private int u = 0;
    private int v = 0;
    private int uWidth;
    private int vHeight;
    private class_2960 hoverTexture = null;
    private int hoverU = 0;
    private int hoverV = 0;
    private int hoverUWidth;
    private int hoverVHeight;
    private boolean background = true;
    private final List<class_2561> tooltips = new ArrayList<class_2561>();

    public ButtonWidget(Supplier<Integer> x, Supplier<Integer> y, int width, int height) {
        super(x, y, width, height);
        this.uWidth = width;
        this.vHeight = height;
        this.hoverUWidth = width;
        this.hoverVHeight = height;
    }

    public ButtonWidget title(class_2561 title, boolean display) {
        this.title = title;
        this.displayTitle = display;
        return this;
    }

    public ButtonWidget callback(Consumer<ButtonWidget> onPress) {
        this.onPress = onPress;
        return this;
    }

    public ButtonWidget texture(class_2960 texture) {
        this.texture = texture;
        return this;
    }

    public ButtonWidget texture(class_2960 texture, int u, int v) {
        this.u = u;
        this.v = v;
        return this.texture(texture);
    }

    public ButtonWidget texture(class_2960 texture, int u, int v, int uWidth, int vHeight) {
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        return this.texture(texture, u, v);
    }

    public ButtonWidget hoverTexture(class_2960 texture) {
        this.hoverTexture = texture;
        return this;
    }

    public ButtonWidget hoverTexture(class_2960 texture, int u, int v) {
        this.hoverU = u;
        this.hoverV = v;
        return this.hoverTexture(texture);
    }

    public ButtonWidget hoverTexture(class_2960 texture, int u, int v, int uWidth, int vHeight) {
        this.hoverUWidth = uWidth;
        this.hoverVHeight = vHeight;
        return this.hoverTexture(texture, u, v);
    }

    public ButtonWidget noBackground() {
        this.background = false;
        return this;
    }

    public ButtonWidget tooltip(class_2561 tooltip) {
        this.tooltips.add(tooltip);
        return this;
    }

    @Override
    public void render(class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.background) {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_339.field_22757);
            int i = this.method_25405(mouseX, mouseY) ? 2 : 1;
            class_339.method_25291((class_4587)pose, (int)this.getX(), (int)this.getY(), (int)0, (float)0.0f, (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
            class_339.method_25291((class_4587)pose, (int)(this.getX() + this.width / 2), (int)this.getY(), (int)0, (float)(200.0f - (float)this.width / 2.0f), (float)(46 + i * 20), (int)(this.width / 2), (int)this.height, (int)256, (int)256);
        }
        if (!this.method_25405(mouseX, mouseY)) {
            if (this.texture != null) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
                class_339.method_25293((class_4587)pose, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (float)this.u, (float)this.v, (int)this.uWidth, (int)this.vHeight, (int)TextureSizeHelper.getTextureWidth(this.texture), (int)TextureSizeHelper.getTextureHeight(this.texture));
            }
        } else if (this.hoverTexture != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.hoverTexture);
            class_339.method_25293((class_4587)pose, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (float)this.hoverU, (float)this.hoverV, (int)this.hoverUWidth, (int)this.hoverVHeight, (int)TextureSizeHelper.getTextureWidth(this.hoverTexture), (int)TextureSizeHelper.getTextureHeight(this.hoverTexture));
        } else if (this.texture != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            class_339.method_25293((class_4587)pose, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height, (float)this.u, (float)this.v, (int)this.uWidth, (int)this.vHeight, (int)TextureSizeHelper.getTextureWidth(this.texture), (int)TextureSizeHelper.getTextureHeight(this.texture));
        }
        if (this.displayTitle && this.title != null && this.title != class_2585.field_24366) {
            class_327 font = class_310.method_1551().field_1772;
            int x = this.getX() + (this.width - font.method_27525((class_5348)this.title)) / 2;
            int n = this.getY();
            Objects.requireNonNull(font);
            int y = n + (this.height - 9) / 2;
            font.method_30883(pose, this.title, (float)x, (float)y, 0);
        }
    }

    @Override
    public List<class_2561> getTooltips() {
        return this.tooltips;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && button == 0) {
            this.onPress.accept(this);
            this.playDownSound();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

