/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.client.screen.widget.custom.Widget;
import fr.frinn.custommachinery.common.util.Color3F;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public abstract class ListWidget<T, E extends Entry<T>>
extends Widget {
    private final List<E> entries = new ArrayList();
    private Consumer<T> callback = null;
    private int scrollbarOffsetX;
    private int scrollbarOffsetY;
    private int entryHeight = 20;
    @Nullable
    private E selected = null;
    private double scrollAmount = 0.0;
    private boolean scrolling = false;

    public ListWidget(Supplier<Integer> x, Supplier<Integer> y, int width, int height) {
        super(x, y, width, height);
        this.scrollbarOffsetX = width - 6;
        this.scrollbarOffsetY = 0;
    }

    public ListWidget<T, E> selectionCallback(Consumer<T> callback) {
        this.callback = callback;
        return this;
    }

    public ListWidget<T, E> scrollbarOffset(int x, int y) {
        this.scrollbarOffsetX = x;
        this.scrollbarOffsetY = y;
        return this;
    }

    public ListWidget<T, E> entryHeight(int height) {
        this.entryHeight = 20;
        return this;
    }

    public abstract void add(T var1);

    public void add(E entry) {
        this.entries.add(entry);
    }

    public void remove(T value) {
        this.entries.removeIf(entry -> entry.getValue() == value);
        if (this.selected == value) {
            this.selected = null;
        }
    }

    public void setSelected(E entry) {
        this.selected = entry;
        if (this.callback != null) {
            this.callback.accept(((Entry)entry).getValue());
        }
    }

    public void setSelected(T value) {
        for (Entry entry : this.entries) {
            if (entry.getValue() != value) continue;
            this.selected = entry;
        }
    }

    @Nullable
    public T getSelected() {
        return this.selected == null ? null : (T)((Entry)this.selected).getValue();
    }

    public int getMaxScroll() {
        return Math.max(0, this.entries.size() * this.entryHeight - this.height);
    }

    @Nullable
    protected final E getEntryAtPosition(double mouseX, double mouseY) {
        int x = this.getX();
        int y = class_3532.method_15357((double)(mouseY - (double)this.getY())) + (int)this.scrollAmount - 4;
        int index = y / this.entryHeight;
        return (E)(mouseX < (double)(this.getX() + this.scrollbarOffsetX) && mouseX >= (double)x && mouseX <= (double)(x + this.width) && index >= 0 && y >= 0 && index < this.entries.size() ? (Entry)this.entries.get(index) : null);
    }

    @Override
    public void render(class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        double s = class_310.method_1551().method_22683().method_4495();
        int screenHeight = class_310.method_1551().method_22683().method_4507() / (int)s;
        RenderSystem.enableScissor((int)(this.getX() * (int)s), (int)((screenHeight - this.getY() - this.height) * (int)s), (int)(this.width * (int)s), (int)(this.height * (int)s));
        this.renderEntries(pose, mouseX, mouseY, partialTicks);
        this.renderScrollbar(pose, this.getX() + this.scrollbarOffsetX, this.getY() + this.scrollbarOffsetY, 6, this.height, partialTicks);
        RenderSystem.disableScissor();
    }

    private void renderEntries(class_4587 pose, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.entries.size(); ++i) {
            int x = this.getX();
            int y = this.getY() + (int)this.scrollAmount + i * this.entryHeight;
            if ((y < this.getY() || y > this.getY() + this.height) && (y + this.entryHeight < this.getY() || y + this.entryHeight > this.getY() + this.height)) continue;
            Entry entry = (Entry)this.entries.get(i);
            if (this.selected == entry) {
                this.renderSelection(pose, x, y, partialTicks);
            }
            entry.render(pose, x, y, this.width, this.entryHeight, mouseX, mouseY, partialTicks);
        }
    }

    private void renderSelection(class_4587 pose, int x, int y, float partialTicks) {
        Color3F color = Color3F.of(100, 100, 100);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22918(pose.method_23760().method_23761(), (float)x, (float)(y + this.entryHeight), 0.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).method_1344();
        builder.method_22918(pose.method_23760().method_23761(), (float)(x + this.width), (float)(y + this.entryHeight), 0.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).method_1344();
        builder.method_22918(pose.method_23760().method_23761(), (float)(x + this.width), (float)y, 0.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).method_1344();
        builder.method_22918(pose.method_23760().method_23761(), (float)x, (float)y, 0.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), 1.0f).method_1344();
        class_289.method_1348().method_1350();
    }

    private void renderScrollbar(class_4587 pose, int x, int y, int width, int height, float partialTicks) {
        int maxScroll = this.getMaxScroll();
        if (maxScroll <= 0) {
            return;
        }
        RenderSystem.disableTexture();
        RenderSystem.setShader(class_757::method_34540);
        int barTop = height * height / (this.entries.size() * this.entryHeight);
        barTop = class_3532.method_15340((int)barTop, (int)32, (int)(height - 8));
        int barBottom = (int)this.scrollAmount * (height - barTop) / maxScroll + y;
        if (barBottom < y) {
            barBottom = y;
        }
        class_289 tesselator = class_289.method_1348();
        class_287 builder = tesselator.method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        builder.method_22912((double)x, (double)(y + height), 0.0).method_1336(0, 0, 0, 255).method_1344();
        builder.method_22912((double)(x + width), (double)(y + height), 0.0).method_1336(0, 0, 0, 255).method_1344();
        builder.method_22912((double)(x + width), (double)y, 0.0).method_1336(0, 0, 0, 255).method_1344();
        builder.method_22912((double)x, (double)y, 0.0).method_1336(0, 0, 0, 255).method_1344();
        builder.method_22912((double)x, (double)(barBottom + barTop), 0.0).method_1336(128, 128, 128, 255).method_1344();
        builder.method_22912((double)(x + width), (double)(barBottom + barTop), 0.0).method_1336(128, 128, 128, 255).method_1344();
        builder.method_22912((double)(x + width), (double)barBottom, 0.0).method_1336(128, 128, 128, 255).method_1344();
        builder.method_22912((double)x, (double)barBottom, 0.0).method_1336(128, 128, 128, 255).method_1344();
        builder.method_22912((double)x, (double)(barBottom + barTop - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        builder.method_22912((double)(x + width - 1), (double)(barBottom + barTop - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
        builder.method_22912((double)(x + width - 1), (double)barBottom, 0.0).method_1336(192, 192, 192, 255).method_1344();
        builder.method_22912((double)x, (double)barBottom, 0.0).method_1336(192, 192, 192, 255).method_1344();
        tesselator.method_1350();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl = this.scrolling = button == 0 && mouseX >= (double)(this.getX() + this.scrollbarOffsetX) && mouseX <= (double)(this.getX() + this.scrollbarOffsetX + 6);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        E entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            this.setSelected((T)entry);
        }
        return this.scrolling;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.getY()) {
                this.scrollAmount = 0.0;
            } else if (mouseY > (double)(this.getY() + this.height)) {
                this.scrollAmount = this.getMaxScroll();
            } else {
                double d = Math.max(1, this.getMaxScroll());
                int j = class_3532.method_15340((int)(this.height * this.height / (this.entries.size() * this.entryHeight)), (int)32, (int)(this.height - 8));
                double e = Math.max(1.0, d / (double)(this.height - j));
                this.scrollAmount += dragY * e;
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        this.scrollAmount -= delta * (double)this.entryHeight / 2.0;
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264) {
            this.scrollAmount -= 20.0;
            return true;
        }
        if (keyCode == 265) {
            this.scrollAmount += 20.0;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static abstract class Entry<T> {
        private final T value;

        public Entry(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public abstract void render(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);
    }
}

