/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.LongSyncable;
import fr.frinn.custommachinery.common.network.syncable.SideConfigSyncable;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.transfer.ICommonEnergyHandler;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import fr.frinn.custommachinery.impl.integration.jei.Energy;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import org.apache.logging.log4j.util.TriConsumer;

public class EnergyMachineComponent
extends AbstractMachineComponent
implements ITickableComponent,
ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent {
    private long energy = 0L;
    private final long capacity;
    private final long maxInput;
    private final long maxOutput;
    private final ICommonEnergyHandler handler;
    private final SideConfig config;
    private long actualTick;

    public EnergyMachineComponent(IMachineComponentManager manager, long capacity, long maxInput, long maxOutput, SideConfig.Template configTemplate) {
        super(manager, ComponentIOMode.BOTH);
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.handler = PlatformHelper.createEnergyHandler(this);
        this.config = configTemplate.build(this);
        this.config.setCallback((TriConsumer<RelativeSide, SideMode, SideMode>)((TriConsumer)this.handler::configChanged));
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public long getMaxOutput() {
        return this.maxOutput;
    }

    public double getFillPercent() {
        return (double)this.energy / (double)this.capacity;
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setEnergy(long energy) {
        this.energy = energy;
        this.getManager().markDirty();
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (this.getMaxInput() <= 0L) {
            return 0L;
        }
        long energyReceived = Math.min(this.getCapacity() - this.getEnergy(), Math.min(this.getMaxInput(), maxReceive));
        if (!simulate && energyReceived > 0L) {
            this.setEnergy(this.getEnergy() + energyReceived);
            this.getManager().markDirty();
        }
        return energyReceived;
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (this.getMaxOutput() <= 0L) {
            return 0L;
        }
        long energyExtracted = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), maxExtract));
        if (!simulate && energyExtracted > 0L) {
            this.setEnergy(this.getEnergy() - energyExtracted);
            this.getManager().markDirty();
        }
        return energyExtracted;
    }

    public ICommonEnergyHandler getEnergyHandler() {
        return this.handler;
    }

    @Override
    public SideConfig getConfig() {
        return this.config;
    }

    @Override
    public String getId() {
        return "energy";
    }

    public MachineComponentType<EnergyMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get());
    }

    @Override
    public void serverTick() {
        this.handler.tick();
    }

    @Override
    public void onRemoved() {
        this.handler.invalidate();
    }

    @Override
    public void serialize(class_2487 nbt) {
        nbt.method_10544("energy", this.energy);
        nbt.method_10566("config", this.config.serialize());
    }

    @Override
    public void deserialize(class_2487 nbt) {
        if (nbt.method_10573("energy", 4)) {
            this.energy = Math.min(nbt.method_10537("energy"), this.capacity);
        }
        if (nbt.method_10545("config")) {
            this.config.deserialize(nbt.method_10580("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(LongSyncable.create(() -> this.energy, energy -> {
            this.energy = energy;
        }));
        container.accept(SideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.energy / (double)this.capacity));
    }

    public int receiveRecipeEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(Utils.toInt(this.capacity - this.energy), maxReceive);
        if (!simulate) {
            this.energy += (long)energyReceived;
            this.getManager().markDirty();
        }
        return energyReceived;
    }

    public int extractRecipeEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(Utils.toInt(this.energy), maxExtract);
        if (!simulate) {
            this.energy -= (long)energyExtracted;
            this.getManager().markDirty();
        }
        return energyExtracted;
    }

    public static class Template
    implements IMachineComponentTemplate<EnergyMachineComponent> {
        public static final Codec<Template> CODEC = RecordCodecBuilder.create(templateInstance -> templateInstance.group((App)Codecs.longRange(1L, Long.MAX_VALUE).fieldOf("capacity").forGetter(template -> template.capacity), (App)CodecLogger.loggedOptional(Codecs.longRange(0L, Long.MAX_VALUE), "maxInput").forGetter(template -> Optional.of(template.maxInput)), (App)CodecLogger.loggedOptional(Codecs.longRange(0L, Long.MAX_VALUE), "maxOutput").forGetter(template -> Optional.of(template.maxOutput)), (App)CodecLogger.loggedOptional(SideConfig.Template.CODEC, "config", SideConfig.Template.DEFAULT_ALL_INPUT).forGetter(template -> template.config)).apply((Applicative)templateInstance, (capacity, maxInput, maxOutput, config) -> new Template((long)capacity, maxInput.orElse(capacity), maxOutput.orElse(capacity), (SideConfig.Template)config)));
        private final long capacity;
        private final long maxInput;
        private final long maxOutput;
        private final SideConfig.Template config;

        public Template(long capacity, long maxInput, long maxOutput, SideConfig.Template config) {
            this.capacity = capacity;
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
            this.config = config;
        }

        @Override
        public MachineComponentType<EnergyMachineComponent> getType() {
            return (MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get());
        }

        @Override
        public String getId() {
            return "";
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return ingredient instanceof Energy;
        }

        @Override
        public EnergyMachineComponent build(IMachineComponentManager manager) {
            return new EnergyMachineComponent(manager, this.capacity, this.maxInput, this.maxOutput, this.config);
        }
    }
}

