/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import dev.architectury.registry.fuel.FuelRegistry;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.variant.item.FuelItemComponentVariant;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class FuelMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ITickableComponent,
ISyncableStuff {
    private int fuel;
    private int maxFuel;

    public FuelMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<FuelMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.FUEL_MACHINE_COMPONENT.get());
    }

    @Override
    public void serialize(class_2487 nbt) {
        nbt.method_10569("fuel", this.fuel);
        nbt.method_10569("maxFuel", this.maxFuel);
    }

    @Override
    public void deserialize(class_2487 nbt) {
        if (nbt.method_10573("fuel", 3)) {
            this.fuel = nbt.method_10550("fuel");
        }
        if (nbt.method_10573("maxFuel", 3)) {
            this.maxFuel = nbt.method_10550("maxFuel");
        }
    }

    @Override
    public void serverTick() {
        if (this.fuel > 0 && this.getManager().getTile().getStatus() != MachineStatus.RUNNING) {
            --this.fuel;
            this.getManager().markDirty();
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(IntegerSyncable.create(() -> this.fuel, fuel -> {
            this.fuel = fuel;
        }));
        container.accept(IntegerSyncable.create(() -> this.maxFuel, maxFuel -> {
            this.maxFuel = maxFuel;
        }));
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getMaxFuel() {
        return this.maxFuel;
    }

    public void addFuel(int fuel) {
        this.fuel += fuel;
        this.maxFuel = fuel;
        this.getManager().getTile().method_5431();
    }

    public boolean burn(int amount) {
        if (this.fuel >= amount) {
            this.fuel -= amount;
            this.getManager().markDirty();
            return true;
        }
        this.tryBurnItem();
        if (this.fuel >= amount) {
            this.fuel -= amount;
            this.getManager().markDirty();
            return true;
        }
        return false;
    }

    public boolean canStartRecipe(int amount) {
        if (this.fuel >= amount) {
            return true;
        }
        return this.getManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponents().stream().filter(component -> component.getVariant() == FuelItemComponentVariant.INSTANCE && FuelRegistry.get((class_1799)component.getItemStack()) > 0).findFirst()).isPresent();
    }

    private void tryBurnItem() {
        this.getManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponents().stream().filter(component -> component.getVariant() == FuelItemComponentVariant.INSTANCE && !component.getItemStack().method_7960()).findFirst()).ifPresent(component -> {
            int fuel = FuelRegistry.get((class_1799)component.getItemStack());
            this.addFuel(fuel);
            component.extract(1, false);
        });
    }
}

