/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.IVariableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.variant.IComponentVariant;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.variant.item.DefaultItemComponentVariant;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.ItemStackSyncable;
import fr.frinn.custommachinery.common.network.syncable.SideConfigSyncable;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.variant.ItemComponentVariant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class ItemMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
IVariableComponent<ItemComponentVariant>,
ISideConfigComponent {
    private final String id;
    private final int capacity;
    private final int maxInput;
    private final int maxOutput;
    private final List<IIngredient<class_1792>> filter;
    private final boolean whitelist;
    private class_1799 stack = class_1799.field_8037;
    private final ItemComponentVariant variant;
    private final SideConfig config;

    public ItemMachineComponent(IMachineComponentManager manager, ComponentIOMode mode, String id, int capacity, int maxInput, int maxOutput, List<IIngredient<class_1792>> filter, boolean whitelist, ItemComponentVariant variant, SideConfig.Template configTemplate) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.filter = filter;
        this.whitelist = whitelist;
        this.variant = variant;
        this.config = configTemplate.build(this);
    }

    public MachineComponentType<ItemMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SideConfig getConfig() {
        return this.config;
    }

    @Override
    public ItemComponentVariant getVariant() {
        return this.variant;
    }

    public boolean isItemValid(class_1799 stack) {
        return this.filter.stream().anyMatch(ingredient -> ingredient.test(stack.method_7909())) == this.whitelist && this.variant.canAccept(this.getManager(), stack);
    }

    public int getRemainingSpace() {
        if (!this.stack.method_7960()) {
            return this.capacity - this.stack.method_7947();
        }
        return this.capacity;
    }

    public class_1799 getItemStack() {
        return this.stack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int insert(class_1792 item, int amount, @Nullable class_2487 nbt, boolean simulate) {
        return this.insert(item, amount, nbt, simulate, false);
    }

    public int insert(class_1792 item, int amount, @Nullable class_2487 nbt, boolean simulate, boolean byPassLimit) {
        if (amount <= 0 || item == class_1802.field_8162 || !this.isItemValid(Utils.makeItemStack(item, amount, nbt))) {
            return 0;
        }
        if (!byPassLimit) {
            amount = Math.min(amount, this.maxInput);
        }
        amount = Math.min(amount, this.capacity - this.stack.method_7947());
        if (this.stack.method_7960()) {
            if (!simulate) {
                this.stack = Utils.makeItemStack(item, amount, nbt);
                this.getManager().markDirty();
                this.getManager().getTile().getUpgradeManager().markDirty();
            }
            return amount;
        }
        if (this.stack.method_7909() == item && (this.stack.method_7969() == null || this.stack.method_7969().equals((Object)nbt))) {
            amount = Math.min(this.getRemainingSpace(), amount);
            if (!simulate) {
                this.stack.method_7933(amount);
                this.getManager().markDirty();
                this.getManager().getTile().getUpgradeManager().markDirty();
            }
            return amount;
        }
        return 0;
    }

    public class_1799 extract(int amount, boolean simulate) {
        return this.extract(amount, simulate, false);
    }

    public class_1799 extract(int amount, boolean simulate, boolean byPassLimit) {
        if (amount <= 0 || this.stack.method_7960() || !this.variant.canOutput(this.getManager())) {
            return class_1799.field_8037;
        }
        if (!byPassLimit) {
            amount = Math.min(amount, this.maxOutput);
        }
        amount = Math.min(amount, this.stack.method_7947());
        class_1799 removed = Utils.makeItemStack(this.stack.method_7909(), amount, this.stack.method_7969());
        if (!simulate) {
            this.stack.method_7934(amount);
            this.getManager().markDirty();
            this.getManager().getTile().getUpgradeManager().markDirty();
        }
        return removed;
    }

    public void setItemStack(class_1799 stack) {
        this.stack = stack;
        this.getManager().markDirty();
        this.getManager().getTile().getUpgradeManager().markDirty();
    }

    @Override
    public void serialize(class_2487 nbt) {
        if (!this.stack.method_7960()) {
            this.stack.method_7953(nbt);
        }
        nbt.method_10566("config", this.config.serialize());
    }

    @Override
    public void deserialize(class_2487 nbt) {
        this.stack = class_1799.method_7915((class_2487)nbt);
        if (nbt.method_10545("config")) {
            this.config.deserialize(nbt.method_10580("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(ItemStackSyncable.create(() -> this.stack, stack -> {
            this.stack = stack;
        }));
        container.accept(SideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return class_1703.method_7618((class_1263)new class_1277(new class_1799[]{this.stack}));
    }

    public static class Template
    implements IMachineComponentTemplate<ItemMachineComponent> {
        public static final Codec<Template> CODEC = RecordCodecBuilder.create(itemMachineComponentTemplate -> itemMachineComponentTemplate.group((App)Codec.STRING.fieldOf("id").forGetter(template -> template.id), (App)CodecLogger.loggedOptional(Codecs.COMPONENT_MODE_CODEC, "mode", ComponentIOMode.BOTH).forGetter(template -> template.mode), (App)CodecLogger.loggedOptional(Codec.INT, "capacity", 64).forGetter(template -> template.capacity), (App)CodecLogger.loggedOptional(Codec.INT, "max_input").forGetter(template -> Optional.of(template.maxInput)), (App)CodecLogger.loggedOptional(Codec.INT, "max_output").forGetter(template -> Optional.of(template.maxOutput)), (App)CodecLogger.loggedOptional(Codecs.list(IIngredient.ITEM), "filter", Collections.emptyList()).forGetter(template -> template.filter), (App)CodecLogger.loggedOptional(Codec.BOOL, "whitelist", false).forGetter(template -> template.whitelist), (App)IComponentVariant.codec(Registration.ITEM_MACHINE_COMPONENT).orElse((Object)DefaultItemComponentVariant.INSTANCE).forGetter(template -> template.variant), (App)CodecLogger.loggedOptional(SideConfig.Template.CODEC, "config").forGetter(template -> Optional.of(template.config))).apply((Applicative)itemMachineComponentTemplate, (id, mode, capacity, maxInput, maxOutput, filter, whitelist, variant, config) -> new Template((String)id, (ComponentIOMode)((Object)((Object)mode)), (int)capacity, maxInput.orElse(capacity), maxOutput.orElse(capacity), (List<IIngredient<class_1792>>)filter, (boolean)whitelist, (ItemComponentVariant)variant, config.orElse(mode.getBaseConfig()))));
        private final ComponentIOMode mode;
        private final String id;
        private final int capacity;
        private final int maxInput;
        private final int maxOutput;
        private final List<IIngredient<class_1792>> filter;
        private final boolean whitelist;
        private final ItemComponentVariant variant;
        private final SideConfig.Template config;

        public Template(String id, ComponentIOMode mode, int capacity, int maxInput, int maxOutput, List<IIngredient<class_1792>> filter, boolean whitelist, ItemComponentVariant variant, SideConfig.Template config) {
            this.mode = mode;
            this.id = id;
            this.capacity = capacity;
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
            this.filter = filter;
            this.whitelist = whitelist;
            this.variant = variant;
            this.config = config;
        }

        public ItemComponentVariant getVariant() {
            return this.variant;
        }

        @Override
        public MachineComponentType<ItemMachineComponent> getType() {
            return (MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get());
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof class_1799) {
                class_1799 stack = (class_1799)ingredient;
                return this.filter.stream().flatMap(i -> i.getAll().stream()).anyMatch(i -> i == stack.method_7909()) == this.whitelist && this.variant.canAccept(manager, stack);
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof class_1799) {
                        class_1799 stack = (class_1799)object;
                        return this.filter.stream().flatMap(i -> i.getAll().stream()).anyMatch(i -> i == stack.method_7909()) == this.whitelist && this.variant.canAccept(manager, stack);
                    }
                    return false;
                });
            }
            return false;
        }

        @Override
        public ItemMachineComponent build(IMachineComponentManager manager) {
            return new ItemMachineComponent(manager, this.mode, this.id, this.capacity, this.maxInput, this.maxOutput, this.filter, this.whitelist, this.variant, this.config);
        }
    }
}

