/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.handler.IComponentHandler;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.server.MinecraftServer;

public class MachineComponentManager
implements IMachineComponentManager {
    private final CustomMachineTile tile;
    private final Map<MachineComponentType<?>, IMachineComponent> components;
    private final List<ISerializableComponent> serializableComponents;
    private final List<ITickableComponent> tickableComponents;
    private final List<ISyncableStuff> syncableComponents;
    private final List<IComparatorInputComponent> comparatorInputComponents;
    private final Map<String, ISideConfigComponent> configComponents;

    public MachineComponentManager(List<IMachineComponentTemplate<? extends IMachineComponent>> templates, CustomMachineTile tile) {
        this.tile = tile;
        LinkedHashMap components = new LinkedHashMap();
        LinkedHashMap<MachineComponentType, List> handlers = new LinkedHashMap<MachineComponentType, List>();
        templates.forEach(template -> {
            Object component = template.build(this);
            if (component.getType().isSingle()) {
                components.put(component.getType(), component);
            } else {
                handlers.computeIfAbsent(component.getType(), type -> new ArrayList()).add(component);
            }
        });
        handlers.forEach((type, list) -> components.put(type, type.getHandler(this, Collections.unmodifiableList(list))));
        StreamSupport.stream(Registration.MACHINE_COMPONENT_TYPE_REGISTRY.spliterator(), false).filter(type -> type.isDefaultComponent() && components.values().stream().noneMatch(component -> component.getType() == type)).forEach(type -> components.put(type, (IMachineComponent)type.getDefaultComponentBuilder().apply(this)));
        this.components = Collections.unmodifiableMap(components);
        this.serializableComponents = this.components.values().stream().filter(component -> component instanceof ISerializableComponent).map(component -> (ISerializableComponent)component).toList();
        this.tickableComponents = this.components.values().stream().filter(component -> component instanceof ITickableComponent).map(component -> (ITickableComponent)component).toList();
        this.syncableComponents = this.components.values().stream().filter(component -> component instanceof ISyncableStuff).map(component -> (ISyncableStuff)((Object)component)).toList();
        this.comparatorInputComponents = this.components.values().stream().filter(component -> component instanceof IComparatorInputComponent).map(component -> (IComparatorInputComponent)component).toList();
        this.configComponents = this.components.values().stream().flatMap(component -> {
            if (component instanceof IComponentHandler) {
                IComponentHandler handler = (IComponentHandler)component;
                return handler.getComponents().stream();
            }
            return Stream.of(component);
        }).filter(component -> component instanceof ISideConfigComponent).map(component -> (ISideConfigComponent)component).collect(Collectors.toUnmodifiableMap(component -> component.getType().getId().toString() + ":" + component.getId(), Function.identity()));
    }

    @Override
    public Map<MachineComponentType<?>, IMachineComponent> getComponents() {
        return this.components;
    }

    @Override
    public List<ISerializableComponent> getSerializableComponents() {
        return this.serializableComponents;
    }

    @Override
    public List<ITickableComponent> getTickableComponents() {
        return this.tickableComponents;
    }

    @Override
    public List<ISyncableStuff> getSyncableComponents() {
        return this.syncableComponents;
    }

    @Override
    public List<IComparatorInputComponent> getComparatorInputComponents() {
        return this.comparatorInputComponents;
    }

    @Override
    public <T extends IMachineComponent> Optional<T> getComponent(MachineComponentType<T> type) {
        return Optional.ofNullable(this.components.get(type));
    }

    @Override
    public <T extends IMachineComponent> Optional<IComponentHandler<T>> getComponentHandler(MachineComponentType<T> type) {
        return this.getComponent(type).filter(component -> component instanceof IComponentHandler).map(component -> (IComponentHandler)component);
    }

    @Override
    public boolean hasComponent(MachineComponentType<?> type) {
        return this.components.get(type) != null;
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getSyncableComponents().forEach(syncableComponent -> syncableComponent.getStuffToSync(container));
    }

    public Optional<ISideConfigComponent> getConfigComponentById(String id) {
        return Optional.ofNullable(this.configComponents.get(id));
    }

    @Override
    public CustomMachineTile getTile() {
        return this.tile;
    }

    @Override
    public class_1937 getLevel() {
        return this.getTile().method_10997();
    }

    @Override
    public MinecraftServer getServer() {
        return this.getLevel().method_8503();
    }

    public void serverTick() {
        this.getTickableComponents().forEach(ITickableComponent::serverTick);
    }

    public void clientTick() {
        this.getTickableComponents().forEach(ITickableComponent::clientTick);
    }

    @Override
    public void markDirty() {
        this.getTile().method_5431();
        this.getTile().getProcessor().setMachineInventoryChanged();
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        this.getSerializableComponents().forEach(component -> component.serialize(nbt));
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.getSerializableComponents().forEach(component -> component.deserialize(nbt));
    }
}

