/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.handler;

import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.variant.ITickableComponentVariant;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.transfer.ICommonItemHandler;
import fr.frinn.custommachinery.impl.component.AbstractComponentHandler;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class ItemComponentHandler
extends AbstractComponentHandler<ItemMachineComponent>
implements ISerializableComponent,
ITickableComponent,
ISyncableStuff {
    private final Random rand = new Random();
    private final List<ItemMachineComponent> tickableVariants;
    private final ICommonItemHandler handler = PlatformHelper.createItemHandler(this);
    private final List<ItemMachineComponent> inputs = new ArrayList<ItemMachineComponent>();
    private final List<ItemMachineComponent> outputs = new ArrayList<ItemMachineComponent>();

    public ItemComponentHandler(IMachineComponentManager manager, List<ItemMachineComponent> components) {
        super(manager, components);
        components.forEach(component -> {
            component.getConfig().setCallback((TriConsumer<RelativeSide, SideMode, SideMode>)((TriConsumer)this.handler::configChanged));
            if (component.getMode().isInput()) {
                this.inputs.add((ItemMachineComponent)component);
            }
            if (component.getMode().isOutput()) {
                this.outputs.add((ItemMachineComponent)component);
            }
        });
        this.tickableVariants = components.stream().filter(component -> component.getVariant() instanceof ITickableComponentVariant).toList();
    }

    public ICommonItemHandler getCommonHandler() {
        return this.handler;
    }

    public MachineComponentType<ItemMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get());
    }

    @Override
    public void onRemoved() {
        this.handler.invalidate();
    }

    @Override
    public Optional<ItemMachineComponent> getComponentForID(String id) {
        return this.getComponents().stream().filter(component -> component.getId().equals(id)).findFirst();
    }

    @Override
    public void serialize(class_2487 nbt) {
        class_2499 components = new class_2499();
        this.getComponents().forEach(component -> {
            class_2487 componentNBT = new class_2487();
            component.serialize(componentNBT);
            componentNBT.method_10582("slotID", component.getId());
            components.add((Object)componentNBT);
        });
        nbt.method_10566("items", (class_2520)components);
    }

    @Override
    public void deserialize(class_2487 nbt) {
        if (nbt.method_10573("items", 9)) {
            class_2499 components = nbt.method_10554("items", 10);
            components.forEach(inbt -> {
                class_2487 componentNBT;
                if (inbt instanceof class_2487 && (componentNBT = (class_2487)inbt).method_10573("slotID", 8)) {
                    this.getComponents().stream().filter(component -> component.getId().equals(componentNBT.method_10558("slotID"))).findFirst().ifPresent(component -> component.deserialize(componentNBT));
                }
            });
        }
    }

    @Override
    public void serverTick() {
        this.handler.tick();
        this.tickableVariants.forEach(component -> ((ITickableComponentVariant)((Object)component.getVariant())).tick(component));
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getComponents().forEach(component -> component.getStuffToSync(container));
    }

    public int getItemAmount(String slot, class_1792 item, @Nullable class_2487 nbt) {
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getItemStack().method_7969() != null && Utils.testNBT(component.getItemStack().method_7969(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> component.getItemStack().method_7909() == item && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().method_7947()).sum();
    }

    public int getDurabilityAmount(String slot, class_1792 item, @Nullable class_2487 nbt) {
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getItemStack().method_7969() != null && Utils.testNBT(component.getItemStack().method_7969(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> component.getItemStack().method_7909() == item && component.getItemStack().method_7963() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().method_7936() - component.getItemStack().method_7919()).sum();
    }

    public int getSpaceForItem(String slot, class_1792 item, @Nullable class_2487 nbt) {
        int maxStackSize = Utils.makeItemStack(item, 1, nbt).method_7914();
        return this.outputs.stream().filter(component -> this.canPlaceOutput((ItemMachineComponent)component, slot, item, nbt)).mapToInt(component -> {
            if (component.getItemStack().method_7960()) {
                return Math.min(component.getCapacity(), maxStackSize);
            }
            return Math.min(component.getCapacity() - component.getItemStack().method_7947(), maxStackSize - component.getItemStack().method_7947());
        }).sum();
    }

    private boolean canPlaceOutput(ItemMachineComponent component, @Nullable String slot, class_1792 item, @Nullable class_2487 nbt) {
        class_1799 stack = Utils.makeItemStack(item, 1, nbt);
        if (slot != null && !slot.isEmpty() && !component.getId().equals(slot)) {
            return false;
        }
        if (!component.isItemValid(stack)) {
            return false;
        }
        if (component.getItemStack().method_7960()) {
            return true;
        }
        if (component.getItemStack().method_7909() != item) {
            return false;
        }
        if (component.getItemStack().method_7947() >= Math.min(stack.method_7914(), component.getCapacity())) {
            return false;
        }
        return class_1799.method_31577((class_1799)component.getItemStack(), (class_1799)stack);
    }

    public int getSpaceForDurability(String slot, class_1792 item, @Nullable class_2487 nbt) {
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getItemStack().method_7969() != null && Utils.testNBT(component.getItemStack().method_7969(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> component.getItemStack().method_7909() == item && component.getItemStack().method_7963() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().method_7919()).sum();
    }

    public void removeFromInputs(String slot, class_1792 item, int amount, @Nullable class_2487 nbt) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getItemStack().method_7969() != null && Utils.testNBT(component.getItemStack().method_7969(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> component.getItemStack().method_7909() == item && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxExtract = Math.min(component.getItemStack().method_7947(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.extract(maxExtract, false, true);
        });
        this.getManager().markDirty();
    }

    public void removeDurability(String slot, class_1792 item, int amount, @Nullable class_2487 nbt, boolean canBreak) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getItemStack().method_7969() != null && Utils.testNBT(component.getItemStack().method_7969(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> component.getItemStack().method_7909() == item && component.getItemStack().method_7963() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxRemove = Math.min(component.getItemStack().method_7936() - component.getItemStack().method_7919(), toRemove.get());
            toRemove.addAndGet(-maxRemove);
            class_1799 stack = component.getItemStack();
            if (stack.method_7970(maxRemove, this.rand, null) && canBreak) {
                stack.method_7934(1);
                stack.method_7974(0);
            }
        });
        this.getManager().markDirty();
    }

    public void addToOutputs(String slot, class_1792 item, int amount, @Nullable class_2487 nbt) {
        AtomicInteger toAdd = new AtomicInteger(amount);
        this.outputs.stream().filter(component -> this.canPlaceOutput((ItemMachineComponent)component, slot, item, nbt)).forEach(component -> {
            int maxInsert = Math.min(component.insert(item, amount, nbt, true, true), toAdd.get());
            toAdd.addAndGet(-maxInsert);
            component.insert(item, maxInsert, nbt, false, true);
        });
        this.getManager().markDirty();
    }

    public void repairItem(String slot, class_1792 item, int amount, @Nullable class_2487 nbt) {
        AtomicInteger toRepair = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getItemStack().method_7969() != null && Utils.testNBT(component.getItemStack().method_7969(), nbt);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> component.getItemStack().method_7909() == item && component.getItemStack().method_7963() && nbtPredicate.test((ItemMachineComponent)component) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxRepair = Math.min(component.getItemStack().method_7919(), toRepair.get());
            toRepair.addAndGet(-maxRepair);
            component.getItemStack().method_7974(component.getItemStack().method_7919() - maxRepair);
        });
        this.getManager().markDirty();
    }
}

