/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class CustomCraftRecipe
implements class_1860<class_1263>,
IMachineRecipe {
    public static final List<RequirementType<?>> FORBIDDEN_REQUIREMENTS = Lists.newArrayList((Object[])new RequirementType[]{(RequirementType)((Object)Registration.ENERGY_PER_TICK_REQUIREMENT.get()), (RequirementType)((Object)Registration.FLUID_PER_TICK_REQUIREMENT.get())});
    private final class_2960 id;
    private final class_2960 machine;
    private final class_1799 output;
    private final List<IRequirement<?>> requirements;
    private final List<IRequirement<?>> jeiRequirements;
    private final int priority;
    private final int jeiPriority;

    public CustomCraftRecipe(class_2960 id, class_2960 machine, class_1799 output, List<IRequirement<?>> requirements, List<IRequirement<?>> jeiRequirements, int priority, int jeiPriority) {
        this.id = id;
        this.machine = machine;
        this.output = output;
        this.requirements = this.validateRequirements(requirements);
        this.jeiRequirements = this.validateRequirements(jeiRequirements);
        this.priority = priority;
        this.jeiPriority = jeiPriority;
    }

    @Override
    public class_2960 getMachineId() {
        return this.machine;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    private List<IRequirement<?>> validateRequirements(List<IRequirement<?>> requirements) {
        return requirements.stream().filter(requirement -> {
            if (!FORBIDDEN_REQUIREMENTS.contains(requirement.getType()) && requirement.getMode() == RequirementIOMode.INPUT) {
                return true;
            }
            ICustomMachineryAPI.INSTANCE.logger().error("Invalid requirement: {}", (Object)IRequirement.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, requirement).result().map(JsonElement::toString).orElse(((Object)requirement.getType()).toString()));
            return false;
        }).toList();
    }

    @Override
    public class_2960 getRecipeId() {
        return this.id;
    }

    @Override
    public int getRecipeTime() {
        return 0;
    }

    @Override
    public List<IRequirement<?>> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<IRequirement<?>> getJeiRequirements() {
        return this.jeiRequirements;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getJeiPriority() {
        return this.jeiPriority;
    }

    @Override
    public boolean shouldResetOnError() {
        return false;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        return false;
    }

    public class_1799 method_8116(class_1263 container) {
        return null;
    }

    public boolean method_8113(int i, int j) {
        return false;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return (class_1865)Registration.CUSTOM_CRAFT_RECIPE_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)Registration.CUSTOM_CRAFT_RECIPE.get();
    }
}

