/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.impl.codec.CodecLogger;
import fr.frinn.custommachinery.impl.crafting.AbstractRecipeBuilder;
import java.util.Collections;
import net.minecraft.class_2960;

public class CustomMachineRecipeBuilder
extends AbstractRecipeBuilder<CustomMachineRecipe> {
    public static final Codec<CustomMachineRecipeBuilder> CODEC = RecordCodecBuilder.create(recipeBuilderInstance -> recipeBuilderInstance.group((App)class_2960.field_25139.fieldOf("machine").forGetter(AbstractRecipeBuilder::getMachine), (App)Codec.INT.fieldOf("time").forGetter(builder -> builder.time), (App)CodecLogger.loggedOptional(Codecs.list(IRequirement.CODEC), "requirements", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getRequirements), (App)CodecLogger.loggedOptional(Codecs.list(IRequirement.CODEC), "jei", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getJeiRequirements), (App)CodecLogger.loggedOptional(Codec.INT, "priority", 0).forGetter(AbstractRecipeBuilder::getPriority), (App)CodecLogger.loggedOptional(Codec.INT, "jeiPriority", 0).forGetter(AbstractRecipeBuilder::getJeiPriority), (App)CodecLogger.loggedOptional(Codec.BOOL, "error", true).forGetter(builder -> !builder.resetOnError)).apply((Applicative)recipeBuilderInstance, (machine, time, requirements, jeiRequirements, priority, jeiPriority, error) -> {
        CustomMachineRecipeBuilder builder = new CustomMachineRecipeBuilder((class_2960)machine, (int)time);
        requirements.forEach(builder::withRequirement);
        jeiRequirements.forEach(builder::withJeiRequirement);
        builder.withPriority((int)priority);
        builder.withJeiPriority((int)jeiPriority);
        if (!error.booleanValue()) {
            builder.setResetOnError();
        }
        return builder;
    }));
    private final int time;
    private boolean resetOnError = false;

    public CustomMachineRecipeBuilder(class_2960 machine, int time) {
        super(machine);
        this.time = time;
    }

    public CustomMachineRecipeBuilder(CustomMachineRecipe recipe) {
        super(recipe);
        this.time = recipe.getRecipeTime();
        this.resetOnError = recipe.shouldResetOnError();
    }

    public CustomMachineRecipeBuilder setResetOnError() {
        this.resetOnError = true;
        return this;
    }

    @Override
    public CustomMachineRecipe build(class_2960 id) {
        return new CustomMachineRecipe(id, this.getMachine(), this.time, this.getRequirements(), this.getJeiRequirements(), this.getPriority(), this.getJeiPriority(), this.resetOnError);
    }

    public String toString() {
        return "CustomMachineRecipe{machine=" + this.getMachine() + ", time=" + this.time + ", requirements=" + this.getRequirements().stream().map(requirement -> requirement.getType().getId()).toList() + ", jeiRequirements=" + this.getJeiRequirements().stream().map(requirement -> requirement.getType().getId()).toList() + ", priority=" + this.getPriority() + ", jeiPriority=" + this.getJeiPriority() + ", resetOnError=" + this.resetOnError + "}";
    }
}

