/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.crafting.CraftingContext;
import fr.frinn.custommachinery.common.crafting.RecipeChecker;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_3956;

public class MachineRecipeFinder {
    private final MachineTile tile;
    private List<RecipeChecker<CustomMachineRecipe>> recipes;
    private List<RecipeChecker<CustomMachineRecipe>> okToCheck;
    private boolean inventoryChanged = true;
    private int recipeCheckCooldown;

    public MachineRecipeFinder(MachineTile tile) {
        this.tile = tile;
    }

    public void init() {
        if (this.tile.method_10997() == null) {
            throw new IllegalStateException("Broken machine " + this.tile.getMachine().getId() + "doesn't have a world");
        }
        this.recipes = this.tile.method_10997().method_8433().method_30027((class_3956)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().filter(recipe -> recipe.getMachineId().equals((Object)this.tile.getMachine().getId())).sorted(Comparators.RECIPE_PRIORITY_COMPARATOR.reversed()).map(CustomMachineRecipe::checker).toList();
        this.okToCheck = new ArrayList<RecipeChecker<CustomMachineRecipe>>();
        this.recipeCheckCooldown = this.tile.method_10997().field_9229.nextInt(20);
    }

    public Optional<CustomMachineRecipe> findRecipe(CraftingContext.Mutable context, boolean immediately) {
        if (this.tile.method_10997() == null) {
            return Optional.empty();
        }
        if (immediately || this.recipeCheckCooldown-- <= 0) {
            this.recipeCheckCooldown = 20;
            if (this.inventoryChanged) {
                this.okToCheck.clear();
                this.okToCheck.addAll(this.recipes);
            }
            Iterator<RecipeChecker<CustomMachineRecipe>> iterator = this.okToCheck.iterator();
            while (iterator.hasNext()) {
                RecipeChecker<CustomMachineRecipe> checker = iterator.next();
                if (!this.inventoryChanged && checker.isInventoryRequirementsOnly()) continue;
                if (checker.check(this.tile, context.setRecipe(checker.getRecipe()), this.inventoryChanged)) {
                    this.setInventoryChanged(false);
                    return Optional.of(checker.getRecipe());
                }
                if (checker.isInventoryRequirementsOk()) continue;
                iterator.remove();
            }
            this.setInventoryChanged(false);
        }
        return Optional.empty();
    }

    public void setInventoryChanged(boolean changed) {
        this.inventoryChanged = changed;
    }
}

