/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import dev.architectury.registry.menu.MenuRegistry;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.LightMachineComponent;
import fr.frinn.custommachinery.common.component.MachineComponentManager;
import fr.frinn.custommachinery.common.component.RedstoneMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.SRefreshCustomMachineTilePacket;
import fr.frinn.custommachinery.common.util.MachineBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.Optional;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3738;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public abstract class CustomMachineBlock
extends class_2248
implements class_2343 {
    private static final class_4970.class_4972<class_1299<?>> spawnPredicate = (state, level, pos, type) -> state.method_26206(level, pos, class_2350.field_11036) && ((CustomMachineBlock)((Object)((Object)Registration.CUSTOM_MACHINE_BLOCK.get()))).getLightEmission(state, level, pos) < 14;

    public CustomMachineBlock() {
        super(class_4970.class_2251.method_9637((class_3614)class_3614.field_15914).method_29292().method_9632(3.5f).method_22488().method_9624().method_26235(spawnPredicate));
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof CustomMachineTile) {
            final CustomMachineTile machine = (CustomMachineTile)tile;
            if (machine.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).map(h -> (FluidComponentHandler)h).map(fluidHandler -> fluidHandler.getCommonFluidHandler().interactWithFluidHandler(player, hand)).orElse(false).booleanValue()) {
                return class_1269.field_5812;
            }
            if (!level.method_8608() && !machine.getMachine().getGuiElements().isEmpty()) {
                MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (class_3908)new class_3908(){

                    public class_2561 method_5476() {
                        return machine.getMachine().getName();
                    }

                    public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
                        return new CustomMachineContainer(id, inv, machine);
                    }
                }, buf -> buf.method_10807(pos));
                return class_1269.field_5812;
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, level, pos, player, hand, hit);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        CustomMachineItem.getMachine(stack).ifPresent(machine -> {
            class_2586 tile = level.method_8321(pos);
            if (tile instanceof CustomMachineTile) {
                ((CustomMachineTile)tile).setId(machine.getId());
                if (!level.method_8608() && level.method_8503() != null && placer != null && placer.method_5998(class_1268.field_5810) == stack) {
                    level.method_8503().method_18858((Runnable)new class_3738(1, () -> new SRefreshCustomMachineTilePacket(pos, machine.getId()).sendToChunkListeners(level.method_8500(pos))));
                }
            }
        });
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof CustomMachineTile) {
            CustomMachineTile customMachineTile = (CustomMachineTile)tile;
            CustomMachine machine = customMachineTile.getMachine();
            return CustomMachineItem.makeMachineItem(machine.getId());
        }
        return super.method_9574(level, pos, state);
    }

    public void method_9556(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_1799 tool) {
        super.method_9556(level, player, pos, state, blockEntity, tool);
        if (!level.field_9236 && !player.method_7337() && blockEntity instanceof CustomMachineTile) {
            CustomMachineTile machine = (CustomMachineTile)blockEntity;
            machine.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).ifPresent(handler -> handler.getComponents().stream().map(ItemMachineComponent::getItemStack).filter(stack -> stack != class_1799.field_8037).forEach(stack -> class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack)));
            if (player.method_7305((class_2680)MachineBlockState.CACHE.getUnchecked((Object)machine.getMachine().getAppearance(machine.getStatus())))) {
                class_1264.method_5449((class_1937)level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)CustomMachineItem.makeMachineItem(machine.getId()));
            }
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12481});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)context.method_8042().method_10153());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return PlatformHelper.createMachineTile(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.method_8608()) {
            return Utils.createTickerHelper(type, (class_2591)Registration.CUSTOM_MACHINE_TILE.get(), CustomMachineTile::clientTick);
        }
        return Utils.createTickerHelper(type, (class_2591)Registration.CUSTOM_MACHINE_TILE.get(), CustomMachineTile::serverTick);
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof CustomMachineTile) {
            return ((CustomMachineTile)tile).getComponentManager().getComponent((MachineComponentType)((Object)Registration.REDSTONE_MACHINE_COMPONENT.get())).map(RedstoneMachineComponent::getComparatorInput).orElse(0);
        }
        return 0;
    }

    public int method_9603(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof CustomMachineTile) {
            return ((CustomMachineTile)tile).getComponentManager().getComponent((MachineComponentType)((Object)Registration.REDSTONE_MACHINE_COMPONENT.get())).map(RedstoneMachineComponent::getPowerOutput).orElse(0);
        }
        return 0;
    }

    public int method_9524(class_2680 state, class_1922 level, class_2338 pos, class_2350 side) {
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof CustomMachineTile) {
            return ((CustomMachineTile)tile).getComponentManager().getComponent((MachineComponentType)((Object)Registration.REDSTONE_MACHINE_COMPONENT.get())).map(RedstoneMachineComponent::getPowerOutput).orElse(0);
        }
        return 0;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
        return Optional.ofNullable(level.method_8321(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> (CustomMachineTile)tile).map(tile -> tile.getMachine().getAppearance(tile.getStatus())).map(appearance -> Float.valueOf(Utils.getMachineBreakSpeed(appearance, level, pos, player))).orElse(Float.valueOf(super.method_9594(state, player, level, pos))).floatValue();
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return Optional.ofNullable(level.method_8321(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getMachine().getAppearance(((CustomMachineTile)tile).getStatus()).getShape().apply((class_2350)state.method_11654((class_2769)class_2741.field_12481))).orElse(super.method_9530(state, level, pos, context));
    }

    public float getExplosionResistance(class_2680 state, class_1922 level, class_2338 pos, class_1927 explosion) {
        return Optional.ofNullable(level.method_8321(pos)).filter(tile -> tile instanceof CustomMachineTile).map(tile -> Float.valueOf(((CustomMachineTile)tile).getMachine().getAppearance(((CustomMachineTile)tile).getStatus()).getResistance())).orElse(Float.valueOf(super.method_9520())).floatValue();
    }

    public class_2498 getSoundType(class_2680 state, class_4538 level, class_2338 pos, @Nullable class_1297 entity) {
        return Optional.ofNullable(level.method_8321(pos)).filter(blockEntity -> blockEntity instanceof CustomMachineTile).map(tile -> ((CustomMachineTile)tile).getMachine().getAppearance(((CustomMachineTile)tile).getStatus()).getInteractionSound()).orElse(super.method_9573(state));
    }

    public int getLightEmission(class_2680 state, class_1922 level, class_2338 pos) {
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof CustomMachineTile) {
            MachineComponentManager manager = ((CustomMachineTile)tile).getComponentManager();
            return manager.getComponent((MachineComponentType)((Object)Registration.LIGHT_MACHINE_COMPONENT.get())).map(LightMachineComponent::getMachineLight).orElse(0);
        }
        return 0;
    }
}

