/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.variant.item.DefaultItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.ResultItemComponentVariant;
import fr.frinn.custommachinery.common.component.variant.item.UpgradeItemComponentVariant;
import fr.frinn.custommachinery.common.crafting.craft.CraftProcessor;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.network.SyncableContainer;
import fr.frinn.custommachinery.common.util.ResultSlotItemComponent;
import fr.frinn.custommachinery.common.util.SlotItemComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3914;
import net.minecraft.class_3917;

public class CustomMachineContainer
extends SyncableContainer {
    private final class_1661 playerInv;
    private final int firstComponentSlotIndex;
    private final CustomMachineTile tile;
    private boolean hasPlayerInventory = false;
    private final List<SlotItemComponent> inputSlotComponents = new ArrayList<SlotItemComponent>();

    public CustomMachineContainer(int id, class_1661 playerInv, CustomMachineTile tile) {
        super((class_3917)Registration.CUSTOM_MACHINE_CONTAINER.get(), id, tile, playerInv.field_7546);
        this.playerInv = playerInv;
        this.tile = tile;
        CustomMachine machine = tile.getMachine();
        AtomicInteger slotIndex = new AtomicInteger(0);
        machine.getGuiElements().stream().filter(element -> element.getType() == Registration.PLAYER_INVENTORY_GUI_ELEMENT.get()).findFirst().ifPresent(element -> {
            this.hasPlayerInventory = true;
            int x = element.getX() + 1;
            int y = element.getY() + 1;
            for (int k = 0; k < 9; ++k) {
                this.addSyncedSlot(new class_1735((class_1263)playerInv, slotIndex.getAndIncrement(), x + k * 18, y + 58));
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSyncedSlot(new class_1735((class_1263)playerInv, slotIndex.getAndIncrement(), x + j * 18, y + i * 18));
                }
            }
        });
        this.firstComponentSlotIndex = slotIndex.get();
        machine.getGuiElements().stream().filter(element -> element.getType() == Registration.SLOT_GUI_ELEMENT.get()).map(element -> (SlotGuiElement)element).forEach(element -> this.tile.getComponentManager().getComponentHandler((MachineComponentType)((Object)((Object)Registration.ITEM_MACHINE_COMPONENT.get()))).flatMap(itemHandler -> itemHandler.getComponentForID(element.getID())).ifPresent(component -> {
            int x = element.getX();
            int y = element.getY();
            int width = element.getWidth();
            int height = element.getHeight();
            int slotX = x + (width - 16) / 2;
            int slotY = y + (height - 16) / 2;
            SlotItemComponent slotComponent = component.getVariant() == ResultItemComponentVariant.INSTANCE ? new ResultSlotItemComponent((ItemMachineComponent)component, slotIndex.getAndIncrement(), slotX, slotY) : new SlotItemComponent((ItemMachineComponent)component, slotIndex.getAndIncrement(), slotX, slotY);
            this.method_7621(slotComponent);
            if (component.getVariant() != DefaultItemComponentVariant.INSTANCE || component.getMode().isInput()) {
                this.inputSlotComponents.add(slotComponent);
            }
        }));
    }

    public CustomMachineContainer(int id, class_1661 playerInv, class_2540 extraData) {
        this(id, playerInv, ClientHandler.getClientSideCustomMachineTile(extraData.method_10811()));
    }

    public CustomMachineTile getTile() {
        return this.tile;
    }

    public void method_7593(int slotId, int dragType, class_1713 clickTypeIn, class_1657 player) {
        this.tile.method_5431();
        super.method_7593(slotId, dragType, clickTypeIn, player);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        if (!this.hasPlayerInventory) {
            return class_1799.field_8037;
        }
        class_1735 clickedSlot = (class_1735)this.field_7761.get(index);
        if (clickedSlot.method_7677().method_7960()) {
            return class_1799.field_8037;
        }
        if (clickedSlot.field_7871 == this.playerInv) {
            class_1799 stack = clickedSlot.method_7677().method_7972();
            List<SlotItemComponent> components = CustomMachinery.UPGRADES.getUpgradesForItemAndMachine(stack.method_7909(), this.tile.getId()).isEmpty() ? this.inputSlotComponents : this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getVariant() == UpgradeItemComponentVariant.INSTANCE ? -1 : 1)).toList();
            for (SlotItemComponent slotComponent2 : components) {
                int maxInput = slotComponent2.getComponent().insert(stack.method_7909(), stack.method_7947(), stack.method_7969(), true, true);
                if (maxInput > 0) {
                    int toInsert = Math.min(maxInput, stack.method_7947());
                    slotComponent2.getComponent().insert(stack.method_7909(), toInsert, stack.method_7969(), false, true);
                    stack.method_7934(toInsert);
                }
                if (!stack.method_7960()) continue;
                break;
            }
            if (stack.method_7960()) {
                clickedSlot.method_7671(clickedSlot.method_7677().method_7947());
            } else {
                clickedSlot.method_7671(clickedSlot.method_7677().method_7947() - stack.method_7947());
            }
        } else {
            class_1799 removed;
            if (!(clickedSlot instanceof SlotItemComponent)) {
                return class_1799.field_8037;
            }
            SlotItemComponent slotComponent = (SlotItemComponent)clickedSlot;
            if (slotComponent instanceof ResultSlotItemComponent) {
                ResultSlotItemComponent resultSlot = (ResultSlotItemComponent)slotComponent;
                IProcessor slotComponent2 = this.tile.getProcessor();
                if (slotComponent2 instanceof CraftProcessor) {
                    CraftProcessor processor = (CraftProcessor)slotComponent2;
                    class_1799 removed2 = slotComponent.method_7677();
                    if (!this.playerInv.method_7394(removed2)) {
                        return class_1799.field_8037;
                    }
                    slotComponent.method_7668();
                    while (processor.bulkCraft()) {
                        removed2 = slotComponent.method_7677();
                        if (!this.playerInv.method_7394(removed2)) {
                            return class_1799.field_8037;
                        }
                        slotComponent.method_7668();
                    }
                    return class_1799.field_8037;
                }
            }
            if (!this.method_7616(removed = slotComponent.method_7677(), 0, this.firstComponentSlotIndex - 1, false)) {
                return class_1799.field_8037;
            }
            slotComponent.method_7668();
        }
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return CustomMachineContainer.method_17695((class_3914)class_3914.method_17392((class_1937)player.field_6002, (class_2338)this.tile.method_11016()), (class_1657)player, (class_2248)((class_2248)Registration.CUSTOM_MACHINE_BLOCK.get()));
    }

    @Override
    public boolean needFullSync() {
        return this.tile.method_10997() != null && this.tile.method_10997().method_8510() % 100L == 0L;
    }

    public void elementClicked(int element, byte button) {
        if (element < 0 || element >= this.tile.getMachine().getGuiElements().size()) {
            throw new IllegalArgumentException("Invalid gui element ID: " + element);
        }
        this.tile.getMachine().getGuiElements().get(element).handleClick(button, this.tile);
    }
}

