/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.crafting.ComponentNotFoundException;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.DummyComponentManager;
import fr.frinn.custommachinery.common.component.MachineComponentManager;
import fr.frinn.custommachinery.common.crafting.DummyProcessor;
import fr.frinn.custommachinery.common.crafting.UpgradeManager;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.network.SRefreshCustomMachineTilePacket;
import fr.frinn.custommachinery.common.network.SUpdateMachineStatusPacket;
import fr.frinn.custommachinery.common.network.syncable.StringSyncable;
import fr.frinn.custommachinery.common.util.MachineList;
import fr.frinn.custommachinery.common.util.SoundManager;
import fr.frinn.custommachinery.common.util.TextComponentUtils;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class CustomMachineTile
extends MachineTile
implements ISyncableStuff {
    public static final class_2960 DUMMY = new class_2960("custommachinery", "dummy");
    private class_2960 id = DUMMY;
    private boolean paused = false;
    private IProcessor processor = new DummyProcessor(this);
    private MachineComponentManager componentManager = new DummyComponentManager(this);
    private final UpgradeManager upgradeManager = new UpgradeManager(this);
    private SoundManager soundManager;
    private MachineStatus status = MachineStatus.IDLE;
    private class_2561 errorMessage = class_2585.field_24366;

    public CustomMachineTile(class_2338 pos, class_2680 state) {
        super((class_2591)Registration.CUSTOM_MACHINE_TILE.get(), pos, state);
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setId(class_2960 id) {
        this.id = id;
        this.processor = this.getMachine().getProcessorTemplate().build(this);
        this.componentManager = new MachineComponentManager(this.getMachine().getComponentTemplates(), this);
    }

    @Override
    public CustomMachine getMachine() {
        CustomMachine machine = CustomMachinery.MACHINES.get(this.getId());
        if (machine != null) {
            return machine;
        }
        return CustomMachine.DUMMY;
    }

    @Override
    public MachineStatus getStatus() {
        return this.status;
    }

    @Override
    public class_2561 getMessage() {
        return this.errorMessage;
    }

    @Override
    public void setStatus(MachineStatus status, class_2561 message) {
        if (this.status != status) {
            this.status = status;
            this.errorMessage = message;
            this.method_5431();
            if (this.method_10997() != null && !this.method_10997().method_8608()) {
                class_2338 pos = this.method_11016();
                new SUpdateMachineStatusPacket(pos, this.status).sendToChunkListeners(this.method_10997().method_8500(pos));
            }
        }
    }

    @Override
    public void refreshMachine(@Nullable class_2960 id) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_2487 craftingManagerNBT = this.processor.serialize();
        class_2487 componentManagerNBT = this.componentManager.serializeNBT();
        if (id == null) {
            id = this.getId();
        }
        this.setId(id);
        this.processor.deserialize(craftingManagerNBT);
        this.componentManager.deserializeNBT(componentManagerNBT);
        new SRefreshCustomMachineTilePacket(this.field_11867, id).sendToChunkListeners(this.field_11863.method_8500(this.field_11867));
    }

    @Override
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void resetProcess() {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.processor.reset();
    }

    @Override
    public MachineComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    @Override
    public IProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public MachineAppearance getAppearance() {
        return this.getMachine().getAppearance(this.getStatus());
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, CustomMachineTile tile) {
        if (tile.componentManager == null || tile.processor == null) {
            return;
        }
        level.method_16107().method_15396("Component tick");
        tile.componentManager.serverTick();
        level.method_16107().method_15405("Crafting Manager tick");
        try {
            tile.processor.tick();
        }
        catch (ComponentNotFoundException e) {
            CustomMachinery.LOGGER.error(e.getMessage());
            tile.setPaused(true);
        }
        level.method_16107().method_15407();
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, CustomMachineTile tile) {
        if (tile.componentManager == null || tile.processor == null) {
            return;
        }
        tile.componentManager.clientTick();
        if (tile.soundManager == null) {
            tile.soundManager = new SoundManager(pos);
        }
        if (tile.getAppearance().getAmbientSound() != ((MachineAppearanceProperty)((Object)Registration.AMBIENT_SOUND_PROPERTY.get())).getDefaultValue() && !tile.getAppearance().getAmbientSound().method_14833().equals((Object)tile.soundManager.getSoundID())) {
            tile.soundManager.setSound(tile.getMachine().getAppearance(tile.getStatus()).getAmbientSound());
        }
        if (!tile.soundManager.isPlaying()) {
            tile.soundManager.play();
        }
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        MachineList.addMachine(this);
    }

    public void method_11012() {
        if (this.field_11863 != null && this.field_11863.method_8608() && this.soundManager != null) {
            this.soundManager.stop();
        }
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.componentManager.getComponents().values().forEach(IMachineComponent::onRemoved);
        }
        super.method_11012();
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10582("machineID", this.id.toString());
        nbt.method_10566("craftingManager", (class_2520)this.processor.serialize());
        nbt.method_10566("componentManager", (class_2520)this.componentManager.serializeNBT());
        nbt.method_10582("status", this.status.toString());
        nbt.method_10582("message", TextComponentUtils.toJsonString(this.errorMessage));
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10573("machineID", 8) && this.getMachine() == CustomMachine.DUMMY) {
            this.setId(new class_2960(nbt.method_10558("machineID")));
        }
        if (nbt.method_10573("craftingManager", 10)) {
            this.processor.deserialize(nbt.method_10562("craftingManager"));
        }
        if (nbt.method_10573("componentManager", 10)) {
            this.componentManager.deserializeNBT(nbt.method_10562("componentManager"));
        }
        if (nbt.method_10573("status", 8)) {
            this.setStatus(MachineStatus.value(nbt.method_10558("status")));
        }
        if (nbt.method_10573("message", 8)) {
            this.errorMessage = TextComponentUtils.fromJsonString(nbt.method_10558("message"));
        }
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10582("machineID", this.getId().toString());
        nbt.method_10582("status", this.status.toString());
        nbt.method_10582("message", TextComponentUtils.toJsonString(this.errorMessage));
        return nbt;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        IProcessor iProcessor = this.processor;
        if (iProcessor instanceof ISyncableStuff) {
            ISyncableStuff syncableProcessor = (ISyncableStuff)((Object)iProcessor);
            syncableProcessor.getStuffToSync(container);
        }
        this.componentManager.getStuffToSync(container);
        container.accept(StringSyncable.create(() -> this.status.toString(), status -> {
            this.status = MachineStatus.value(status);
        }));
        container.accept(StringSyncable.create(() -> class_2561.class_2562.method_10867((class_2561)this.errorMessage), errorMessage -> {
            this.errorMessage = class_2561.class_2562.method_10877((String)errorMessage);
        }));
    }
}

