/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class StructureCreatorItem
extends class_1792 {
    private static final Codec<List<List<String>>> PATTERN_CODEC = Codec.STRING.listOf().listOf();
    private static final Codec<Map<Character, PartialBlockState>> KEYS_CODEC = Codec.unboundedMap(Codecs.CHARACTER_CODEC, Codecs.PARTIAL_BLOCK_STATE_CODEC);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public StructureCreatorItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean method_7886(class_1799 stack) {
        return true;
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() == null) {
            return class_1269.field_5814;
        }
        if (context.method_8045().method_8608()) {
            return super.method_7884(context);
        }
        class_2338 pos = context.method_8037();
        class_2680 state = context.method_8045().method_8320(pos);
        class_1799 stack = context.method_8041();
        if (state.method_27852((class_2248)Registration.CUSTOM_MACHINE_BLOCK.get())) {
            this.finishStructure(stack, pos, (class_2350)state.method_11654((class_2769)class_2741.field_12481), (class_3222)context.method_8036());
            return class_1269.field_5812;
        }
        if (!StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
            StructureCreatorItem.addSelectedBlock(stack, pos);
            return class_1269.field_5812;
        }
        if (StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
            StructureCreatorItem.removeSelectedBlock(stack, pos);
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        int amount = StructureCreatorItem.getSelectedBlocks(stack).size();
        if (amount <= 0) {
            tooltip.add((class_2561)new class_2588("custommachinery.structure_creator.no_blocks").method_27692(class_124.field_1061));
        } else {
            tooltip.add((class_2561)new class_2588("custommachinery.structure_creator.amount", new Object[]{StructureCreatorItem.getSelectedBlocks(stack).size()}).method_27692(class_124.field_1078));
        }
        tooltip.add((class_2561)new class_2588("custommachinery.structure_creator.select").method_27692(class_124.field_1060));
        tooltip.add((class_2561)new class_2588("custommachinery.structure_creator.reset").method_27692(class_124.field_1065));
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (player.method_18276() && player.method_5998(hand).method_7909() == this) {
            class_1799 stack = player.method_5998(hand);
            stack.method_7983("custommachinery");
            return class_1271.method_22427((Object)stack);
        }
        return super.method_7836(level, player, hand);
    }

    public static List<class_2338> getSelectedBlocks(class_1799 stack) {
        return Arrays.stream(stack.method_7911("custommachinery").method_10565("blocks")).mapToObj(class_2338::method_10092).collect(Collectors.toList());
    }

    public static void addSelectedBlock(class_1799 stack, class_2338 pos) {
        long packed = pos.method_10063();
        long[] posList = stack.method_7911("custommachinery").method_10565("blocks");
        long[] newList = new long[posList.length + 1];
        System.arraycopy(posList, 0, newList, 0, posList.length);
        newList[posList.length] = packed;
        stack.method_7911("custommachinery").method_10564("blocks", newList);
    }

    public static void removeSelectedBlock(class_1799 stack, class_2338 pos) {
        long packed = pos.method_10063();
        long[] posList = stack.method_7911("custommachinery").method_10565("blocks");
        long[] newList = Arrays.stream(posList).filter(l -> l != packed).toArray();
        stack.method_7911("custommachinery").method_10564("blocks", newList);
    }

    private void finishStructure(class_1799 stack, class_2338 machinePos, class_2350 machineFacing, class_3222 player) {
        List<class_2338> blocks = StructureCreatorItem.getSelectedBlocks(stack);
        blocks.add(machinePos);
        if (blocks.size() <= 1) {
            player.method_9203((class_2561)new class_2588("custommachinery.structure_creator.no_blocks"), class_156.field_25140);
            return;
        }
        class_1937 world = player.field_6002;
        PartialBlockState[][][] states = this.getStructureArray(blocks, machineFacing, world);
        HashBiMap keys = HashBiMap.create();
        AtomicInteger charIndex = new AtomicInteger(97);
        Arrays.stream(states).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(state -> !state.getBlockState().method_27852((class_2248)Registration.CUSTOM_MACHINE_BLOCK.get()) && state != PartialBlockState.ANY).distinct().forEach(state -> {
            if (charIndex.get() == 109) {
                charIndex.incrementAndGet();
            }
            keys.put((Object)Character.valueOf((char)charIndex.getAndIncrement()), state);
            if (charIndex.get() == 122) {
                charIndex.set(65);
            }
        });
        ArrayList pattern = new ArrayList();
        for (int i = 0; i < states.length; ++i) {
            ArrayList<String> floor = new ArrayList<String>();
            for (int j = 0; j < states[i].length; ++j) {
                StringBuilder row = new StringBuilder();
                for (int k = 0; k < states[i][j].length; ++k) {
                    PartialBlockState partial = states[i][j][k];
                    int key = partial.getBlockState().method_27852((class_2248)Registration.CUSTOM_MACHINE_BLOCK.get()) ? 109 : (partial == PartialBlockState.ANY ? 32 : (keys.containsValue((Object)partial) ? (int)((Character)keys.inverse().get((Object)partial)).charValue() : 63));
                    row.append((char)key);
                }
                floor.add(row.toString());
            }
            pattern.add(floor);
        }
        JsonElement keysJson = (JsonElement)KEYS_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)keys).result().orElseThrow(IllegalStateException::new);
        JsonElement patternJson = (JsonElement)PATTERN_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, pattern).result().orElseThrow(IllegalStateException::new);
        JsonObject both = new JsonObject();
        both.add("keys", keysJson);
        both.add("pattern", patternJson);
        String ctKubeString = ".requireStructure(" + patternJson.toString() + ", " + keysJson.toString() + ")";
        class_5250 jsonText = new class_2585("[JSON]").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1054}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(both.toString()))).method_10958(new class_2558(class_2558.class_2559.field_21462, both.toString())));
        class_5250 prettyJsonText = new class_2585("[PRETTY JSON]").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1065}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(GSON.toJson((JsonElement)both)))).method_10958(new class_2558(class_2558.class_2559.field_21462, GSON.toJson((JsonElement)both))));
        class_5250 crafttweakerText = new class_2585("[CRAFTTWEAKER]").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1075}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(ctKubeString))).method_10958(new class_2558(class_2558.class_2559.field_21462, ctKubeString)));
        class_5250 kubeJSText = new class_2585("[KUBEJS]").method_27694(style -> style.method_27705(new class_124[]{class_124.field_1064}).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(ctKubeString))).method_10958(new class_2558(class_2558.class_2559.field_21462, ctKubeString)));
        class_2588 message = new class_2588("custommachinery.structure_creator.message", new Object[]{jsonText, prettyJsonText, crafttweakerText, kubeJSText});
        player.method_9203((class_2561)message, class_156.field_25140);
    }

    private PartialBlockState[][][] getStructureArray(List<class_2338> blocks, class_2350 machineFacing, class_1937 world) {
        int minX = blocks.stream().mapToInt(class_2382::method_10263).min().orElseThrow(IllegalStateException::new);
        int maxX = blocks.stream().mapToInt(class_2382::method_10263).max().orElseThrow(IllegalStateException::new);
        int minY = blocks.stream().mapToInt(class_2382::method_10264).min().orElseThrow(IllegalStateException::new);
        int maxY = blocks.stream().mapToInt(class_2382::method_10264).max().orElseThrow(IllegalStateException::new);
        int minZ = blocks.stream().mapToInt(class_2382::method_10260).min().orElseThrow(IllegalStateException::new);
        int maxZ = blocks.stream().mapToInt(class_2382::method_10260).max().orElseThrow(IllegalStateException::new);
        PartialBlockState[][][] states = machineFacing.method_10166() == class_2350.class_2351.field_11048 ? new PartialBlockState[maxY - minY + 1][maxX - minX + 1][maxZ - minZ + 1] : new PartialBlockState[maxY - minY + 1][maxZ - minZ + 1][maxX - minX + 1];
        class_238 box = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        HashMap cache = new HashMap();
        class_2338.method_29715((class_238)box).forEach(p -> {
            PartialBlockState partial;
            class_2680 state = world.method_8320(p);
            if (!blocks.contains(p)) {
                partial = PartialBlockState.ANY;
            } else if (cache.containsKey(state)) {
                partial = (PartialBlockState)cache.get(state);
            } else {
                partial = new PartialBlockState(state, Lists.newArrayList((Iterable)state.method_28501()), Optional.ofNullable(world.method_8321(p)).map(class_2586::method_38242).orElse(null));
                cache.put(state, partial);
            }
            switch (machineFacing) {
                case field_11039: {
                    states[p.method_10264() - minY][p.method_10263() - minX][p.method_10260() - minZ] = partial;
                    break;
                }
                case field_11034: {
                    states[p.method_10264() - minY][maxX - p.method_10263()][maxZ - p.method_10260()] = partial;
                    break;
                }
                case field_11035: {
                    states[p.method_10264() - minY][p.method_10260() - minZ][p.method_10263() - minX] = partial;
                    break;
                }
                case field_11043: {
                    states[p.method_10264() - minY][maxZ - p.method_10260()][maxX - p.method_10263()] = partial;
                }
            }
        });
        return states;
    }
}

