/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import fr.frinn.custommachinery.api.requirement.IChanceableRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipeBuilder;
import fr.frinn.custommachinery.common.integration.crafttweaker.CustomMachineRecipeCTManager;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.BiomeRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.BlockRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.CommandRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.DimensionRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.DropRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.DurabilityRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EffectRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EnergyPerTickRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EnergyRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EntityRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FluidPerTickRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FluidRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FuelRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FunctionRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.ItemRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.ItemTransformRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.LightRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.LootTableRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.PositionRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.RedstoneRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.StructureRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.TimeRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.WeatherRequirementCT;
import net.minecraft.class_151;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.CMRecipeBuilder")
public class CustomMachineRecipeCTBuilder
implements EnergyRequirementCT<CustomMachineRecipeCTBuilder>,
EnergyPerTickRequirementCT<CustomMachineRecipeCTBuilder>,
FluidRequirementCT<CustomMachineRecipeCTBuilder>,
FluidPerTickRequirementCT<CustomMachineRecipeCTBuilder>,
ItemRequirementCT<CustomMachineRecipeCTBuilder>,
ItemTransformRequirementCT<CustomMachineRecipeCTBuilder>,
DurabilityRequirementCT<CustomMachineRecipeCTBuilder>,
TimeRequirementCT<CustomMachineRecipeCTBuilder>,
PositionRequirementCT<CustomMachineRecipeCTBuilder>,
BiomeRequirementCT<CustomMachineRecipeCTBuilder>,
DimensionRequirementCT<CustomMachineRecipeCTBuilder>,
FuelRequirementCT<CustomMachineRecipeCTBuilder>,
CommandRequirementCT<CustomMachineRecipeCTBuilder>,
EffectRequirementCT<CustomMachineRecipeCTBuilder>,
WeatherRequirementCT<CustomMachineRecipeCTBuilder>,
RedstoneRequirementCT<CustomMachineRecipeCTBuilder>,
EntityRequirementCT<CustomMachineRecipeCTBuilder>,
LightRequirementCT<CustomMachineRecipeCTBuilder>,
BlockRequirementCT<CustomMachineRecipeCTBuilder>,
StructureRequirementCT<CustomMachineRecipeCTBuilder>,
LootTableRequirementCT<CustomMachineRecipeCTBuilder>,
DropRequirementCT<CustomMachineRecipeCTBuilder>,
FunctionRequirementCT<CustomMachineRecipeCTBuilder> {
    private static int index = 0;
    private final CustomMachineRecipeBuilder builder;
    private IRequirement<?> lastRequirement;
    private boolean jei = false;

    public CustomMachineRecipeCTBuilder(CustomMachineRecipeBuilder builder) {
        this.builder = builder;
    }

    @ZenCodeType.Method
    public static CustomMachineRecipeCTBuilder create(String machine, int time) {
        try {
            return new CustomMachineRecipeCTBuilder(new CustomMachineRecipeBuilder(new class_2960(machine), time));
        }
        catch (class_151 e) {
            throw new IllegalArgumentException("Invalid Machine name: " + machine + "\n" + e.getMessage());
        }
    }

    @ZenCodeType.Method
    public void build(@ZenCodeType.OptionalString String name) {
        class_2960 recipeID;
        try {
            recipeID = !name.isEmpty() ? new class_2960("crafttweaker", name) : new class_2960("crafttweaker", "custom_machine_recipe_" + index++);
        }
        catch (class_151 e) {
            throw new IllegalArgumentException("Invalid Recipe name: " + name + "\n" + e.getMessage());
        }
        CustomMachineRecipe recipe = this.builder.build(recipeID);
        ActionAddRecipe action = new ActionAddRecipe((IRecipeManager)CustomMachineRecipeCTManager.INSTANCE, (class_1860)recipe);
        CraftTweakerAPI.apply((IAction)action);
    }

    @Override
    public CustomMachineRecipeCTBuilder addRequirement(IRequirement<?> requirement) {
        this.lastRequirement = requirement;
        if (!this.jei) {
            this.builder.withRequirement((IRequirement)requirement);
        } else {
            this.builder.withJeiRequirement((IRequirement)requirement);
        }
        return this;
    }

    @Override
    public CustomMachineRecipeCTBuilder error(String error, Object ... args) {
        CraftTweakerAPI.LOGGER.error(error, args);
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder chance(double chance) {
        if (this.lastRequirement != null && this.lastRequirement instanceof IChanceableRequirement) {
            ((IChanceableRequirement)this.lastRequirement).setChance(chance);
        } else {
            CraftTweakerAPI.LOGGER.error("Can't set chance for requirement: " + this.lastRequirement);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder hide() {
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder delay(double delay) {
        if (this.lastRequirement != null && this.lastRequirement instanceof IDelayedRequirement) {
            ((IDelayedRequirement)this.lastRequirement).setDelay(delay);
        } else {
            CraftTweakerAPI.LOGGER.error("Can't put delay for requirement: " + this.lastRequirement);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder jei() {
        this.jei = true;
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder priority(int priority) {
        if (!this.jei) {
            this.builder.withPriority(priority);
        } else {
            this.builder.withJeiPriority(priority);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder resetOnError() {
        this.builder.setResetOnError();
        return this;
    }
}

