/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.platform.Services;
import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.integration.crafttweaker.RequirementTypeCTBrackets;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.CMUpgradeBuilder")
public class CustomMachineUpgradeCTBuilder {
    private final class_1792 item;
    private List<class_2561> tooltips;
    private final List<class_2960> machines;
    private final List<RecipeModifier> modifiers;
    private final int maxAmount;

    public CustomMachineUpgradeCTBuilder(class_1792 item, int maxAmount) {
        this.item = item;
        this.tooltips = Collections.singletonList(new class_2588("custommachinery.upgrade.tooltip").method_27692(class_124.field_1075));
        this.maxAmount = maxAmount;
        this.machines = new ArrayList<class_2960>();
        this.modifiers = new ArrayList<RecipeModifier>();
    }

    @ZenCodeType.Method
    public static CustomMachineUpgradeCTBuilder create(class_1792 item, @ZenCodeType.OptionalInt(value=64) int maxAmount) {
        return new CustomMachineUpgradeCTBuilder(item, maxAmount);
    }

    @ZenCodeType.Method
    public void build() {
        if (this.machines.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 machine for machine upgrade item: " + Services.REGISTRY.getRegistryKey(this.item));
        }
        if (this.modifiers.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 recipe modifier for machine upgrade item: " + Services.REGISTRY.getRegistryKey(this.item));
        }
        MachineUpgrade upgrade = new MachineUpgrade(this.item, this.machines, this.modifiers, this.tooltips, this.maxAmount);
        CraftTweakerAPI.apply((IAction)new AddMachineUpgradeAction(upgrade));
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder machine(String ... string) {
        for (String s : string) {
            class_2960 machine;
            try {
                machine = new class_2960(s);
            }
            catch (class_151 e) {
                throw new IllegalArgumentException("Invalid Machine ID: " + s + "\n" + e.getMessage());
            }
            this.machines.add(machine);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder tooltip(String ... strings) {
        ImmutableList.Builder tooltips = ImmutableList.builder();
        for (String tooltip : strings) {
            try {
                class_5250 component = class_2561.class_2562.method_10877((String)tooltip);
                if (component == null) {
                    throw new IllegalArgumentException("");
                }
                tooltips.add((Object)component);
            }
            catch (Exception e) {
                tooltips.add((Object)new class_2588(tooltip));
            }
        }
        this.tooltips = tooltips.build();
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder tooltip(class_2561 ... components) {
        this.tooltips = ImmutableList.copyOf((Object[])components);
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder modifier(CTRecipeModifierBuilder builder) {
        this.modifiers.add(builder.build());
        return this;
    }

    public static class AddMachineUpgradeAction
    implements IRuntimeAction {
        private final MachineUpgrade upgrade;

        public AddMachineUpgradeAction(MachineUpgrade upgrade) {
            this.upgrade = upgrade;
        }

        public void apply() {
            CustomMachinery.UPGRADES.addUpgrade(this.upgrade);
        }

        public String describe() {
            return "Add a custom machine upgrade for item: " + Services.REGISTRY.getRegistryKey(this.upgrade.getItem());
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.custommachinery.CMRecipeModifierBuilder")
    public static class CTRecipeModifierBuilder {
        private final RequirementType<?> requirementType;
        private final RequirementIOMode mode;
        private final IRecipeModifier.OPERATION operation;
        private final double modifier;
        private String target = "";
        private double chance = 1.0;
        private double max = Double.POSITIVE_INFINITY;
        private double min = Double.NEGATIVE_INFINITY;
        private class_2561 tooltip = null;

        private CTRecipeModifierBuilder(RequirementType<?> type, RequirementIOMode mode, IRecipeModifier.OPERATION operation, double modifier) {
            this.requirementType = type;
            this.mode = mode;
            this.operation = operation;
            this.modifier = modifier;
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder addInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder mulInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder addOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.ADDITION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder mulOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, IRecipeModifier.OPERATION.MULTIPLICATION, modifier);
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder target(String target) {
            this.target = target;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder max(double max) {
            this.max = max;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder min(double min) {
            this.min = min;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder tooltip(String tooltip) {
            try {
                this.tooltip = class_2561.class_2562.method_10877((String)tooltip);
            }
            catch (Exception e) {
                this.tooltip = new class_2588(tooltip);
            }
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder tooltip(class_2561 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        private RecipeModifier build() {
            return new RecipeModifier(this.requirementType, this.mode, this.operation, this.modifier, this.target, this.chance, this.max, this.min, this.tooltip);
        }
    }
}

