/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.function;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.platform.Services;
import dev.architectury.fluid.FluidStack;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.component.DataMachineComponent;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.Machine")
public class MachineCT {
    private final CustomMachineTile internal;
    private final MapData data;

    protected MachineCT(CustomMachineTile internal) {
        this.internal = internal;
        this.data = new MapData(((DataMachineComponent)this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.DATA_MACHINE_COMPONENT.get())).orElseThrow()).getData());
    }

    @ZenCodeType.Getter(value="id")
    @ZenCodeType.Method
    public String getId() {
        return this.internal.getId().toString();
    }

    @ZenCodeType.Getter(value="data")
    @ZenCodeType.Method
    public MapData getData() {
        return this.data;
    }

    @ZenCodeType.Getter(value="energyStored")
    @ZenCodeType.Method
    public long getEnergyStored() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(EnergyMachineComponent::getEnergy).orElse(0L);
    }

    @ZenCodeType.Setter
    @ZenCodeType.Method
    public void setEnergyStored(long energy) {
        this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).ifPresent(component -> component.setEnergy(energy));
    }

    @ZenCodeType.Getter(value="energyCapacity")
    @ZenCodeType.Method
    public long getEnergyCapacity() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(EnergyMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public int addEnergy(int toAdd, boolean simulate) {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(component -> component.receiveRecipeEnergy(toAdd, simulate)).orElse(0);
    }

    @ZenCodeType.Method
    public int removeEnergy(int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(component -> component.extractRecipeEnergy(toRemove, simulate)).orElse(0);
    }

    @ZenCodeType.Method
    public FluidStack getFluidStored(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getFluidStack).orElse(FluidStack.empty());
    }

    @ZenCodeType.Method
    public void setFluidStored(String tank, class_3611 fluid, long amount, @ZenCodeType.Optional IData data) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(x -> x.setFluidStack(FluidStack.create((class_3611)fluid, (long)amount, data == null ? null : (class_2487)data.getInternal())));
    }

    @ZenCodeType.Method
    public long getFluidCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getCapacity).orElse(0L);
    }

    @ZenCodeType.Method
    public long addFluid(class_3611 fluid, long amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.fill(FluidStack.create((class_3611)fluid, (long)amount), simulate)).orElse(amount);
    }

    @ZenCodeType.Method
    public long addFluidToTank(String tank, class_3611 fluid, long amount, boolean simulate, @ZenCodeType.Optional IData data) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.insert(fluid, amount, data == null ? null : (class_2487)data.getInternal(), simulate)).orElse(amount);
    }

    @ZenCodeType.Method
    public FluidStack removeFluid(class_3611 fluid, int amount, boolean simulate, @ZenCodeType.Optional IData data) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.drain(FluidStack.create((class_3611)fluid, (long)amount, data == null ? null : (class_2487)data.getInternal()), simulate)).orElse(FluidStack.empty());
    }

    @ZenCodeType.Method
    public FluidStack removeFluidFromTank(String tank, int amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.extract(amount, simulate)).orElse(FluidStack.empty());
    }

    @ZenCodeType.Method
    public IItemStack getItemStored(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(component -> Services.PLATFORM.createMCItemStack(component.getItemStack())).orElse(Services.PLATFORM.getEmptyIItemStack());
    }

    @ZenCodeType.Method
    public void setItemStored(String slot, IItemStack stackCT) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setItemStack(stackCT.getInternal()));
    }

    @ZenCodeType.Method
    public int getItemCapacity(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::getCapacity).orElse(0);
    }

    @ZenCodeType.Method
    public IItemStack addItemToSlot(String slot, IItemStack stackCT, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(component -> {
            int inserted = component.insert(stackCT.getDefinition(), stackCT.getAmount(), stackCT.getInternal().method_7969(), simulate, true);
            return Services.PLATFORM.createMCItemStack(Utils.makeItemStack(stackCT.getDefinition(), stackCT.getAmount() - inserted, stackCT.getInternal().method_7969()));
        }).orElse(stackCT);
    }

    @ZenCodeType.Method
    public IItemStack removeItemFromSlot(String slot, int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(component -> Services.PLATFORM.createMCItemStack(component.extract(toRemove, simulate, true))).orElse(Services.PLATFORM.getEmptyIItemStack());
    }
}

