/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.MCTag;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.crafttweaker.CTUtils;
import fr.frinn.custommachinery.common.requirement.DurabilityRequirement;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemTagIngredient;
import net.minecraft.class_1792;
import net.minecraft.class_6862;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Durability")
public interface DurabilityRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T damageItem(IItemStack stack, int amount, @ZenCodeType.OptionalString String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.getDefinition()), amount, CTUtils.nbtFromStack(stack), true, slot));
    }

    @ZenCodeType.Method
    default public T damageItemNoBreak(IItemStack stack, int amount, @ZenCodeType.OptionalString String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, new ItemIngredient(stack.getDefinition()), amount, CTUtils.nbtFromStack(stack), false, slot));
    }

    @ZenCodeType.Method
    default public T damageItemTag(MCTag tag, int amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create((class_6862<class_1792>)tag.getTagKey()), amount, CTUtils.getNBT(data), true, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    @ZenCodeType.Method
    default public T damageItemTagNoBreak(MCTag tag, int amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.INPUT, ItemTagIngredient.create((class_6862<class_1792>)tag.getTagKey()), amount, CTUtils.getNBT(data), false, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    @ZenCodeType.Method
    default public T repairItem(IItemStack stack, int amount, @ZenCodeType.OptionalString String slot) {
        return this.addRequirement(new DurabilityRequirement(RequirementIOMode.OUTPUT, new ItemIngredient(stack.getDefinition()), amount, CTUtils.nbtFromStack(stack), false, slot));
    }

    @ZenCodeType.Method
    default public T repairItemTag(MCTag tag, int amount, @ZenCodeType.Optional IData data, @ZenCodeType.OptionalString String slot) {
        try {
            return this.addRequirement(new DurabilityRequirement(RequirementIOMode.OUTPUT, ItemTagIngredient.create((class_6862<class_1792>)tag.getTagKey()), amount, CTUtils.getNBT(data), false, slot));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }
}

