/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.common.requirement.StructureRequirement;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Structure")
public interface StructureRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T requireStructure(String[][] pattern, Map<String, String> key) {
        List<List<String>> patternList = Arrays.stream(pattern).map(floors -> Arrays.stream(floors).toList()).toList();
        HashMap<Character, IIngredient<PartialBlockState>> keysMap = new HashMap<Character, IIngredient<PartialBlockState>>();
        for (Map.Entry<String, String> entry : key.entrySet()) {
            if (entry.getKey().length() != 1) {
                return this.error("Invalid structure key: {}\nMust be a single character which is not 'm'", entry.getKey());
            }
            char keyChar = entry.getKey().charAt(0);
            DataResult result = IIngredient.BLOCK.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(entry.getValue()));
            if (result.error().isPresent() || result.result().isEmpty()) {
                return this.error("Invalid structure block: {}\n{}", entry.getValue(), ((DataResult.PartialResult)result.error().get()).message());
            }
            keysMap.put(Character.valueOf(keyChar), (IIngredient)result.result().get());
        }
        return this.addRequirement(new StructureRequirement(patternList, keysMap));
    }
}

